/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.google.common.io.ByteStreams;
import com.indeed.util.mmap.DirectMemory;
import com.indeed.util.mmap.MemoryInputStream;
import com.indeed.util.mmap.NativeBuffer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;

public final class ZeroCopyOutputStream
extends OutputStream
implements DataOutput {
    private static final Logger log = Logger.getLogger(ZeroCopyOutputStream.class);
    private NativeBuffer buffer;
    private DirectMemory memory;
    private long currentAddress = 0L;

    public ZeroCopyOutputStream() {
        this(65536, ByteOrder.BIG_ENDIAN);
    }

    public ZeroCopyOutputStream(int initialSize, ByteOrder order) {
        this.buffer = new NativeBuffer(initialSize, order);
        this.memory = this.buffer.memory();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (this.currentAddress + 1L > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.writeBoolean(v);
        } else {
            this.memory.putByte(this.currentAddress, (byte)(v ? 1 : 0));
            ++this.currentAddress;
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.currentAddress + 1L > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.writeByte(v);
        } else {
            this.memory.putByte(this.currentAddress, (byte)v);
            ++this.currentAddress;
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.currentAddress + 2L > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.writeShort(v);
        } else {
            this.memory.putShort(this.currentAddress, (short)v);
            this.currentAddress += 2L;
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.currentAddress + 2L > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.writeChar(v);
        } else {
            this.memory.putChar(this.currentAddress, (char)v);
            this.currentAddress += 2L;
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.currentAddress + 4L > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.writeInt(v);
        } else {
            this.memory.putInt(this.currentAddress, v);
            this.currentAddress += 4L;
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.currentAddress + 8L > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.writeLong(v);
        } else {
            this.memory.putLong(this.currentAddress, v);
            this.currentAddress += 8L;
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.currentAddress + 4L > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.writeFloat(v);
        } else {
            this.memory.putFloat(this.currentAddress, v);
            this.currentAddress += 4L;
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.currentAddress + 8L > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.writeDouble(v);
        } else {
            this.memory.putDouble(this.currentAddress, v);
            this.currentAddress += 8L;
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUTF(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.currentAddress + (long)len > this.memory.length()) {
            this.buffer = this.buffer.realloc(this.memory.length() * 2L);
            this.memory = this.buffer.memory();
            this.write(b, off, len);
        } else {
            this.memory.putBytes(this.currentAddress, b, off, len);
            this.currentAddress += (long)len;
        }
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public long position() {
        return this.currentAddress;
    }

    public DirectMemory memory() {
        return this.memory.slice(0L, this.currentAddress);
    }

    public NativeBuffer getBuffer() {
        return this.buffer;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        MemoryInputStream in = new MemoryInputStream(this.memory());
        ByteStreams.copy((InputStream)in, (OutputStream)outputStream);
    }

    public InputStream getInputStream() {
        return new MemoryInputStream(this.memory());
    }
}

