/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteArray {
    private static final Logger log = LoggerFactory.getLogger(ByteArray.class);
    private final Memory buffer;
    private final long length;

    public ByteArray(Memory buffer, long address, long length) {
        if (address < 0L) {
            throw new IndexOutOfBoundsException("address must be >= 0");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (address + length > buffer.length()) {
            throw new IndexOutOfBoundsException("address+length must be <= buffer.length()");
        }
        this.buffer = buffer.slice(address, length);
        this.length = length;
    }

    public byte get(long index) {
        return this.buffer.getByte(index);
    }

    public void get(long index, byte[] bytes, int start, int length) {
        this.buffer.getBytes(index, bytes, start, length);
    }

    public void get(long index, ByteArray bytes, long start, long length) {
        bytes.set(start, this, index, length);
    }

    public void get(long index, ByteArray bytes) {
        this.get(index, bytes, 0L, bytes.length);
    }

    public void get(long index, byte[] bytes) {
        this.get(index, bytes, 0, bytes.length);
    }

    public void set(long index, byte value) {
        this.buffer.putByte(index, value);
    }

    public void set(long index, byte[] bytes, int start, int length) {
        this.buffer.putBytes(index, bytes, start, length);
    }

    public void set(long index, byte[] bytes) {
        this.set(index, bytes, 0, bytes.length);
    }

    public void set(long index, ByteArray bytes, long start, long length) {
        bytes.buffer.getBytes(index, this.buffer, start, length);
    }

    public void set(long index, ByteArray bytes) {
        this.set(index, bytes, 0L, bytes.length);
    }

    public long length() {
        return this.length;
    }

    public ByteArray slice(long start, long length) {
        return new ByteArray(this.buffer, start, length);
    }
}

