/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.google.common.base.Throwables;
import com.indeed.util.mmap.BufferResource;
import com.indeed.util.mmap.DirectMemory;
import com.indeed.util.mmap.LoadIndeedMMap;
import com.indeed.util.mmap.MMapBuffer;
import com.indeed.util.mmap.NativeMemoryUtils;
import com.indeed.util.unsafe.IndeedUnsafe;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NativeBuffer
implements BufferResource {
    private static final Logger log;
    private static final long MMAP_THRESHOLD;
    private static final boolean MAP_ANONYMOUS_DEV_ZERO;
    private static final boolean OS_TYPE_IS_MAC;
    private final long address;
    private final DirectMemory memory;
    private boolean closed = false;
    private final boolean mmapped;

    public NativeBuffer(long length, ByteOrder order) {
        if (length <= 0L) {
            if (length < 0L) {
                throw new IllegalArgumentException("length must be >= 0");
            }
            this.address = 0L;
            this.memory = new DirectMemory(0L, 0L, order);
            this.mmapped = false;
        } else if (length >= MMAP_THRESHOLD) {
            this.mmapped = true;
            if (MAP_ANONYMOUS_DEV_ZERO) {
                RandomAccessFile raf;
                File devZero = new File("/dev/zero");
                try {
                    raf = new RandomAccessFile(devZero, "rw");
                }
                catch (FileNotFoundException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                try {
                    this.address = MMapBuffer.mmap(length, 1, 2, MMapBuffer.extractFd(raf.getFD()), 0L);
                    if (this.address == -1L) {
                        throw new RuntimeException("mmap /dev/zero failed with error " + MMapBuffer.errno());
                    }
                    this.memory = new DirectMemory(this.address, length, order);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                finally {
                    NativeBuffer.closeQuietly(raf);
                }
            }
            this.address = MMapBuffer.mmap(length, 1, 6, -1, 0L);
            if (this.address == -1L) {
                throw new RuntimeException("anonymous mmap failed with error " + MMapBuffer.errno());
            }
            this.memory = new DirectMemory(this.address, length, order);
        } else {
            this.address = IndeedUnsafe.allocateMemory((long)length);
            if (this.address == 0L) {
                throw new OutOfMemoryError();
            }
            this.memory = new DirectMemory(this.address, length, order);
            this.mmapped = false;
        }
    }

    private NativeBuffer(long address, DirectMemory memory, boolean mmapped) {
        this.address = address;
        this.memory = memory;
        this.mmapped = mmapped;
    }

    private NativeBuffer realloc0(long newLength) {
        if (this.mmapped) {
            throw new UnsupportedOperationException();
        }
        if (newLength >= MMAP_THRESHOLD) {
            throw new UnsupportedOperationException();
        }
        if (newLength <= 0L) {
            throw new IllegalArgumentException("length must be > 0");
        }
        long newAddress = IndeedUnsafe.reallocateMemory((long)this.address, (long)newLength);
        if (this.address == 0L) {
            throw new OutOfMemoryError();
        }
        this.closed = true;
        return new NativeBuffer(newAddress, new DirectMemory(newAddress, newLength, this.memory.getOrder()), false);
    }

    public void mlock(long position, long length) {
        if (position < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (position + length > this.memory.length()) {
            throw new IndexOutOfBoundsException();
        }
        NativeMemoryUtils.mlock(this.address + position, length);
    }

    public void munlock(long position, long length) {
        if (position < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (position + length > this.memory.length()) {
            throw new IndexOutOfBoundsException();
        }
        NativeMemoryUtils.munlock(this.address + position, length);
    }

    private NativeBuffer createNewAndClose(long newSize) {
        NativeBuffer ret = new NativeBuffer(newSize, this.memory.getOrder());
        ret.memory().putBytes(0L, this.memory, 0L, Math.min(this.memory.length(), newSize));
        NativeBuffer.closeQuietly(this);
        return ret;
    }

    public NativeBuffer realloc(long newSize) {
        if (this.mmapped && newSize >= MMAP_THRESHOLD) {
            if (OS_TYPE_IS_MAC) {
                return this.createNewAndClose(newSize);
            }
            long newAddress = MMapBuffer.mremap(this.address, this.memory.length(), newSize);
            if (newAddress == -1L) {
                throw new RuntimeException("anonymous mremap failed with error " + MMapBuffer.errno());
            }
            return new NativeBuffer(newAddress, new DirectMemory(newAddress, newSize, this.memory.getOrder()), true);
        }
        if (!this.mmapped && newSize < MMAP_THRESHOLD) {
            return this.realloc0(newSize);
        }
        return this.createNewAndClose(newSize);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.mmapped) {
                MMapBuffer.munmap(this.address, this.memory.length());
            } else if (this.address != 0L) {
                IndeedUnsafe.freeMemory((long)this.address);
            }
        }
    }

    @Override
    public DirectMemory memory() {
        return this.memory;
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Exception e) {
            log.error("Exception during cleanup of a Closeable, ignoring", (Throwable)e);
        }
    }

    static {
        long mmapThreshold;
        log = LoggerFactory.getLogger(NativeBuffer.class);
        MAP_ANONYMOUS_DEV_ZERO = Boolean.getBoolean("indeed.mmap.map.anonymous.dev.zero");
        String thresholdString = System.getProperty("indeed.mmap.threshold");
        if (thresholdString == null) {
            mmapThreshold = 262144L;
        } else {
            try {
                mmapThreshold = Integer.parseInt(thresholdString);
            }
            catch (NumberFormatException e) {
                log.error("error setting MMAP_THRESHOLD", (Throwable)e);
                mmapThreshold = 262144L;
            }
        }
        MMAP_THRESHOLD = mmapThreshold;
        OS_TYPE_IS_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
        LoadIndeedMMap.loadLibrary();
    }
}

