/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.varexport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.indeed.util.varexport.Export;
import com.indeed.util.varexport.LazilyManagedVariable;
import com.indeed.util.varexport.ManagedVariable;
import com.indeed.util.varexport.Variable;
import com.indeed.util.varexport.VariableHost;
import com.indeed.util.varexport.VariableVisitor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class VarExporter
implements VariableHost {
    private static Logger log = Logger.getLogger(VarExporter.class);
    @VisibleForTesting
    protected static ManagedVariable<String> startTime = VarExporter.createStartTimeVariable(new Date());
    private static final Map<String, VarExporter> namespaces = Maps.newHashMap();
    private static final Multimap<String, Variable> tags = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<Variable>>(){

        public Set<Variable> get() {
            return Sets.newCopyOnWriteArraySet();
        }
    });
    private static final ReentrantReadWriteLock tagsLock = new ReentrantReadWriteLock();
    private final Class<?> namespaceClass;
    private final boolean declaredFieldsOnly;
    private final String namespace;
    private final Map<String, Variable> variables = Maps.newTreeMap();
    private final Set<String> childVariables = Sets.newTreeSet();
    private VarExporter parent = null;

    public boolean isDeclaredFieldsOnly() {
        return this.declaredFieldsOnly;
    }

    public Class<?> getNamespaceClass() {
        return this.namespaceClass;
    }

    private static synchronized VarExporter getInstance(String namespace, Class namespaceClass, boolean declaredFieldsOnly) {
        VarExporter exporter;
        if (Strings.isNullOrEmpty((String)namespace)) {
            namespace = null;
        }
        if ((exporter = namespaces.get(namespace)) == null) {
            exporter = new VarExporter(namespace, namespaceClass, declaredFieldsOnly);
            namespaces.put(namespace, exporter);
        }
        return exporter;
    }

    public static synchronized VarExporter forNamespace(String namespace) {
        return VarExporter.getInstance(namespace, null, false);
    }

    public static synchronized Optional<VarExporter> forNamespaceIfExists(@Nonnull String namespace) {
        return Optional.ofNullable(namespaces.get(namespace));
    }

    public static synchronized VarExporter forNamespace(@Nonnull Class<?> clazz, boolean declaredFieldsOnly) {
        return VarExporter.getInstance(clazz.getSimpleName(), clazz, declaredFieldsOnly);
    }

    public static synchronized List<String> getNamespaces() {
        return new ArrayList<String>(namespaces.keySet());
    }

    public static VarExporter global() {
        return VarExporter.forNamespace(null);
    }

    public static void visitNamespaceVariables(String namespace, VariableVisitor visitor) {
        VarExporter.forNamespace(namespace).visitVariables(visitor);
    }

    public static VariableHost withTag(final String tag) {
        return new VariableHost(){

            @Override
            public void visitVariables(VariableVisitor visitor) {
                Collection matched;
                tagsLock.readLock().lock();
                try {
                    matched = tags.get((Object)tag);
                }
                finally {
                    tagsLock.readLock().unlock();
                }
                if (matched != null) {
                    for (Variable v : matched) {
                        visitor.visit(v);
                    }
                }
            }

            @Override
            public <T> Variable<T> getVariable(final String variableName) {
                final Variable[] foundVariable = new Variable[]{null};
                this.visitVariables(new VariableVisitor(){

                    @Override
                    public void visit(Variable var) {
                        if (variableName.equals(var.getName())) {
                            foundVariable[0] = var;
                            return;
                        }
                    }
                });
                return foundVariable[0];
            }
        };
    }

    private VarExporter(@Nullable String namespace, @Nullable Class namespaceClass, boolean declaredFieldsOnly) {
        this.namespace = namespace == null ? "" : namespace;
        this.namespaceClass = namespaceClass;
        this.declaredFieldsOnly = declaredFieldsOnly;
    }

    public VarExporter includeInGlobal() {
        if (Strings.isNullOrEmpty((String)this.namespace)) {
            return this;
        }
        return this.setParentNamespace(VarExporter.global());
    }

    public VarExporter setParentNamespace(VarExporter namespace) {
        if (namespace != this) {
            this.parent = namespace;
        }
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public VarExporter getParentNamespace() {
        return this.parent;
    }

    public void export(Object obj, String prefix) {
        this.checkTypeCompatibility(obj.getClass());
        boolean isNamespaceClassSet = this.namespaceClass != null;
        Class<?> c = isNamespaceClassSet ? this.namespaceClass : obj.getClass();
        for (Field field : this.declaredFieldsOnly ? c.getDeclaredFields() : c.getFields()) {
            Export export = field.getAnnotation(Export.class);
            if (Modifier.isStatic(field.getModifiers())) {
                this.loadMemberVariable(field, export, c, true, prefix, null);
                continue;
            }
            this.loadMemberVariable(field, export, obj, true, prefix, null);
        }
        HashSet classAndInterfaces = Sets.newHashSet();
        this.getAllInterfaces(c, classAndInterfaces);
        classAndInterfaces.add(c);
        for (Class cls : classAndInterfaces) {
            for (Method method : this.declaredFieldsOnly ? cls.getDeclaredMethods() : cls.getMethods()) {
                Export export = method.getAnnotation(Export.class);
                if (Modifier.isStatic(method.getModifiers())) {
                    this.loadMemberVariable(method, export, c, true, prefix, null);
                    continue;
                }
                this.loadMemberVariable(method, export, obj, true, prefix, null);
            }
        }
    }

    private void checkTypeCompatibility(Class<?> clazz) {
        boolean isNamespaceClassSet;
        boolean bl = isNamespaceClassSet = this.namespaceClass != null;
        if (isNamespaceClassSet) {
            Preconditions.checkArgument((boolean)this.namespaceClass.isAssignableFrom(clazz), (String)"%s is not compatible with %s", (Object)clazz.getCanonicalName(), (Object)this.namespaceClass.getCanonicalName());
        }
    }

    private void getAllInterfaces(Class<?> c, Set<Class<?>> alreadySeen) {
        for (Class<?> i : c.getInterfaces()) {
            alreadySeen.add(i);
        }
        if (c.getSuperclass() != null) {
            this.getAllInterfaces(c.getSuperclass(), alreadySeen);
        }
    }

    public void export(Class c, String prefix) {
        Export export;
        this.checkTypeCompatibility(c);
        for (Field field : this.declaredFieldsOnly ? c.getDeclaredFields() : c.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            export = field.getAnnotation(Export.class);
            this.loadMemberVariable(field, export, c, true, prefix, null);
        }
        for (AccessibleObject accessibleObject : this.declaredFieldsOnly ? c.getDeclaredMethods() : c.getMethods()) {
            if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            export = ((Method)accessibleObject).getAnnotation(Export.class);
            this.loadMemberVariable((Member)((Object)accessibleObject), export, c, true, prefix, null);
        }
    }

    public void export(Object obj, Member member, String prefix, String name) {
        this.checkTypeCompatibility(obj.getClass());
        Export export = null;
        if (member instanceof AnnotatedElement) {
            export = ((AnnotatedElement)((Object)member)).getAnnotation(Export.class);
        }
        this.loadMemberVariable(member, export, obj, false, prefix, name);
    }

    public void export(Class c, Member member, String prefix, String name) {
        if (!Modifier.isStatic(member.getModifiers())) {
            throw new UnsupportedOperationException(member + " is not static in " + c.getName());
        }
        this.export((Object)c, member, prefix, name);
    }

    public void export(LazilyManagedVariable lazilyManagedVariable) {
        this.addVariable(lazilyManagedVariable);
        this.loadTagsForVariable(lazilyManagedVariable);
    }

    public void export(ManagedVariable managedVariable) {
        this.addVariable(managedVariable);
        this.loadTagsForVariable(managedVariable);
    }

    public <T> T getValue(String variableName) {
        Variable<T> variable = this.getVariable(variableName);
        return variable == null ? null : (T)variable.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Variable<T> getVariable(String variableName) {
        Variable v;
        Variable sub;
        String[] subTokens = this.getSubVariableTokens(variableName);
        if (subTokens != null && (sub = this.getSubVariable(subTokens[0], subTokens[1])) != null) {
            return sub;
        }
        Map<String, Variable> map = this.variables;
        synchronized (map) {
            v = this.variables.get(variableName);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVariables(VariableVisitor visitor) {
        ArrayList variablesCopy;
        Map<String, Variable> map = this.variables;
        synchronized (map) {
            variablesCopy = Lists.newArrayListWithExpectedSize((int)this.variables.size());
            Iterator<Variable> iterator = this.variables.values().iterator();
            while (iterator.hasNext()) {
                Variable v = iterator.next();
                if (v.isLive()) {
                    variablesCopy.add(v);
                    continue;
                }
                iterator.remove();
            }
        }
        for (Variable v : variablesCopy) {
            if (v.isExpandable()) {
                Map<?, ?> map2 = v.expand();
                try {
                    for (Map.Entry<?, ?> entry : map2.entrySet()) {
                        visitor.visit(new EntryVariable(entry, v, this.namespace));
                    }
                    continue;
                }
                catch (ConcurrentModificationException e) {
                    log.warn((Object)("Failed to iterate map entry set for variable " + v.getName()), (Throwable)e);
                    AbstractMap.SimpleEntry<String, String> errorEntry = new AbstractMap.SimpleEntry<String, String>("error", e.getMessage());
                    visitor.visit(new EntryVariable(errorEntry, v, this.namespace));
                    continue;
                }
            }
            visitor.visit(v);
        }
        if (variablesCopy.size() > 0 && startTime != null) {
            visitor.visit(startTime);
        }
    }

    public Iterable<Variable> getVariables() {
        final ImmutableList.Builder builder = ImmutableList.builder();
        this.visitVariables(new VariableVisitor(){

            @Override
            public void visit(Variable var) {
                builder.add((Object)var);
            }
        });
        return builder.build();
    }

    public void dump(final PrintWriter out, final boolean includeDoc) {
        this.visitVariables(new Visitor(){

            @Override
            public void visit(Variable var) {
                var.write(out, includeDoc);
            }
        });
    }

    public void dumpJson(final PrintWriter out) {
        out.append("{");
        this.visitVariables(new Visitor(){
            int count = 0;

            @Override
            public void visit(Variable var) {
                if (this.count++ > 0) {
                    out.append(", ");
                }
                out.append(var.getName()).append("='").append(String.valueOf(var.getValue())).append("'");
            }
        });
        out.append("}");
    }

    @VisibleForTesting
    public static void resetGlobal() {
        tagsLock.writeLock().lock();
        try {
            tags.clear();
        }
        finally {
            tagsLock.writeLock().unlock();
        }
        VarExporter.resetNamespaces();
    }

    private static synchronized void resetNamespaces() {
        namespaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void reset() {
        tagsLock.writeLock().lock();
        try {
            for (Variable v : this.variables.values()) {
                Set<String> varTags = v.getTags();
                for (String tag : varTags) {
                    tags.remove((Object)tag, (Object)v);
                }
            }
        }
        finally {
            tagsLock.writeLock().unlock();
        }
        Map<String, Variable> map = this.variables;
        synchronized (map) {
            this.variables.clear();
        }
        if (this.parent != null) {
            this.parent.removeChildVariables(this.namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChildVariables(String namespacePrefix) {
        Set<String> set = this.childVariables;
        synchronized (set) {
            Iterator<String> childIterator = this.childVariables.iterator();
            while (childIterator.hasNext()) {
                String childVariableName = childIterator.next();
                if (!childVariableName.startsWith(namespacePrefix + "-")) continue;
                this.variables.remove(childVariableName);
                childIterator.remove();
            }
        }
    }

    private String[] getSubVariableTokens(String variableName) {
        String[] tokens = variableName.split("#", 2);
        if (tokens.length > 1) {
            return tokens;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Variable getSubVariable(String variableName, String subVariableName) {
        Variable container;
        Map<String, Variable> map = this.variables;
        synchronized (map) {
            container = this.variables.get(variableName);
        }
        if (container != null && container.isExpandable()) {
            Map<?, ?> map2 = container.expand();
            try {
                for (Map.Entry<?, ?> entry : map2.entrySet()) {
                    Object key = entry.getKey();
                    if (!String.valueOf(key).equals(subVariableName)) continue;
                    return new EntryVariable(entry, container, this.namespace);
                }
            }
            catch (ConcurrentModificationException e) {
                log.warn((Object)("Failed to iterate map entry set for variable " + variableName), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildVariable(String childNamespace, Variable variable) {
        ImmutableSet noTags = ImmutableSet.of();
        ProxyVariable v = new ProxyVariable(childNamespace + "-" + variable.getName(), variable, (Set<String>)noTags, this.namespace);
        this.addVariable(v);
        Set<String> set = this.childVariables;
        synchronized (set) {
            this.childVariables.add(v.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVariable(Variable variable) {
        Variable prev;
        Map<String, Variable> map = this.variables;
        synchronized (map) {
            prev = this.variables.put(variable.getName(), variable);
        }
        if (prev != null) {
            log.warn((Object)("In namespace '" + this.namespace + "': Exporting variable named " + variable.getName() + " hides a previously exported variable"));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("In namespace '" + this.namespace + "': Added variable " + variable.getName()));
        }
        if (this.parent != null && this.parent != this) {
            this.parent.addChildVariable(this.namespace, variable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTagsForVariable(Variable variable) {
        tagsLock.writeLock().lock();
        try {
            Set<String> variableTags = variable.getTags();
            for (String tag : variableTags) {
                tags.put((Object)tag, (Object)variable);
            }
        }
        finally {
            tagsLock.writeLock().unlock();
        }
    }

    private void loadMemberVariable(Member member, Export export, Object obj, boolean requireAnnotation, String prefix, String name) {
        if (!requireAnnotation || export != null) {
            CachingVariable variable = this.variableFromMember(export, prefix, name, member, obj);
            if (export != null && export.cacheTimeoutMs() > 0L) {
                variable = new CachingVariable(variable, export.cacheTimeoutMs(), this.namespace);
            }
            this.loadTagsForVariable(variable);
            this.addVariable(variable);
        }
    }

    private String getVarName(Export export, String supplied, Member member) {
        if (export != null && export.name() != null && export.name().length() > 0) {
            return export.name();
        }
        if (supplied != null && supplied.length() > 0) {
            return supplied;
        }
        return member.getName();
    }

    private Variable variableFromMember(Export export, String prefix, String suppliedName, Member member, Object obj) {
        boolean expand;
        String name = (prefix != null ? prefix : "") + this.getVarName(export, suppliedName, member);
        String doc = export != null ? export.doc() : "";
        ImmutableSet tags = ImmutableSet.copyOf((Object[])(export != null ? export.tags() : new String[]{}));
        boolean bl = expand = export != null ? export.expand() : false;
        if (member instanceof Field) {
            return new FieldVariable(name, doc, (Set<String>)tags, expand, (Field)member, obj, this.namespace);
        }
        if (member instanceof Method) {
            return new MethodVariable(name, doc, (Set<String>)tags, expand, (Method)member, obj, this.namespace);
        }
        throw new UnsupportedOperationException(member.getClass() + " not supported by export");
    }

    @VisibleForTesting
    protected static ManagedVariable<String> createStartTimeVariable(Date date) {
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        return ManagedVariable.builder().setName("exporter-start-time").setDoc("global start time of variable exporter").setValue(timestampFormat.format(date)).build();
    }

    protected static class ProxyVariable<T>
    extends Variable<T> {
        private final Variable<T> variable;

        public ProxyVariable(String name, Variable<T> variable, Set<String> tags, String namespace) {
            super(name, tags, variable.getDoc(), variable.isExpandable(), namespace);
            this.variable = variable;
        }

        @Override
        protected boolean isLive() {
            return this.variable.isLive();
        }

        @Override
        protected boolean canExpand() {
            return this.variable.canExpand();
        }

        @Override
        public T getValue() {
            return this.variable.getValue();
        }

        @Override
        public Long getLastUpdated() {
            return this.variable.getLastUpdated();
        }
    }

    protected static class CachingVariable<T>
    extends ProxyVariable<T> {
        private final long timeout;
        private T cachedValue = null;
        private long lastCached = 0L;
        private Supplier<Long> clock = new Supplier<Long>(){

            public Long get() {
                return System.currentTimeMillis();
            }
        };

        public CachingVariable(Variable<T> variable, long timeout, String namespace) {
            super(variable.getName(), variable, variable.getTags(), namespace);
            this.timeout = timeout;
        }

        @VisibleForTesting
        protected void setClock(Supplier<Long> clock) {
            this.clock = clock;
        }

        private boolean isCacheExpired() {
            return this.lastCached == 0L || (Long)this.clock.get() - this.lastCached > this.timeout;
        }

        @Override
        public Long getLastUpdated() {
            return this.lastCached;
        }

        @Override
        public T getValue() {
            if (this.isCacheExpired()) {
                this.cachedValue = super.getValue();
                this.lastCached = (Long)this.clock.get();
            }
            return this.cachedValue;
        }
    }

    private static class EntryVariable
    extends Variable {
        private final WeakReference<Object> valueRef;
        private final Variable parent;

        public EntryVariable(Map.Entry entry, Variable parent, String namespace) {
            super(parent.getName() + "#" + entry.getKey(), parent.getTags(), null, false, namespace);
            this.valueRef = new WeakReference(entry.getValue());
            this.parent = parent;
            Object value = this.valueRef.get();
            if (value != null && Map.class.isAssignableFrom(value.getClass()) && !ImmutableMap.class.isAssignableFrom(value.getClass())) {
                log.warn((Object)("Variable " + this.getNamespaceAndName() + "#" + entry.getKey() + " is not an ImmutableMap, which may result in sporadic errors"));
            }
        }

        @Override
        protected boolean isLive() {
            return this.valueRef.get() != null;
        }

        @Override
        protected boolean canExpand() {
            Object value = this.valueRef.get();
            if (value != null) {
                return Map.class.isAssignableFrom(value.getClass()) && this.getValue() != null;
            }
            return false;
        }

        @Override
        public String getDoc() {
            return this.parent.getDoc();
        }

        @Override
        public Long getLastUpdated() {
            return this.parent.getLastUpdated();
        }

        public Object getValue() {
            return this.valueRef.get();
        }
    }

    private static class MethodVariable<T>
    extends Variable<T> {
        private final Method method;
        private final WeakReference<Object> objectRef;

        public MethodVariable(String name, String doc, Set<String> tags, boolean expand, Method method, Object object, String namespace) {
            super(name, tags, doc, expand, namespace);
            this.method = method;
            method.setAccessible(true);
            this.objectRef = new WeakReference<Object>(object);
            if (Map.class.isAssignableFrom(method.getReturnType()) && !ImmutableMap.class.isAssignableFrom(method.getReturnType())) {
                log.warn((Object)("Variable " + this.getNamespaceAndName() + " is not an ImmutableMap, which may result in sporadic errors"));
            }
        }

        @Override
        protected boolean isLive() {
            return this.objectRef.get() != null;
        }

        @Override
        protected boolean canExpand() {
            return Map.class.isAssignableFrom(this.method.getReturnType()) && this.getValue() != null;
        }

        @Override
        public T getValue() {
            Object object = this.objectRef.get();
            if (object == null) {
                return null;
            }
            try {
                return (T)this.method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FieldVariable<T>
    extends Variable<T> {
        private final Field field;
        private final WeakReference<Object> objectRef;

        public FieldVariable(String name, String doc, Set<String> tags, boolean expand, Field field, Object object, String namespace) {
            super(name, tags, doc, expand, namespace);
            this.field = field;
            field.setAccessible(true);
            this.objectRef = new WeakReference<Object>(object);
            if (Map.class.isAssignableFrom(field.getType()) && !ImmutableMap.class.isAssignableFrom(field.getType())) {
                log.warn((Object)("Variable " + this.getNamespaceAndName() + " is not an ImmutableMap, which may result in sporadic errors"));
            }
        }

        @Override
        protected boolean isLive() {
            return this.objectRef.get() != null;
        }

        @Override
        protected boolean canExpand() {
            return Map.class.isAssignableFrom(this.field.getType()) && this.getValue() != null;
        }

        @Override
        public T getValue() {
            Object object = this.objectRef.get();
            if (object == null) {
                return null;
            }
            try {
                return (T)this.field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public static interface Visitor
    extends VariableVisitor {
    }
}

