/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.varexport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.indeed.util.varexport.Variable;
import java.util.Map;
import java.util.Set;

public class LazilyManagedVariable<T>
extends Variable<T> {
    @VisibleForTesting
    protected Supplier<Long> clock = new Supplier<Long>(){

        public Long get() {
            return System.currentTimeMillis();
        }
    };
    private final Class<T> c;
    private final Supplier<T> valueSupplier;
    private Long lastUpdated = (Long)this.clock.get();

    public static <T> Builder<T> builder(Class<T> c) {
        return new Builder(c, "");
    }

    public static <T> Builder<T> builder(Class<T> c, String namespace) {
        return new Builder(c, namespace);
    }

    private LazilyManagedVariable(String name, Set<String> tags, String doc, boolean expand, Class<T> c, Supplier<T> valueSupplier, String namespace) {
        super(name, tags, doc, expand, namespace);
        this.c = c;
        this.valueSupplier = valueSupplier;
    }

    public void update() {
        this.lastUpdated = (Long)this.clock.get();
    }

    @Override
    protected boolean isLive() {
        return true;
    }

    @Override
    protected boolean canExpand() {
        return Map.class.isAssignableFrom(this.c);
    }

    @Override
    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public T getValue() {
        return (T)this.valueSupplier.get();
    }

    public static class Builder<T> {
        private final Class<T> c;
        private final String namespace;
        private String name = null;
        private String doc = "";
        private boolean expand = false;
        private Set<String> tags = ImmutableSet.of();
        private Supplier<T> valueSupplier = null;

        private Builder(Class<T> c, String namespace) {
            this.c = c;
            this.namespace = namespace;
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> setDoc(String doc) {
            this.doc = doc;
            return this;
        }

        public Builder<T> setExpand(boolean expand) {
            this.expand = expand;
            return this;
        }

        public Builder<T> setValue(Supplier<T> valueSupplier) {
            this.valueSupplier = valueSupplier;
            return this;
        }

        public Builder<T> setTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public LazilyManagedVariable<T> build() {
            if (this.name == null) {
                throw new RuntimeException("name must not be null for ManagedVariable");
            }
            if (this.tags == null) {
                throw new RuntimeException("tags must not be null for ManagedVariable");
            }
            return new LazilyManagedVariable(this.name, this.tags, this.doc, this.expand, this.c, this.valueSupplier, this.namespace);
        }
    }
}

