/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.commons.api.responses;

import android.content.Context;
import com.indigitall.android.commons.callbacks.BaseCallback;
import com.indigitall.android.commons.models.ErrorCode;
import com.indigitall.android.commons.utils.ErrorUtils;
import com.indigitall.android.commons.utils.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseResponse {
    private static final String TAG = "[IND]api.Response";
    private static final String RESPONSE_STATUS_CODE = "statusCode";
    private static final String RESPONSE_MESSAGE = "message";
    private static final String RESPONSE_DATA = "data";
    protected Context context;
    protected BaseCallback callback;
    protected int statusCode;
    protected String message;
    protected JSONObject data;

    protected BaseResponse(Context context, BaseCallback baseCallback) {
        this.context = context;
        this.callback = baseCallback;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processData(int n, String object, JSONObject jSONObject) {
        Log log;
        BaseResponse baseResponse = this;
        this.statusCode = n;
        baseResponse.message = object;
        baseResponse.data = new JSONObject();
        Log log2 = log;
        log = new Log(TAG, this.context);
        if (jSONObject == null) return;
        try {
            if (jSONObject.has(RESPONSE_STATUS_CODE)) {
                this.statusCode = jSONObject.getInt(RESPONSE_STATUS_CODE);
            }
            if (jSONObject.has(RESPONSE_MESSAGE)) {
                this.message = jSONObject.getString(RESPONSE_MESSAGE);
            }
            if (!jSONObject.has(RESPONSE_DATA)) return;
            object = jSONObject.get(RESPONSE_DATA);
        }
        catch (JSONException jSONException) {
            log2.e(ErrorUtils.INSTANCE.showError(ErrorCode.GENERAL_ERROR.getErrorId(), "processData" + jSONException.getLocalizedMessage()));
            jSONException.printStackTrace();
            return;
        }
        {
            if (object instanceof JSONArray) {
                this.data = jSONObject;
                return;
            }
            this.data = (JSONObject)object;
            return;
        }
    }
}

