/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.commons.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.indigitall.android.commons.models.ErrorCode;
import com.indigitall.android.commons.utils.ErrorUtils;
import com.indigitall.android.commons.utils.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/indigitall/android/commons/utils/AppUtils;", "", "()V", "TAG", "", "getAppInfo", "Landroid/content/pm/ApplicationInfo;", "context", "Landroid/content/Context;", "getAppMetada", "Landroid/os/Bundle;", "commons_release"})
public final class AppUtils {
    @NotNull
    public static final AppUtils INSTANCE = new AppUtils();
    @NotNull
    private static final String TAG = "[IND]AppUtils";

    private AppUtils() {
    }

    @Nullable
    public final Bundle getAppMetada(@NotNull Context context) {
        Log log;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = log;
        log = new Log(TAG, context);
        Bundle bundle = null;
        try {
            ApplicationInfo applicationInfo = context2.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"pm.getApplicationInfo(co\u2026ageManager.GET_META_DATA)");
            bundle = applicationInfo.metaData;
        }
        catch (NullPointerException nullPointerException) {
            Object object2 = object;
            object = ErrorCode.GENERAL_ERROR.getErrorId();
            ((Log)object2).e(ErrorUtils.INSTANCE.showError((Integer)object, nullPointerException.getLocalizedMessage())).writeLog();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Object object3 = object;
            object = ErrorCode.GENERAL_ERROR.getErrorId();
            ((Log)object3).e(ErrorUtils.INSTANCE.showError((Integer)object, nameNotFoundException.getLocalizedMessage())).writeLog();
        }
        return bundle;
    }

    @Nullable
    public final ApplicationInfo getAppInfo(@NotNull Context context) {
        Log log;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = log;
        log = new Log(TAG, context);
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context2.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (NullPointerException nullPointerException) {
            Object object2 = object;
            object = ErrorCode.GENERAL_ERROR.getErrorId();
            ((Log)object2).e(ErrorUtils.INSTANCE.showError((Integer)object, nullPointerException.getLocalizedMessage())).writeLog();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Object object3 = object;
            object = ErrorCode.GENERAL_ERROR.getErrorId();
            ((Log)object3).e(ErrorUtils.INSTANCE.showError((Integer)object, nameNotFoundException.getLocalizedMessage())).writeLog();
        }
        return applicationInfo;
    }
}

