/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.commons.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.indigitall.android.commons.models.ExecutorType;
import com.indigitall.android.commons.models.LogLevel;
import com.indigitall.android.commons.utils.Log;

public class CorePreferenceUtils {
    private static final String PREFS_NAME = "com.indigitall.prefs";
    private static final String PREFS_API_URL = "com.indigitall.prefs.apiURL";
    private static final String PREFS_APP_KEY = "com.indigitall.prefs.appKey";
    private static final String PREFS_PRODUCT_NAME = "com.indigitall.prefs.productName";
    private static final String PREFS_PRODUCT_VERSION = "com.indigitall.prefs.productVersion";
    private static final String PREFS_DEFAULT_ACTIVITY = "com.indigitall.prefs.defaultActivity";
    private static final String PREFS_SERVICE_SYNC_TIME = "com.indigitall.prefs.serviceSyncTime";
    private static final String PREFS_MAINTENANCE_START = "com.indigitall.prefs.maintenanceStart";
    private static final String PREFS_MAINTENANCE_END = "com.indigitall.prefs.maintenanceEnd";
    private static final String PREFS_API_ENABLED = "com.indigitall.prefs.apiEnabled";
    private static final String PREFS_DEBUG = "com.indigitall.prefs.debug";
    private static final String PREFS_LOG_LEVEL = "com.indigitall.prefs.logLevel";
    private static final String PREFS_LOCATION_ENABLED = "com.indigitall.prefs.locationEnabled";
    private static final String PREFS_LOCATION_ACCURACY = "com.indigitall.prefs.locationAccuracy";
    private static final String PREFS_LOCATION_DISTANCE = "com.indigitall.prefs.locationDistance";
    private static final String PREFS_LOCATION_UPDATE_MINUTES = "com.indigitall.prefs.locationUpdateMinutes";
    private static final String PREFS_LOCATION_LATITUDE = "com.indigitall.prefs.locationLatitude";
    private static final String PREFS_LOCATION_LONGITUDE = "com.indigitall.prefs.locationLongitude";
    private static final String PREFS_LOCATION_PERMISSION_ENABLED = "com.indigitall.prefs.locationPermissionEnabled";
    private static final String PREFS_EXTERNAL_ID = "com.indigitall.prefs.externalId";
    private static final String PREFS_PRIVATE_SECURED_DATA = "com.indigitall.prefs.privateSecuredData";
    private static final String PREFS_PRIVATE_KEY = "com.indigitall.prefs.privateKey";
    private static final String PREFS_PUBLIC_KEY = "com.indigitall.prefs.publicKey";
    private static final String PREFS_SECURE_SENDING_APP_PUBLIC_KEY = "com.indigitall.prefs.secureSendingAppPublicKey";
    private static final String PREFS_INBOX_API_URL = "com.indigitall.prefs.InboxAPpiURL";
    private static final String PREFS_AUTH_TOKEN = "com.indigitall.prefs.authToken";
    private static final String PREFS_INBOX_AUTH_MODE = "com.indigitall.prefs.inboxAuthMode";
    private static final String PREFS_EXECUTOR_TYPE = "com.indigitall.prefs.executorType";
    private static final String PREFS_APPLICATION_ID = "com.indigitall.prefs.applicationId";
    private static final String PREFS_SERVICE_TIME_STAMP = "com.indigitall.prefs.serviceTimeStamp";
    private static final String PREFS_DEVICE_ID = "com.indigitall.prefs.deviceId";
    private static final String PREFS_HARMONY_ENABLED = "com.indigitall.prefs.harmonyEnabled";
    private static final String PREFS_AVOID_CYPHER = ".avoidCypher";
    private static SharedPreferences prefs;
    private static SharedPreferences.Editor editor;

    private static SharedPreferences getPreferences(Context context) {
        if (context != null) {
            return context.getSharedPreferences(PREFS_NAME, 0);
        }
        return null;
    }

    protected static SharedPreferences.Editor getEditor(Context context) {
        context = CorePreferenceUtils.getPreferences(context);
        prefs = context;
        if (context != null) {
            return context.edit();
        }
        return null;
    }

    protected static boolean getBoolean(Context context, String string) {
        context = CorePreferenceUtils.getPreferences(context);
        prefs = context;
        if (context != null) {
            return context.getBoolean(string, false);
        }
        return false;
    }

    protected static boolean setBoolean(Context context, String string, boolean bl) {
        context = CorePreferenceUtils.getEditor(context);
        editor = context;
        if (context != null) {
            context.putBoolean(string, bl);
            return editor.commit();
        }
        return false;
    }

    protected static float getFloat(Context context, String string) {
        context = CorePreferenceUtils.getPreferences(context);
        prefs = context;
        if (context != null) {
            return context.getFloat(string, 0.0f);
        }
        return 0.0f;
    }

    protected static boolean setFloat(Context context, String string, float f) {
        context = CorePreferenceUtils.getEditor(context);
        editor = context;
        if (context != null) {
            context.putFloat(string, f);
            return editor.commit();
        }
        return false;
    }

    protected static int getInt(Context context, String string) {
        context = CorePreferenceUtils.getPreferences(context);
        prefs = context;
        if (context != null) {
            return context.getInt(string, 0);
        }
        return 0;
    }

    protected static int getIntStatus(Context context, String string) {
        context = CorePreferenceUtils.getPreferences(context);
        prefs = context;
        if (context != null) {
            return context.getInt(string, -1);
        }
        return -1;
    }

    protected static boolean setInt(Context context, String string, int n) {
        context = CorePreferenceUtils.getEditor(context);
        editor = context;
        if (context != null) {
            context.putInt(string, n);
            return editor.commit();
        }
        return false;
    }

    protected static long getLong(Context context, String string) {
        context = CorePreferenceUtils.getPreferences(context);
        prefs = context;
        if (context != null) {
            return context.getLong(string, 0L);
        }
        return 0L;
    }

    protected static boolean setLong(Context context, String string, long l) {
        context = CorePreferenceUtils.getEditor(context);
        editor = context;
        if (context != null) {
            context.putLong(string, l);
            return editor.commit();
        }
        return false;
    }

    protected static String getString(Context context, String string) {
        context = CorePreferenceUtils.getPreferences(context);
        prefs = context;
        if (context != null) {
            return context.getString(string, null);
        }
        return null;
    }

    protected static boolean setString(Context context, String string, String string2) {
        context = CorePreferenceUtils.getEditor(context);
        editor = context;
        if (context != null) {
            context.putString(string, string2);
            return editor.commit();
        }
        return false;
    }

    public static void clearPreferences(Context context) {
        context = CorePreferenceUtils.getEditor(context);
        editor = context;
        if (context != null) {
            context.clear();
            editor.commit();
        }
    }

    public static String getApiURL(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_API_URL);
    }

    public static boolean setApiURL(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_API_URL, string);
    }

    public static String getAppKey(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_APP_KEY);
    }

    public static boolean setAppKey(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_APP_KEY, string);
    }

    public static String getProductName(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_PRODUCT_NAME);
    }

    public static boolean setProductName(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_PRODUCT_NAME, string);
    }

    public static String getProductVersion(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_PRODUCT_VERSION);
    }

    public static boolean setProductVersion(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_PRODUCT_VERSION, string);
    }

    public static String getDefaultActivity(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_DEFAULT_ACTIVITY);
    }

    public static boolean setDefaultActivity(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_DEFAULT_ACTIVITY, string);
    }

    public static int getServiceSyncTime(Context context) {
        return CorePreferenceUtils.getInt(context, PREFS_SERVICE_SYNC_TIME);
    }

    public static boolean setServiceSyncTime(Context context, int n) {
        return CorePreferenceUtils.setInt(context, PREFS_SERVICE_SYNC_TIME, n);
    }

    public static String getMaintenanceStart(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_MAINTENANCE_START);
    }

    public static boolean setMaintenanceStart(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_MAINTENANCE_START, string);
    }

    public static String getMaintenanceEnd(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_MAINTENANCE_END);
    }

    public static boolean setMaintenanceEnd(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_MAINTENANCE_END, string);
    }

    public static boolean getApiEnabled(Context context) {
        return CorePreferenceUtils.getInt(context, PREFS_API_ENABLED) != -1;
    }

    public static boolean setApiEnabled(Context context, int n) {
        return CorePreferenceUtils.setInt(context, PREFS_API_ENABLED, n);
    }

    public static boolean getLocationEnabled(Context context) {
        return CorePreferenceUtils.getBoolean(context, PREFS_LOCATION_ENABLED);
    }

    public static boolean setLocationEnabled(Context context, boolean bl) {
        return CorePreferenceUtils.setBoolean(context, PREFS_LOCATION_ENABLED, bl);
    }

    public static int getLocationAccuracy(Context context) {
        return CorePreferenceUtils.getInt(context, PREFS_LOCATION_ACCURACY);
    }

    public static boolean setLocationAccuracy(Context context, int n) {
        return CorePreferenceUtils.setInt(context, PREFS_LOCATION_ACCURACY, n);
    }

    public static int getLocationDistance(Context context) {
        return CorePreferenceUtils.getInt(context, PREFS_LOCATION_DISTANCE);
    }

    public static boolean setLocationDistance(Context context, int n) {
        return CorePreferenceUtils.setInt(context, PREFS_LOCATION_DISTANCE, n);
    }

    public static int getLocationUpdateMinutes(Context context) {
        return CorePreferenceUtils.getInt(context, PREFS_LOCATION_UPDATE_MINUTES);
    }

    public static boolean setLocationUpdateMinutes(Context context, int n) {
        return CorePreferenceUtils.setInt(context, PREFS_LOCATION_UPDATE_MINUTES, n);
    }

    public static float getLocationLatitude(Context context) {
        return CorePreferenceUtils.getFloat(context, PREFS_LOCATION_LATITUDE);
    }

    public static boolean setLocationLatitude(Context context, float f) {
        return CorePreferenceUtils.setFloat(context, PREFS_LOCATION_LATITUDE, f);
    }

    public static float getLocationLongitude(Context context) {
        return CorePreferenceUtils.getFloat(context, PREFS_LOCATION_LONGITUDE);
    }

    public static boolean setLocationLongitude(Context context, float f) {
        return CorePreferenceUtils.setFloat(context, PREFS_LOCATION_LONGITUDE, f);
    }

    public static boolean setLogDebug(Context context, boolean bl) {
        return CorePreferenceUtils.setBoolean(context, PREFS_DEBUG, bl);
    }

    public static boolean getLogDebug(Context context) {
        return CorePreferenceUtils.getBoolean(context, PREFS_DEBUG);
    }

    public static boolean setLogLevel(Context context, LogLevel logLevel) {
        return CorePreferenceUtils.setInt(context, PREFS_LOG_LEVEL, logLevel.getLevel());
    }

    public static LogLevel getLogLevel(Context context) {
        return Log.getLogLevel(CorePreferenceUtils.getInt(context, PREFS_LOG_LEVEL));
    }

    public static boolean getLocationPermissionEnabled(Context context) {
        return CorePreferenceUtils.getBoolean(context, PREFS_LOCATION_PERMISSION_ENABLED);
    }

    public static boolean setLocationPermissionEnabled(Context context, boolean bl) {
        return CorePreferenceUtils.setBoolean(context, PREFS_LOCATION_PERMISSION_ENABLED, bl);
    }

    public static boolean setInBoxApiURL(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_INBOX_API_URL, string);
    }

    public static String getInBoxApiURL(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_INBOX_API_URL);
    }

    public static String getExternalId(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_EXTERNAL_ID);
    }

    public static boolean setExternalId(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_EXTERNAL_ID, string);
    }

    public static String getAuthToken(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_AUTH_TOKEN);
    }

    public static boolean setAuthToken(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_AUTH_TOKEN, string);
    }

    public static String getInboxAuthMode(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_INBOX_AUTH_MODE);
    }

    public static boolean setInboxAuthMode(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_INBOX_AUTH_MODE, string);
    }

    public static ExecutorType getExecutorType(Context context) {
        ExecutorType executorType;
        switch (CorePreferenceUtils.getInt(context, PREFS_EXECUTOR_TYPE)) {
            default: {
                executorType = ExecutorType.EXECUTOR_THREAD;
                break;
            }
            case 5: {
                executorType = ExecutorType.EXECUTOR_RUNNABLE;
                break;
            }
            case 4: {
                executorType = ExecutorType.ASYNC_EXECUTOR;
                break;
            }
            case 3: {
                executorType = ExecutorType.ASYNC_BACKGROUND;
                break;
            }
            case 2: {
                executorType = ExecutorType.ASYNC_RUNNABLE;
                break;
            }
            case 1: {
                executorType = ExecutorType.THREAD;
            }
        }
        return executorType;
    }

    public static boolean setExecutorType(Context context, ExecutorType executorType) {
        return CorePreferenceUtils.setInt(context, PREFS_EXECUTOR_TYPE, executorType.getValue());
    }

    public static String getApplicationId(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_APPLICATION_ID);
    }

    public static boolean setApplicationId(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_APPLICATION_ID, string);
    }

    public static long getServiceTimeStamp(Context context) {
        return CorePreferenceUtils.getLong(context, PREFS_SERVICE_TIME_STAMP);
    }

    public static boolean setServiceTimeStamp(Context context, long l) {
        return CorePreferenceUtils.setLong(context, PREFS_SERVICE_TIME_STAMP, l);
    }

    public static boolean getSecuredDataEnabled(Context context) {
        return CorePreferenceUtils.getBoolean(context, PREFS_PRIVATE_SECURED_DATA);
    }

    public static boolean setSecuredDataEnabled(Context context, boolean bl) {
        return CorePreferenceUtils.setBoolean(context, PREFS_PRIVATE_SECURED_DATA, bl);
    }

    public static String getSecureSendingAppPublicKey(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_SECURE_SENDING_APP_PUBLIC_KEY);
    }

    public static boolean setSecureSendingAppPublicKey(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_SECURE_SENDING_APP_PUBLIC_KEY, string);
    }

    public static String getPrivateKey(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_PRIVATE_KEY);
    }

    public static boolean setPrivateKey(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_PRIVATE_KEY, string);
    }

    public static String getPublicKey(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_PUBLIC_KEY);
    }

    public static boolean setPublicKey(Context context, String string) {
        return CorePreferenceUtils.setString(context, PREFS_PUBLIC_KEY, string);
    }

    public static String getDeviceId(Context context) {
        return CorePreferenceUtils.getString(context, PREFS_DEVICE_ID);
    }

    public static void setDeviceId(Context context, String string) {
        if (string != null && !string.equals("") && !string.equals("null") && string.length() >= 8 && (context = CorePreferenceUtils.getEditor(context)) != null) {
            context.putString(PREFS_DEVICE_ID, string).apply();
        }
    }

    public static boolean getHarmonyEnabled(Context context) {
        return CorePreferenceUtils.getBoolean(context, PREFS_HARMONY_ENABLED);
    }

    public static boolean setHarmonyEnabled(Context context, boolean bl) {
        return CorePreferenceUtils.setBoolean(context, PREFS_HARMONY_ENABLED, bl);
    }

    public static boolean isAvoidCypher(Context context) {
        return CorePreferenceUtils.getBoolean(context, PREFS_AVOID_CYPHER);
    }

    public static boolean setAvoidCypher(Context context, boolean bl) {
        return CorePreferenceUtils.setBoolean(context, PREFS_AVOID_CYPHER, bl);
    }
}

