/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.commons.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;

public class IntentUtils {
    public static Intent getAppIntent(Context context, String object) {
        if ((object = IntentUtils.getActivityClass((String)object)) != null) {
            Intent intent = new Intent(context, (Class)object);
            intent.addFlags(32768);
            intent.addFlags(0x10000000);
            return intent;
        }
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addFlags(32768);
        intent.addFlags(0x10000000);
        return intent;
    }

    private static Class getActivityClass(String string) {
        if (string != null && !string.equals("")) {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static Intent getOpenURLIntent(String string) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.setData(Uri.parse((String)string));
        return intent;
    }

    public static Intent getCallIntent(String string) {
        string = "tel:" + string.trim();
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.setData(Uri.parse((String)string));
        return intent;
    }

    public static Intent getMarketIntent(Context object, String string) {
        object.getPackageManager().getPackageInfo("com.android.vending", 0);
        try {
            object = "market://details?id=" + string;
        }
        catch (Exception exception) {
            object = "https://play.google.com/store/apps/details?id=" + string;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10080000);
        intent.setData(Uri.parse((String)object));
        return intent;
    }

    public static Intent getShareIntent(Context context, String string) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", string);
        intent.setType("text/plain");
        return intent;
    }

    public static Intent getWalletIntent(Context context, String string) {
        Intent intent;
        Context context2 = context;
        Context context3 = context = intent;
        context3("android.intent.action.VIEW");
        context3.addFlags(0x10000000);
        intent.setDataAndType(Uri.parse((String)string), "application/vnd.apple.pkpass");
        if (context2.getPackageManager().queryIntentActivities((Intent)context, 0).size() == 0) {
            context.setData(Uri.parse((String)string));
        }
        return context;
    }

    public static int getPendingIntentFlags(int n) {
        if (Build.VERSION.SDK_INT >= 31) {
            n |= 0x4000000;
        }
        return n;
    }
}

