/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.commons.utils;

import android.content.Context;
import android.os.Process;
import com.indigitall.android.commons.models.ErrorModel;
import com.indigitall.android.commons.models.LogLevel;
import com.indigitall.android.commons.utils.CorePreferenceUtils;

public class Log {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    private String tag = "";
    private String log = "";
    private int level = 1;

    public Log(String string) {
        this(string, null);
    }

    public Log(String string, Context context) {
        this.tag = string;
        int n = 1;
        LogLevel logLevel = CorePreferenceUtils.getLogLevel(context);
        if (logLevel != null) {
            n = logLevel.getLevel();
        }
        if (this.tag.length() > 23) {
            this.tag = this.tag.substring(0, 23);
        }
        if (n >= 1 && n <= 4) {
            this.level = n;
        }
        if (context != null && n >= 2 && n < 4) {
            this.level = 3;
        }
    }

    public static LogLevel getLogLevel(int n) {
        LogLevel logLevel = LogLevel.DEBUG;
        if (n == 2) {
            logLevel = LogLevel.INFO;
        } else if (n == 3) {
            logLevel = LogLevel.WARNING;
        } else if (n == 4) {
            logLevel = LogLevel.ERROR;
        }
        return logLevel;
    }

    public final void writeLog() {
        if (this.log.length() > 0) {
            android.util.Log.d((String)this.tag, (String)this.log);
        }
        this.log = "";
    }

    public final Log d(String string) {
        if (this.level <= 1) {
            this.log = this.log + string;
            Process.myTid();
        }
        return this;
    }

    public final Log i(String string) {
        if (this.level <= 2) {
            this.log = this.log + string;
            Process.myTid();
        }
        return this;
    }

    public final Log w(String string) {
        if (this.level <= 3) {
            this.log = this.log + string;
            Process.myTid();
        }
        return this;
    }

    public final Log e(String string) {
        if (this.level <= 4) {
            this.log = this.log + string;
            Process.myTid();
        }
        return this;
    }

    public final Log e(ErrorModel errorModel) {
        if (this.level <= 4) {
            this.log = this.log + (Object)((Object)errorModel.getErrorCode()) + " " + errorModel.getErrorCode().getErrorId() + ": " + (Object)((Object)errorModel.getErrorMessage());
            Process.myTid();
        }
        return this;
    }
}

