/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.commons.utils;

import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006!"}, d2={"Lcom/indigitall/android/commons/utils/URLUtils;", "", "()V", "AUTHORITY_CHARS_REGEX", "", "AUTHORITY_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "AUTHORITY_REGEX", "IPV6_REGEX", "PARSE_AUTHORITY_EXTRA", "", "PARSE_AUTHORITY_HOST_IP", "PARSE_AUTHORITY_IPV6", "PARSE_AUTHORITY_PORT", "PARSE_URL_AUTHORITY", "PARSE_URL_SCHEME", "SCHEME_PATTERN", "SCHEME_REGEX", "URL_PATTERN", "URL_REGEX", "USERINFO_CHARS_REGEX", "USERINFO_FIELD_REGEX", "schemes", "", "[Ljava/lang/String;", "isValidAuthority", "", "authority", "isValidScheme", "scheme", "isValidURL", "value", "commons_release"})
public final class URLUtils {
    @NotNull
    public static final URLUtils INSTANCE = new URLUtils();
    @NotNull
    private static final String URL_REGEX = "^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?";
    private static final Pattern URL_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final int PARSE_URL_SCHEME = 2;
    private static final int PARSE_URL_AUTHORITY = 4;
    @NotNull
    private static final String SCHEME_REGEX = "^\\p{Alpha}[\\p{Alnum}\\+\\-\\.]*";
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^\\p{Alpha}[\\p{Alnum}\\+\\-\\.]*");
    @NotNull
    private static final String[] schemes = new String[]{"http", "https"};
    @NotNull
    private static final String AUTHORITY_CHARS_REGEX = "\\p{Alnum}\\-\\.";
    @NotNull
    private static final String IPV6_REGEX = "[0-9a-fA-F:]+";
    @NotNull
    private static final String USERINFO_CHARS_REGEX = "[a-zA-Z0-9%-._~!$&'()*+,;=]";
    @NotNull
    private static final String USERINFO_FIELD_REGEX = "[a-zA-Z0-9%-._~!$&'()*+,;=]+(?::[a-zA-Z0-9%-._~!$&'()*+,;=]*)?@";
    @NotNull
    private static final String AUTHORITY_REGEX = "(?:\\[([0-9a-fA-F:]+)\\]|(?:(?:[a-zA-Z0-9%-._~!$&'()*+,;=]+(?::[a-zA-Z0-9%-._~!$&'()*+,;=]*)?@)?([\\p{Alnum}\\-\\.]*)))(?::(\\d*))?(.*)?";
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("(?:\\[([0-9a-fA-F:]+)\\]|(?:(?:[a-zA-Z0-9%-._~!$&'()*+,;=]+(?::[a-zA-Z0-9%-._~!$&'()*+,;=]*)?@)?([\\p{Alnum}\\-\\.]*)))(?::(\\d*))?(.*)?");
    private static final int PARSE_AUTHORITY_IPV6 = 1;
    private static final int PARSE_AUTHORITY_HOST_IP = 2;
    private static final int PARSE_AUTHORITY_PORT = 3;
    private static final int PARSE_AUTHORITY_EXTRA = 4;

    private URLUtils() {
    }

    public final boolean isValidURL(@Nullable String object) {
        if (object == null) {
            return false;
        }
        if (!((Matcher)(object = URL_PATTERN.matcher((CharSequence)object))).matches()) {
            return false;
        }
        String string = ((Matcher)object).group(2);
        if (!this.isValidScheme(string)) {
            return false;
        }
        object = ((Matcher)object).group(4);
        return !(Intrinsics.areEqual((Object)"file", (Object)string) ? object != null && StringsKt.contains$default((CharSequence)object, (CharSequence)":", (boolean)false, (int)2, null) : !this.isValidAuthority((String)object));
    }

    public final boolean isValidScheme(@Nullable String string) {
        HashSet<String> hashSet = new HashSet<String>(schemes.length);
        int n = schemes.length;
        for (int i = 0; i < n; ++i) {
            String string2 = schemes[i].toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            hashSet.add(string2);
        }
        if (string == null) {
            return false;
        }
        if (!SCHEME_PATTERN.matcher(string).matches()) {
            return false;
        }
        String string3 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return hashSet.contains(string3);
    }

    public final boolean isValidAuthority(@Nullable String string) {
        return string != null;
    }
}

