/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.commons.utils;

import android.content.Context;
import android.util.DisplayMetrics;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0018\u0010\u0005\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0012"}, d2={"Lcom/indigitall/android/commons/utils/Utils;", "", "()V", "getPutRequestTimeStamp", "", "isImplementedClass", "Ljava/lang/Class;", "className", "", "isImplementedKotlinClass", "Lkotlin/reflect/KClass;", "isServiceTimestampExceed", "", "context", "Landroid/content/Context;", "isTablet", "setServiceTimeStamp", "", "commons_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final boolean isServiceTimestampExceed(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return CorePreferenceUtils.getServiceTimeStamp(context2) == 0L || CorePreferenceUtils.getServiceTimeStamp(context) <= Calendar.getInstance().getTimeInMillis();
    }

    public final void setServiceTimeStamp(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CorePreferenceUtils.setServiceTimeStamp(context2, Calendar.getInstance().getTimeInMillis() + (long)(CorePreferenceUtils.getServiceSyncTime(context) * 60 * 60 * 1000));
    }

    public final long getPutRequestTimeStamp() {
        return Calendar.getInstance().getTimeInMillis() + (long)604800000;
    }

    @Nullable
    public final Class<? extends Object> isImplementedClass(@NotNull String string) {
        Object object;
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"className");
        try {
            object = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = null;
        }
        return object;
    }

    @Nullable
    public final KClass<? extends Object> isImplementedKotlinClass(@NotNull String string) {
        Utils utils;
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"className");
        try {
            utils = Reflection.getOrCreateKotlinClass(string2.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            utils = null;
        }
        return utils;
    }

    public final boolean isTablet(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Utils utils = context2.getResources().getDisplayMetrics();
        if (utils != null) {
            float f = (float)((DisplayMetrics)utils).heightPixels / ((DisplayMetrics)utils).ydpi;
            return Math.sqrt(Math.pow((float)((DisplayMetrics)utils).widthPixels / ((DisplayMetrics)utils).xdpi, 2.0) + Math.pow(f, 2.0)) >= 7.0;
        }
        return false;
    }
}

