/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.customer;

import android.content.Context;
import com.indigitall.android.commons.models.Channel;
import com.indigitall.android.customer.api.CustomerClient;
import com.indigitall.android.customer.api.requests.CustomerRequest;
import com.indigitall.android.customer.callbacks.CustomerCallback;
import com.indigitall.android.customer.callbacks.CustomerFieldCallback;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ4\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000fJ \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u0017"}, d2={"Lcom/indigitall/android/customer/CustomerIndigitall;", "", "()V", "deleteValuesFromCustomerFields", "", "context", "Landroid/content/Context;", "fieldNames", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "callback", "Lcom/indigitall/android/customer/callbacks/CustomerCallback;", "getCustomer", "getCustomerInformation", "Lcom/indigitall/android/customer/callbacks/CustomerFieldCallback;", "link", "channel", "Lcom/indigitall/android/commons/models/Channel;", "unlink", "updateValueToCustomerFields", "fields", "Lorg/json/JSONObject;", "customer_release"})
public final class CustomerIndigitall {
    @NotNull
    public static final CustomerIndigitall INSTANCE = new CustomerIndigitall();

    private CustomerIndigitall() {
    }

    public final void getCustomer(@NotNull Context context, @Nullable CustomerCallback customerCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CustomerClient.INSTANCE.getCustomer(new CustomerRequest(context), customerCallback);
    }

    public final void getCustomerInformation(@NotNull Context context, @Nullable ArrayList<String> arrayList, @Nullable CustomerFieldCallback customerFieldCallback) {
        CustomerRequest customerRequest;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CustomerRequest customerRequest2 = customerRequest;
        customerRequest = new CustomerRequest(context);
        if (arrayList != null) {
            customerRequest2.setFieldNames(arrayList);
        }
        CustomerClient.INSTANCE.getCustomerField(customerRequest2, customerFieldCallback);
    }

    public final void updateValueToCustomerFields(@NotNull Context context, @NotNull JSONObject jSONObject, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"fields");
        CustomerRequest customerRequest2 = customerRequest;
        customerRequest2(context);
        customerRequest.setFields(jSONObject);
        CustomerClient.INSTANCE.putCustomerField(customerRequest2, customerCallback);
    }

    public final void deleteValuesFromCustomerFields(@NotNull Context context, @NotNull ArrayList<String> arrayList, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(arrayList, (String)"fieldNames");
        CustomerRequest customerRequest2 = customerRequest;
        customerRequest2(context);
        customerRequest.setFieldNames(arrayList);
        CustomerClient.INSTANCE.deleteCustomerField(customerRequest2, customerCallback);
    }

    public final void link(@NotNull Context context, @NotNull Channel channel, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)channel), (String)"channel");
        CustomerRequest customerRequest2 = customerRequest;
        customerRequest2(context);
        customerRequest.setChannel(channel);
        CustomerClient.INSTANCE.postCustomerLink(customerRequest2, customerCallback);
    }

    public final void unlink(@NotNull Context context, @NotNull Channel channel, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)channel), (String)"channel");
        CustomerRequest customerRequest2 = customerRequest;
        customerRequest2(context);
        customerRequest.setChannel(channel);
        CustomerClient.INSTANCE.deleteCustomerLink(customerRequest2, customerCallback);
    }
}

