/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.customer.api;

import android.content.Context;
import com.indigitall.android.commons.api.BaseClient;
import com.indigitall.android.commons.api.requests.BaseRequest;
import com.indigitall.android.commons.models.ErrorCode;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.CoreValidations;
import com.indigitall.android.commons.utils.ErrorUtils;
import com.indigitall.android.customer.api.requests.CustomerRequest;
import com.indigitall.android.customer.api.responses.CustomerResponse;
import com.indigitall.android.customer.callbacks.CustomerCallback;
import com.indigitall.android.customer.callbacks.CustomerFieldCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0017J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/indigitall/android/customer/api/CustomerClient;", "Lcom/indigitall/android/commons/api/BaseClient;", "()V", "ENDPOINT_CUSTOMER", "", "ENDPOINT_CUSTOMER_EVENT_JOURNEY", "ENDPOINT_CUSTOMER_FIELD", "ENDPOINT_CUSTOMER_LINK", "ENDPOINT_EVENT", "ENDPOINT_PUSH", "URL_DEVICE_API", "deleteCustomerField", "", "request", "Lcom/indigitall/android/customer/api/requests/CustomerRequest;", "callback", "Lcom/indigitall/android/customer/callbacks/CustomerCallback;", "deleteCustomerLink", "getApiURL", "context", "Landroid/content/Context;", "getCustomer", "getCustomerField", "Lcom/indigitall/android/customer/callbacks/CustomerFieldCallback;", "postCustomerLink", "putCustomerField", "customer_release"})
public final class CustomerClient
extends BaseClient {
    @NotNull
    public static final CustomerClient INSTANCE = new CustomerClient();
    @NotNull
    private static final String URL_DEVICE_API = "https://device-api.indigitall.com/v2";
    @NotNull
    private static final String ENDPOINT_CUSTOMER = "/customer";
    @NotNull
    private static final String ENDPOINT_CUSTOMER_FIELD = "/customer/field";
    @NotNull
    private static final String ENDPOINT_CUSTOMER_LINK = "/customer/link";
    @NotNull
    private static final String ENDPOINT_PUSH = "/push";
    @NotNull
    private static final String ENDPOINT_EVENT = "/event";
    @NotNull
    private static final String ENDPOINT_CUSTOMER_EVENT_JOURNEY = "/event/custom";

    private CustomerClient() {
    }

    private final String getApiURL(Context object) {
        Object object2 = CorePreferenceUtils.getApiURL(object) != null ? CorePreferenceUtils.getApiURL(object) : URL_DEVICE_API;
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"url");
        object = ((String)object3).substring(((String)object3).length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
        if (Intrinsics.areEqual((Object)"/", (Object)object)) {
            Object object4 = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"url");
            object2 = ((String)object4).substring(0, ((String)object4).length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        Object object5 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"url");
        String string = StringsKt.replace$default((String)object5, (String)"v1", (String)"v2", (boolean)false, (int)4, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
        return string;
    }

    public final void getCustomer(@NotNull CustomerRequest customerRequest, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest2 = customerRequest;
        Intrinsics.checkNotNullParameter((Object)customerRequest2, (String)"request");
        Context context = customerRequest2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context");
        if (CoreValidations.isExternalIdFormat(context)) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            Context context2 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"request.context");
            String string = stringBuilder.append(this.getApiURL(context2)).append(ENDPOINT_CUSTOMER).toString();
            BaseRequest baseRequest = customerRequest.getCustomerRequest();
            Context context3 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"request.context");
            BaseClient.get(string, baseRequest, new CustomerResponse(context3, customerCallback));
        } else if (customerCallback != null) {
            customerCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.BAD_REQUEST_SERVER_ERROR, null));
        }
    }

    public final void getCustomerField(@NotNull CustomerRequest customerRequest, @Nullable CustomerFieldCallback customerFieldCallback) {
        CustomerRequest customerRequest2 = customerRequest;
        Intrinsics.checkNotNullParameter((Object)customerRequest2, (String)"request");
        Context context = customerRequest2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context");
        if (CoreValidations.isExternalIdFormat(context)) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            Context context2 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"request.context");
            String string = stringBuilder.append(this.getApiURL(context2)).append(ENDPOINT_CUSTOMER_FIELD).toString();
            BaseRequest baseRequest = customerRequest.getCustomerFieldRequest();
            Context context3 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"request.context");
            BaseClient.get(string, baseRequest, new CustomerResponse(context3, customerFieldCallback));
        } else if (customerFieldCallback != null) {
            customerFieldCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.BAD_REQUEST_SERVER_ERROR, null));
        }
    }

    public final void putCustomerField(@NotNull CustomerRequest customerRequest, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest2 = customerRequest;
        Intrinsics.checkNotNullParameter((Object)customerRequest2, (String)"request");
        Context context = customerRequest2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context");
        if (CoreValidations.isExternalIdFormat(context)) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            Context context2 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"request.context");
            String string = stringBuilder.append(this.getApiURL(context2)).append(ENDPOINT_CUSTOMER_FIELD).toString();
            BaseRequest baseRequest = customerRequest.putCustomerFieldRequest();
            Context context3 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"request.context");
            BaseClient.put(string, baseRequest, new CustomerResponse(context3, customerCallback));
        } else if (customerCallback != null) {
            customerCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.BAD_REQUEST_SERVER_ERROR, null));
        }
    }

    public final void deleteCustomerField(@NotNull CustomerRequest customerRequest, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest2 = customerRequest;
        Intrinsics.checkNotNullParameter((Object)customerRequest2, (String)"request");
        Context context = customerRequest2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context");
        if (CoreValidations.isExternalIdFormat(context)) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            Context context2 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"request.context");
            String string = stringBuilder.append(this.getApiURL(context2)).append(ENDPOINT_CUSTOMER_FIELD).toString();
            BaseRequest baseRequest = customerRequest.deleteCustomerFieldRequest();
            Context context3 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"request.context");
            BaseClient.delete(string, baseRequest, new CustomerResponse(context3, customerCallback));
        } else if (customerCallback != null) {
            customerCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.BAD_REQUEST_SERVER_ERROR, null));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void postCustomerLink(@NotNull CustomerRequest customerRequest, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest2 = customerRequest;
        Intrinsics.checkNotNullParameter((Object)customerRequest2, (String)"request");
        Context context = customerRequest2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context");
        if (CoreValidations.isExternalIdFormat(context)) {
            Context context2 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"request.context");
            if (CoreValidations.isAppKeyFormat(context2)) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2();
                Context context3 = customerRequest.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"request.context");
                String string = stringBuilder.append(this.getApiURL(context3)).append(ENDPOINT_CUSTOMER_LINK).toString();
                BaseRequest baseRequest = customerRequest.postAndDeleteCustomerLinkRequest();
                Context context4 = customerRequest.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"request.context");
                BaseClient.post(string, baseRequest, new CustomerResponse(context4, customerCallback));
                return;
            }
        }
        if (customerCallback == null) return;
        customerCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.BAD_REQUEST_SERVER_ERROR, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void deleteCustomerLink(@NotNull CustomerRequest customerRequest, @Nullable CustomerCallback customerCallback) {
        CustomerRequest customerRequest2 = customerRequest;
        Intrinsics.checkNotNullParameter((Object)customerRequest2, (String)"request");
        Context context = customerRequest2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context");
        if (CoreValidations.isExternalIdFormat(context)) {
            Context context2 = customerRequest.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"request.context");
            if (CoreValidations.isAppKeyFormat(context2)) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2();
                Context context3 = customerRequest.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"request.context");
                String string = stringBuilder.append(this.getApiURL(context3)).append(ENDPOINT_CUSTOMER_LINK).toString();
                BaseRequest baseRequest = customerRequest.postAndDeleteCustomerLinkRequest();
                Context context4 = customerRequest.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"request.context");
                BaseClient.delete(string, baseRequest, new CustomerResponse(context4, customerCallback));
                return;
            }
        }
        if (customerCallback == null) return;
        customerCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.BAD_REQUEST_SERVER_ERROR, null));
    }
}

