/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.inapp.Utils;

import android.content.Context;
import com.indigitall.android.commons.utils.Utils;
import com.indigitall.android.inapp.api.InAppClient;
import com.indigitall.android.inapp.api.request.EventInAppRequest;
import com.indigitall.android.inapp.api.request.InAppFormRequest;
import com.indigitall.android.inapp.models.InApp;
import com.indigitall.android.inapp.models.InAppAction;
import com.indigitall.android.inapp.models.InAppProperties;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\"\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lcom/indigitall/android/inapp/Utils/EventUtils;", "", "()V", "generateId", "", "sendEventClick", "", "context", "Landroid/content/Context;", "inApp", "Lcom/indigitall/android/inapp/models/InApp;", "sendEventForm", "jsonForm", "Lorg/json/JSONObject;", "sendEventFormToCustomer", "json", "sendEventPrint", "inapp_release"})
public final class EventUtils {
    @NotNull
    public static final EventUtils INSTANCE = new EventUtils();

    private EventUtils() {
    }

    @NotNull
    public final String generateId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    public final void sendEventPrint(@NotNull Context context, @NotNull InApp inApp) {
        EventInAppRequest eventInAppRequest;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inApp, (String)"inApp");
        EventInAppRequest eventInAppRequest2 = eventInAppRequest;
        eventInAppRequest2(context);
        eventInAppRequest2.setInAppId(inApp.getInAppId());
        eventInAppRequest.setVersion(inApp.getVersion());
        InAppClient.postEventPrintRequest(eventInAppRequest);
    }

    public final void sendEventClick(@NotNull Context object, @Nullable InApp inApp) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        if (inApp != null) {
            EventInAppRequest eventInAppRequest;
            EventInAppRequest eventInAppRequest2 = eventInAppRequest;
            eventInAppRequest2((Context)object);
            eventInAppRequest.setInAppId(inApp.getInAppId());
            object = inApp.getProperties();
            if ((object != null && (object = ((InAppProperties)object).getAction()) != null ? Integer.valueOf(((InAppAction)object).getActionId()) : null) != null && inApp.getProperties().getAction().getActionId() >= 0) {
                eventInAppRequest2.setActionId(inApp.getProperties().getAction().getActionId());
            }
            EventInAppRequest eventInAppRequest3 = eventInAppRequest2;
            eventInAppRequest3.setVersion(inApp.getVersion());
            InAppClient.postEventClickRequest(eventInAppRequest3);
        }
    }

    public final void sendEventForm(@NotNull Context context, @Nullable InApp inApp, @Nullable JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (inApp != null) {
            InAppClient.postEventForm(new InAppFormRequest(context, inApp, jSONObject));
        }
    }

    public final void sendEventFormToCustomer(@NotNull Context context, @NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"json");
        Object object = Utils.INSTANCE;
        Class<? extends Object> clazz = ((Utils)object).isImplementedClass("com.indigitall.android.Indigitall");
        object = ((Utils)object).isImplementedClass("com.indigitall.android.customer.callbacks.CustomerCallback");
        if (clazz != null && object != null) {
            int n = 3;
            Class[] classArray = new Class[3];
            classArray[0] = Context.class;
            classArray[1] = JSONObject.class;
            classArray[2] = object;
            object = "assignOrUpdateValueToCustomerFields";
            try {
                clazz.getDeclaredMethod((String)object, Arrays.copyOf(classArray, n)).invoke(JvmClassMappingKt.getKotlinClass(clazz).getObjectInstance(), context, jSONObject, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

