/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.inapp.Utils;

import android.content.Context;
import android.view.View;
import android.widget.ImageButton;
import com.indigitall.android.inapp.Utils.InAppErrorUtils;
import com.indigitall.android.inapp.Utils.InAppPreferenceUtils;
import com.indigitall.android.inapp.Utils.InAppUtils;
import com.indigitall.android.inapp.Utils.PopUpUtils;
import com.indigitall.android.inapp.Utils.ShowInAppUtils;
import com.indigitall.android.inapp.callbacks.GetInAppCallback;
import com.indigitall.android.inapp.callbacks.ShowInAppCallback;
import com.indigitall.android.inapp.dao.InAppDao;
import com.indigitall.android.inapp.dao.InAppDatabase;
import com.indigitall.android.inapp.models.InApp;
import com.indigitall.android.inapp.models.InAppErrorCode;
import com.indigitall.android.inapp.models.InAppErrorModel;
import com.indigitall.android.inapp.models.InAppShow;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002JN\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u001a"}, d2={"Lcom/indigitall/android/inapp/Utils/InAppFilterUtils;", "", "()V", "inAppFilterControl", "", "context", "Landroid/content/Context;", "inApp", "Lcom/indigitall/android/inapp/models/InApp;", "view", "Landroid/view/View;", "closeIcon", "Landroid/widget/ImageButton;", "closeIconDisabled", "", "popup", "callback", "Lcom/indigitall/android/inapp/callbacks/GetInAppCallback;", "showInAppCallback", "Lcom/indigitall/android/inapp/callbacks/ShowInAppCallback;", "inAppWasGot", "code", "", "inAppId", "wasInAppPassedFilterProperties", "Lcom/indigitall/android/inapp/models/InAppErrorModel;", "inapp_release"})
public final class InAppFilterUtils {
    @NotNull
    public static final InAppFilterUtils INSTANCE = new InAppFilterUtils();

    private InAppFilterUtils() {
    }

    private final void inAppFilterControl(Context context, InApp inApp, View view, ImageButton imageButton, boolean bl, boolean bl2, GetInAppCallback getInAppCallback, ShowInAppCallback showInAppCallback) {
        if (inApp != null) {
            Object object = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US).parse(inApp.getExpiredDate());
            if (!new Date().after((Date)object)) {
                object = INSTANCE.wasInAppPassedFilterProperties(context, inApp);
                if (object != null) {
                    int n = WhenMappings.$EnumSwitchMapping$0[((InAppErrorModel)object).getErrorCode().ordinal()];
                    if (n != 1) {
                        if (n != 2) {
                            if (n == 3 && getInAppCallback != null) {
                                getInAppCallback.didClickOut(inApp, (InAppErrorModel)object);
                            }
                        } else if (getInAppCallback != null) {
                            getInAppCallback.didShowManyTimes(inApp, (InAppErrorModel)object);
                        }
                    } else if (getInAppCallback != null) {
                        getInAppCallback.didDismissForever(inApp, (InAppErrorModel)object);
                    }
                    return;
                }
                if (getInAppCallback != null) {
                    getInAppCallback.didFound(inApp);
                }
                return;
            }
            if (getInAppCallback != null) {
                getInAppCallback.didExpired(inApp, InAppErrorUtils.INSTANCE.showError(InAppErrorCode.INAPP_WAS_EXPIRED, null));
            }
            ShowInAppUtils.INSTANCE.updateInAppGet(context, inApp, view, imageButton, bl, bl2, getInAppCallback, showInAppCallback);
            return;
        }
        if (getInAppCallback != null) {
            getInAppCallback.notFound();
        }
    }

    public final void inAppWasGot(@NotNull Context context, @NotNull String object, @Nullable View view, @Nullable ImageButton imageButton, boolean bl, boolean bl2, @Nullable GetInAppCallback getInAppCallback, @Nullable ShowInAppCallback showInAppCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)object, (String)"code");
        InAppDatabase inAppDatabase = new InAppDatabase(context).open();
        InAppDao inAppDao = inAppDatabase.getMInAppDao();
        object = inAppDao != null ? inAppDao.searchInApp((String)object) : null;
        inAppDatabase.close();
        this.inAppFilterControl(context, (InApp)object, view, imageButton, bl, bl2, getInAppCallback, showInAppCallback);
    }

    @Nullable
    public final InAppErrorModel wasInAppPassedFilterProperties(@NotNull Context object, @NotNull InApp inApp) {
        InApp inApp2 = inApp;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inApp2, (String)"inApp");
        if (inApp2.getProperties().getDismissForever() && inApp.getInAppShow().getWasDismissed()) {
            ShowInAppUtils.INSTANCE.addDismissForever((Context)object, inApp);
            return InAppErrorUtils.INSTANCE.showError(InAppErrorCode.POPUP_DISMISSED_FOREVER, null);
        }
        InApp inApp3 = inApp;
        int n = inApp3.getProperties().getNumberOfShows();
        Object object2 = inApp3.getInAppShow();
        object2 = object2 != null ? Integer.valueOf(((InAppShow)object2).getTimesShowed()) : null;
        InApp inApp4 = inApp;
        int n2 = inApp4.getProperties().getNumberOfClicks();
        Object object3 = inApp4.getInAppShow();
        object3 = object3 != null ? Integer.valueOf(((InAppShow)object3).getTimesClicked()) : null;
        if (object2 != null && n > 0) {
            if ((Integer)object2 < n) {
                InAppDatabase inAppDatabase = new InAppDatabase((Context)object).open();
                inApp.getInAppShow().setTimesShowed((Integer)object2 + 1);
                object = inAppDatabase.getMInAppDao();
                if (object != null) {
                    ((InAppDao)object).updateInAppField(inApp);
                }
                inAppDatabase.close();
            } else {
                return InAppErrorUtils.INSTANCE.showError(InAppErrorCode.INAPP_WAS_SHOWN_MANY_TIMES, "InApp was shown more than" + inApp.getProperties().getNumberOfShows() + " times");
            }
        }
        if (n2 > 0 && object3 != null && (Integer)object3 >= n2) {
            return InAppErrorUtils.INSTANCE.showError(InAppErrorCode.INAPP_WAS_CLICKED_MANY_TIMES, "InApp was clicked more than " + inApp.getProperties().getNumberOfClicks() + " times");
        }
        return null;
    }

    public final void inAppWasGot(@NotNull Context context, @NotNull String string, @Nullable ShowInAppCallback showInAppCallback) {
        JSONArray jSONArray;
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string, (String)"inAppId");
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        JSONArray jSONArray2 = InAppUtils.INSTANCE.convertToJSONArray(InAppPreferenceUtils.INSTANCE.getInAppWasShown(context));
        Object object = null;
        JSONArray jSONArray3 = jSONArray;
        jSONArray = new JSONArray();
        boolean bl = false;
        boolean bl2 = false;
        int n = jSONArray2.length();
        for (int i = 0; i < n; ++i) {
            InApp inApp;
            object = jSONArray2.getString(i);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.getString(i)");
            InApp inApp2 = inApp;
            if (Intrinsics.areEqual((Object)String.valueOf((Object)new InApp((String)object).getInAppId()), (Object)string)) {
                bl = true;
                String string2 = inApp2.getExpiredDate();
                if (string2 != null) {
                    String string3 = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"expiredDate");
                    Date date = simpleDateFormat2.parse(string3);
                    if (!new Date().after(date)) {
                        if (inApp2.getProperties().getDismissForever() && PopUpUtils.INSTANCE.isInAppDismissForever(context, inApp2)) {
                            if (showInAppCallback != null) {
                                showInAppCallback.didDismissForever(inApp2, InAppErrorUtils.INSTANCE.showError(InAppErrorCode.POPUP_DISMISSED_FOREVER, null));
                            }
                            return;
                        }
                        if (inApp2.isShowOnce()) {
                            inApp2.getProperties().setNumberOfShows(1);
                        }
                        if (inApp2.getProperties().getNumberOfShows() > 0) {
                            int n2;
                            int n3 = 1;
                            if (inApp2.getProperties().getNumberOfShows() > 0) {
                                n3 = inApp2.getProperties().getNumberOfShows();
                            }
                            if ((n2 = inApp2.getInAppShow().getTimesShowed()) < n3) {
                                inApp2.getInAppShow().setTimesShowed(n2 + 1);
                            } else {
                                if (showInAppCallback != null) {
                                    showInAppCallback.didShowManyTimes(inApp2, InAppErrorUtils.INSTANCE.showError(InAppErrorCode.POPUP_WAS_SHOWN_MANY_TIMES, "Pop Up was shown more than" + inApp2.getProperties().getNumberOfShows() + " times"));
                                }
                                return;
                            }
                        }
                        int n4 = 0;
                        if (inApp2.getProperties().getNumberOfClicks() > 0) {
                            n4 = inApp2.getProperties().getNumberOfClicks();
                        }
                        if (inApp2.getProperties().getNumberOfClicks() > 0) {
                            int n5 = inApp2.getInAppShow().getTimesClicked();
                            if (n5 > n4) {
                                inApp2.getInAppShow().setTimesClicked(n5 + 1);
                            } else {
                                if (showInAppCallback != null) {
                                    showInAppCallback.didClickOut(inApp2, InAppErrorUtils.INSTANCE.showError(InAppErrorCode.POPUP_WAS_CLICKED_MANY_TIMES, "Pop Up was clicked more than " + inApp2.getProperties().getNumberOfClicks() + " times"));
                                }
                                return;
                            }
                        }
                        if (showInAppCallback != null) {
                            showInAppCallback.onSuccess(inApp2);
                        }
                        return;
                    }
                    bl2 = true;
                }
            }
            if (!Intrinsics.areEqual((Object)object, (Object)"")) {
                jSONArray3.put(object);
            }
            object = inApp2;
        }
        if (!bl && showInAppCallback != null) {
            showInAppCallback.onSuccess((InApp)object);
        }
        if (bl && bl2) {
            if (showInAppCallback != null) {
                showInAppCallback.didExpired((InApp)object, InAppErrorUtils.INSTANCE.showError(InAppErrorCode.INAPP_WAS_EXPIRED, null));
            }
            InAppPreferenceUtils.INSTANCE.setInAppWasShown(context, jSONArray3.toString());
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InAppErrorCode.values().length];
            nArray[InAppErrorCode.POPUP_DISMISSED_FOREVER.ordinal()] = 1;
            nArray[InAppErrorCode.INAPP_WAS_SHOWN_MANY_TIMES.ordinal()] = 2;
            nArray[InAppErrorCode.INAPP_WAS_CLICKED_MANY_TIMES.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

