/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.inapp.api;

import android.content.Context;
import androidx.annotation.Nullable;
import com.indigitall.android.commons.api.BaseClient;
import com.indigitall.android.commons.models.ErrorCode;
import com.indigitall.android.commons.utils.ErrorUtils;
import com.indigitall.android.inapp.Utils.InAppPreferenceUtils;
import com.indigitall.android.inapp.Utils.InAppValidations;
import com.indigitall.android.inapp.api.request.CampaignInAppRequest;
import com.indigitall.android.inapp.api.request.EventInAppRequest;
import com.indigitall.android.inapp.api.request.InAppDeviceRequest;
import com.indigitall.android.inapp.api.request.InAppFormRequest;
import com.indigitall.android.inapp.api.request.InAppTopicRequest;
import com.indigitall.android.inapp.api.responses.InAppDeviceResponse;
import com.indigitall.android.inapp.api.responses.InAppResponse;
import com.indigitall.android.inapp.callbacks.InAppCallback;
import com.indigitall.android.inapp.callbacks.InAppTopicListCallback;

public class InAppClient
extends BaseClient {
    private static final String TAG = "[IND]InAppApi.Client";
    private static final String URL_INAPP_BASE = "https://device-api.indigitall.com/v2";
    private static final String URL_BASE = "https://device-api.indigitall.com/v1";
    private static final String URL_INAPP = "/inapp";
    private static final String ENDPOINT_EVENT_INAPP = "/event";
    private static final String ENDPOINT_EVENT_INAPP_PRINT = "/event/print";
    private static final String ENDPOINT_EVENT_INAPP_CLICK = "/event/click";
    private static final String ENDPOINT_EVENT_INAPP_FORM = "/event/form";
    private static final String ENDPOINT_CAMPAIGN_INAPP = "/campaign/{tag}";
    private static final String ENDPOINT_DEVICE = "/device";
    private static final String ENDPOINT_INAPP_TOPICS = "/topic";

    private static String getApiURL(Context object, Boolean object2) {
        if (((Boolean)object2).booleanValue()) {
            object2 = InAppPreferenceUtils.INSTANCE;
            object = ((InAppPreferenceUtils)object2).getInAppApiURL((Context)object) != null ? ((InAppPreferenceUtils)object2).getInAppApiURL((Context)object).replaceAll("v2", "v1") : URL_BASE;
        } else {
            object2 = InAppPreferenceUtils.INSTANCE;
            if (((InAppPreferenceUtils)object2).getInAppApiURL((Context)object) != null) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2();
                object = stringBuilder.append(((InAppPreferenceUtils)object2).getInAppApiURL((Context)object)).append(URL_INAPP).toString();
            } else {
                object = "https://device-api.indigitall.com/v2/inapp";
            }
            Object object3 = object;
            if ("/".equals(((String)object3).substring(((String)object3).length() - 1))) {
                Object object4 = object;
                object = ((String)object4).substring(0, ((String)object4).length() - 1);
            }
        }
        return object;
    }

    public static void postEventPrintRequest(EventInAppRequest eventInAppRequest) {
        if (InAppValidations.INSTANCE.isValidFormatRequest(eventInAppRequest.getContext())) {
            BaseClient.post(InAppClient.getApiURL(eventInAppRequest.getContext(), Boolean.FALSE) + ENDPOINT_EVENT_INAPP_PRINT, eventInAppRequest.eventPostInAppPrintRequest(), null);
        }
    }

    public static void postEventClickRequest(EventInAppRequest eventInAppRequest) {
        if (InAppValidations.INSTANCE.isValidFormatRequest(eventInAppRequest.getContext())) {
            BaseClient.post(InAppClient.getApiURL(eventInAppRequest.getContext(), Boolean.FALSE) + ENDPOINT_EVENT_INAPP_CLICK, eventInAppRequest.eventPostInAppClickRequest(), null);
        }
    }

    public static void getInAppCampaign(CampaignInAppRequest campaignInAppRequest, @Nullable InAppCallback inAppCallback) {
        BaseClient.get(InAppClient.getApiURL(campaignInAppRequest.getContext(), Boolean.FALSE) + ENDPOINT_CAMPAIGN_INAPP, campaignInAppRequest.getCampaignInAppRequest(), new InAppResponse(campaignInAppRequest.getContext(), inAppCallback));
    }

    public static void getTopics(InAppTopicRequest inAppTopicRequest, @Nullable InAppTopicListCallback inAppTopicListCallback) {
        if (InAppValidations.INSTANCE.isValidFormatRequest(inAppTopicRequest.getContext())) {
            BaseClient.get(InAppClient.getApiURL(inAppTopicRequest.getContext(), Boolean.FALSE) + ENDPOINT_INAPP_TOPICS, inAppTopicRequest.getTopics(), new InAppResponse(inAppTopicRequest.getContext(), inAppTopicListCallback));
        } else if (inAppTopicListCallback != null) {
            inAppTopicListCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void postEventForm(InAppFormRequest inAppFormRequest) {
        if (InAppValidations.INSTANCE.isValidFormatRequest(inAppFormRequest.getContext())) {
            BaseClient.post(InAppClient.getApiURL(inAppFormRequest.getContext(), Boolean.FALSE) + ENDPOINT_EVENT_INAPP_FORM, inAppFormRequest.postForm(), new InAppResponse(inAppFormRequest.getContext(), null));
        }
    }

    public static void postDevice(InAppDeviceRequest inAppDeviceRequest) {
        if (InAppValidations.INSTANCE.isValidFormatRequest(inAppDeviceRequest.getContext())) {
            BaseClient.post(InAppClient.getApiURL(inAppDeviceRequest.getContext(), Boolean.TRUE) + ENDPOINT_DEVICE, inAppDeviceRequest.postDeviceRequest(), new InAppDeviceResponse(inAppDeviceRequest.getContext(), null));
        }
    }
}

