/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.inapp.api.request;

import android.content.Context;
import com.indigitall.android.commons.api.requests.BaseRequest;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.Utils;
import com.indigitall.android.inapp.Utils.InAppPreferenceUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;

public class CampaignInAppRequest
extends BaseRequest {
    private static final String JSON_EXTERNAL_CODE = "externalCode";
    private static final String JSON_DEVICE_ID = "deviceId";
    private static final String JSON_PLATFORM = "platform";
    private static final String JSON_DEVICE_TYPE = "deviceType";
    private static final String JSON_LATITUDE = "latitude";
    private static final String JSON_LONGITUDE = "longitude";
    private static final String JSON_EXTERNAL_APPS = "externalApps";
    private static final String JSON_TOPICS = "topics";
    private final String tag;
    private String deviceId;
    private String externalCode;
    private String platform;
    private String deviceType;
    private double latitude;
    private double longitude;
    private String[] externalApps;
    private JSONArray topics;
    private String inAppId;
    private int resource;

    public CampaignInAppRequest(Context context) {
        block5: {
            CampaignInAppRequest campaignInAppRequest = this;
            super(context);
            this.tag = "{tag}";
            this.deviceId = CorePreferenceUtils.getDeviceId(context);
            campaignInAppRequest.externalCode = CorePreferenceUtils.getExternalId(context);
            campaignInAppRequest.platform = "android";
            this.deviceType = Utils.INSTANCE.isTablet(context) ? "tablet" : "mobile";
            this.latitude = CorePreferenceUtils.getLocationLatitude(context);
            this.longitude = CorePreferenceUtils.getLocationLongitude(context);
            InAppPreferenceUtils inAppPreferenceUtils = InAppPreferenceUtils.INSTANCE;
            if (inAppPreferenceUtils.getInAppTopicList(context) == null) break block5;
            if (inAppPreferenceUtils.getInAppTopicList(context).length() <= 0) break block5;
            try {
                this.topics = new JSONArray(inAppPreferenceUtils.getInAppTopicList(context));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String createQueryDeviceString() {
        return "deviceId=" + this.deviceId;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createGetCampaignQuery() {
        String string;
        block14: {
            Object object;
            string = "";
            if (this.externalCode != null) {
                string = string + "externalCode=" + this.externalCode + "&";
            }
            string = string + "deviceType=" + this.deviceType + "&";
            if (this.latitude != 0.0) {
                string = string + "latitude=" + this.latitude + "&";
            }
            if (this.longitude != 0.0) {
                string = string + "longitude=" + this.longitude + "&";
            }
            if (this.externalApps != null) {
                string = string + "externalApps=" + Arrays.toString(this.externalApps) + "&";
            }
            if ((object = this.topics) != null && object.length() > 0) {
                Throwable throwable2;
                block13: {
                    object = "";
                    try {
                        for (int i = 0; i < this.topics.length(); ++i) {
                            String string2;
                            Object object2;
                            if (!(this.topics.get(i) instanceof String)) continue;
                            if (i + 1 < this.topics.length()) {
                                object2 = object;
                                string2 = "topics=" + URLEncoder.encode((String)this.topics.get(i), "UTF-8") + "&";
                            } else {
                                object2 = object;
                                string2 = "topics=" + URLEncoder.encode((String)this.topics.get(i), "UTF-8");
                            }
                            object = ((String)object2).concat(string2);
                        }
                    }
                    catch (UnsupportedEncodingException throwable2) {
                        break block13;
                    }
                    catch (JSONException throwable2) {
                        // empty catch block
                        break block13;
                    }
                    {
                        string = string + (String)object + "&";
                        break block14;
                    }
                }
                throwable2.printStackTrace();
            }
        }
        if (this.platform == null) return string;
        return string + "platform=" + this.platform;
    }

    public BaseRequest getCampaignInAppRequest() {
        CampaignInAppRequest campaignInAppRequest = this;
        campaignInAppRequest.path.put("{tag}", this.inAppId);
        campaignInAppRequest.params = campaignInAppRequest.createGetCampaignQuery();
        return campaignInAppRequest;
    }

    public void setInAppId(String string) {
        this.inAppId = string;
    }

    public void setResource(int n) {
        this.resource = n;
    }
}

