/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.inapp.models;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.indigitall.android.commons.models.CoreDevice;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.Log;
import com.indigitall.android.commons.utils.Utils;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/indigitall/android/inapp/models/InAppDevice;", "Lcom/indigitall/android/commons/models/CoreDevice;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "JSON_DEVICE_ID", "", "TAG", "log", "Lcom/indigitall/android/commons/utils/Log;", "getDeviceIdFromJson", "json", "Lorg/json/JSONObject;", "toJson", "inapp_release"})
public final class InAppDevice
extends CoreDevice {
    @NotNull
    private final String TAG;
    @NotNull
    private final String JSON_DEVICE_ID;
    @Nullable
    private Log log;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InAppDevice(@NotNull Context object) {
        Object object2;
        block10: {
            Intrinsics.checkNotNullParameter((Object)object, (String)"context");
            this.TAG = "[IND]InAppDevice";
            this.JSON_DEVICE_ID = "deviceId";
            this.log = new Log("[IND]InAppDevice", (Context)object);
            object2 = CorePreferenceUtils.getHarmonyEnabled((Context)object) ? "harmony" : "android";
            InAppDevice inAppDevice = this;
            this.setPlatform((String)object2);
            this.setProductName(CorePreferenceUtils.getProductName((Context)object));
            inAppDevice.setProductVersion(CorePreferenceUtils.getProductVersion((Context)object));
            inAppDevice.setOsName("Android");
            inAppDevice.setOsVersion(Build.VERSION.RELEASE);
            inAppDevice.setOsVersion(this.getOsVersion() + " (SDK:" + Build.VERSION.SDK_INT + ')');
            String string = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
            object2 = Locale.ROOT;
            String string2 = string.toUpperCase((Locale)object2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            inAppDevice.setDeviceBrand(string2);
            String string3 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MODEL");
            String string4 = string3.toUpperCase((Locale)object2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            inAppDevice.setDeviceModel(string4);
            inAppDevice.setOperator("unknown");
            object2 = object.getSystemService("phone");
            if (object2 == null) throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            object2 = (TelephonyManager)object2;
            if (object2.getNetworkOperatorName() == null) break block10;
            if (Intrinsics.areEqual((Object)object2.getNetworkOperatorName(), (Object)"")) break block10;
            try {
                this.setOperator(object2.getNetworkOperatorName());
            }
            catch (Exception exception) {
                Log log = this.log;
                Intrinsics.checkNotNull((Object)log);
                log.w(exception.getLocalizedMessage()).writeLog();
                exception.printStackTrace();
            }
        }
        object2 = Utils.INSTANCE.isTablet((Context)object) ? "tablet" : "mobile";
        this.setDeviceType((String)object2);
        try {
            this.setAppVersion(object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).versionName);
        }
        catch (Exception exception) {
            Log log = this.log;
            Intrinsics.checkNotNull((Object)log);
            log.w(exception.getLocalizedMessage()).writeLog();
            exception.printStackTrace();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log log = this.log;
            Intrinsics.checkNotNull((Object)log);
            log.w(nameNotFoundException.getLocalizedMessage()).writeLog();
            nameNotFoundException.printStackTrace();
        }
        this.setExternalCode(CorePreferenceUtils.getExternalId((Context)object));
        if (Locale.getDefault() != null) {
            this.setLocale(Locale.getDefault().toString());
        }
        if ((object = TimeZone.getDefault()) == null) return;
        this.setTimeZone(((TimeZone)object).getID());
        this.setTimeOffset(((TimeZone)object).getOffset(System.currentTimeMillis()) / 60000);
    }

    @Nullable
    public final String getDeviceIdFromJson(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"json");
        return jSONObject.has(this.JSON_DEVICE_ID) ? jSONObject.getString(this.JSON_DEVICE_ID) : null;
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject2.put("platform", (Object)this.getPlatform());
        jSONObject2.put("version", (Object)this.getVersion());
        jSONObject2.put("productName", (Object)this.getProductName());
        jSONObject2.put("productVersion", (Object)this.getProductVersion());
        jSONObject2.put("osName", (Object)this.getOsName());
        jSONObject2.put("osVersion", (Object)this.getOsVersion());
        jSONObject2.put("deviceBrand", (Object)this.getDeviceBrand());
        jSONObject.put("deviceModel", (Object)this.getDeviceModel());
        if (this.getOperator() != null) {
            jSONObject2.put("operator", (Object)this.getOperator());
        }
        jSONObject2.put("deviceType", (Object)this.getDeviceType());
        if (this.getAppVersion() != null) {
            jSONObject2.put("appVersion", (Object)this.getAppVersion());
        }
        jSONObject2.put("locale", (Object)this.getLocale());
        jSONObject2.put("timeZone", (Object)this.getTimeZone());
        jSONObject2.put("timeOffset", (Object)this.getTimeOffset());
        if (this.getExternalCode() != null) {
            jSONObject2.put("externalCode", (Object)this.getExternalCode());
        }
        return jSONObject2;
    }
}

