/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.inapp.models;

import com.indigitall.android.inapp.models.InAppAction;
import com.indigitall.android.inapp.models.InAppLayout;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppProperties {
    protected static final String PROPERTIES = "properties";
    private static final String ACTION = "action";
    private static final String CONTENT_URL = "contentUrl";
    private static final String SHOWTIME = "showTime";
    private static final String LAYOUT = "layout";
    private static final String NUMBER_OF_SHOWS = "numberOfShows";
    private static final String NUMBER_OF_CLIKS = "numberOfClicks";
    private static final String DISMISS_FOREVER = "dismissForever";
    private static final String JSON_CONTENT_URL = "contentUrl";
    private InAppAction action;
    private String contentUrl;
    private int showTime;
    private InAppLayout layout;
    private int numberOfShows = 0;
    private int numberOfClicks = 0;
    private boolean dismissForever = false;

    public InAppProperties(Object object) throws JSONException {
        if (object != null) {
            JSONObject jSONObject;
            if (object instanceof String) {
                JSONObject jSONObject2;
                jSONObject = jSONObject2;
                jSONObject2 = new JSONObject((String)object);
            } else {
                jSONObject = (JSONObject)object;
            }
            if (jSONObject.has(ACTION)) {
                this.action = new InAppAction(jSONObject.get(ACTION));
            }
            if (jSONObject.has("contentUrl")) {
                this.contentUrl = jSONObject.getString("contentUrl");
            }
            if (jSONObject.has(SHOWTIME)) {
                this.showTime = jSONObject.getInt(SHOWTIME) * 1000;
            }
            if (jSONObject.has(LAYOUT)) {
                if (jSONObject.get(LAYOUT) instanceof String) {
                    this.layout = new InAppLayout(new JSONObject(jSONObject.getString(LAYOUT)));
                } else if (jSONObject.get(LAYOUT) instanceof JSONObject) {
                    this.layout = new InAppLayout(jSONObject.getJSONObject(LAYOUT));
                }
            }
            if (jSONObject.has(NUMBER_OF_SHOWS)) {
                this.numberOfShows = jSONObject.getInt(NUMBER_OF_SHOWS);
            }
            if (jSONObject.has(NUMBER_OF_CLIKS)) {
                this.numberOfClicks = jSONObject.getInt(NUMBER_OF_CLIKS);
            }
            if (jSONObject.has(DISMISS_FOREVER)) {
                this.dismissForever = jSONObject.getBoolean(DISMISS_FOREVER);
            }
        }
    }

    public static String getContentUrlFromJson(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("contentUrl")) {
            return jSONObject.getString("contentUrl");
        }
        return null;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public JSONObject toJson() {
        JSONObject jSONObject;
        block11: {
            Object object;
            block10: {
                JSONObject jSONObject2;
                jSONObject = jSONObject2;
                jSONObject2 = new JSONObject();
                object = ((InAppProperties)object).action;
                if (object == null) break block10;
                InAppAction inAppAction = object;
                object = ACTION;
                jSONObject.put((String)object, (Object)inAppAction.toString());
            }
            object = "contentUrl";
            jSONObject.put((String)object, (Object)((InAppProperties)object).contentUrl);
            object = SHOWTIME;
            jSONObject.put((String)object, ((InAppProperties)object).showTime);
            object = ((InAppProperties)object).layout;
            if (object == null) break block11;
            jSONObject.put(LAYOUT, object);
        }
        InAppProperties inAppProperties = object;
        InAppProperties inAppProperties2 = object;
        InAppProperties inAppProperties3 = object;
        Object object = NUMBER_OF_SHOWS;
        jSONObject.put((String)object, inAppProperties3.numberOfShows);
        object = NUMBER_OF_CLIKS;
        jSONObject.put((String)object, inAppProperties2.numberOfClicks);
        object = DISMISS_FOREVER;
        try {
            jSONObject.put((String)object, inAppProperties.dismissForever);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public int getNumberOfShows() {
        return this.numberOfShows;
    }

    public void setNumberOfShows(int n) {
        this.numberOfShows = n;
    }

    public int getNumberOfClicks() {
        return this.numberOfClicks;
    }

    public boolean getDismissForever() {
        return this.dismissForever;
    }

    public void setDismissForever(boolean bl) {
        this.dismissForever = bl;
    }

    public InAppAction getAction() {
        return this.action;
    }

    public InAppLayout getLayout() {
        return this.layout;
    }

    public int getShowTime() {
        return this.showTime;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setAction(InAppAction inAppAction) {
        this.action = inAppAction;
    }

    public void setContentUrl(String string) {
        this.contentUrl = string;
    }

    public void setShowTime(int n) {
        this.showTime = n;
    }

    public void setLayout(InAppLayout inAppLayout) {
        this.layout = inAppLayout;
    }

    public void setNumberOfClicks(int n) {
        this.numberOfClicks = n;
    }
}

