/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.inbox.api;

import android.content.Context;
import com.indigitall.android.commons.api.BaseClient;
import com.indigitall.android.commons.api.requests.BaseRequest;
import com.indigitall.android.commons.callbacks.BaseCallback;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.inbox.api.request.InboxAuthenticationRequest;
import com.indigitall.android.inbox.api.request.InboxCountersRequest;
import com.indigitall.android.inbox.api.request.InboxPushRequest;
import com.indigitall.android.inbox.api.response.InboxAuthenticationResponse;
import com.indigitall.android.inbox.api.response.InboxResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/indigitall/android/inbox/api/InboxClient;", "Lcom/indigitall/android/commons/api/BaseClient;", "()V", "ENDPOINT_INBOX_AUTH", "", "ENDPOINT_INBOX_COUNTER", "ENDPOINT_INBOX_NOTIFICATIONS", "ENDPOINT_INBOX_NOTIFICATIONS_WITH_SENDINGID", "TAG", "URL_INBOX_BASE", "getApiURL", "context", "Landroid/content/Context;", "getInbox", "", "pushRequest", "Lcom/indigitall/android/inbox/api/request/InboxPushRequest;", "callback", "Lcom/indigitall/android/commons/callbacks/BaseCallback;", "getInboxCounter", "request", "Lcom/indigitall/android/inbox/api/request/InboxCountersRequest;", "getInboxPushWithSendingId", "postInboxAuth", "Lcom/indigitall/android/inbox/api/request/InboxAuthenticationRequest;", "putInboxPush", "putInboxPushWithSendingId", "inbox_release"})
public final class InboxClient
extends BaseClient {
    @NotNull
    private final String TAG;
    @NotNull
    private final String URL_INBOX_BASE;
    @NotNull
    private final String ENDPOINT_INBOX_NOTIFICATIONS;
    @NotNull
    private final String ENDPOINT_INBOX_NOTIFICATIONS_WITH_SENDINGID = "/notification" + "/{sendingId}";
    @NotNull
    private final String ENDPOINT_INBOX_COUNTER;
    @NotNull
    private final String ENDPOINT_INBOX_AUTH;

    public InboxClient() {
        this.TAG = "[IND]InAppApi.Client";
        this.URL_INBOX_BASE = "https://inbox-api.indigitall.com/v1";
        this.ENDPOINT_INBOX_NOTIFICATIONS = "/notification";
        this.ENDPOINT_INBOX_COUNTER = "/counters";
        this.ENDPOINT_INBOX_AUTH = "/auth/webhook";
    }

    private final String getApiURL(Context object) {
        Object object2 = CorePreferenceUtils.getInBoxApiURL(object) != null ? CorePreferenceUtils.getInBoxApiURL(object) : ((InboxClient)object2).URL_INBOX_BASE;
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"url");
        object = ((String)object3).substring(((String)object3).length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
        if (Intrinsics.areEqual((Object)"/", (Object)object)) {
            Object object4 = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"url");
            object2 = ((String)object4).substring(0, ((String)object4).length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        Object object5 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"url");
        return object5;
    }

    public final void getInbox(@NotNull InboxPushRequest inboxPushRequest, @Nullable BaseCallback baseCallback) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)inboxPushRequest, (String)"pushRequest");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        Context context = inboxPushRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"pushRequest.context");
        String string = stringBuilder.append(this.getApiURL(context)).append(this.ENDPOINT_INBOX_NOTIFICATIONS).toString();
        BaseRequest baseRequest = inboxPushRequest.getInboxPushRequest();
        Context context2 = inboxPushRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"pushRequest.context");
        BaseClient.get(string, baseRequest, new InboxResponse(context2, baseCallback));
    }

    public final void putInboxPush(@NotNull InboxPushRequest inboxPushRequest, @Nullable BaseCallback baseCallback) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)inboxPushRequest, (String)"pushRequest");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        Context context = inboxPushRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"pushRequest.context");
        String string = stringBuilder.append(this.getApiURL(context)).append(this.ENDPOINT_INBOX_NOTIFICATIONS).toString();
        BaseRequest baseRequest = inboxPushRequest.putInboxPushRequest();
        Context context2 = inboxPushRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"pushRequest.context");
        BaseClient.put(string, baseRequest, new InboxResponse(context2, baseCallback));
    }

    public final void getInboxPushWithSendingId(@NotNull InboxPushRequest inboxPushRequest, @Nullable BaseCallback baseCallback) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)inboxPushRequest, (String)"pushRequest");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        Context context = inboxPushRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"pushRequest.context");
        String string = stringBuilder.append(this.getApiURL(context)).append(this.ENDPOINT_INBOX_NOTIFICATIONS_WITH_SENDINGID).toString();
        BaseRequest baseRequest = inboxPushRequest.getInboxPushRequestWithSendingId();
        Context context2 = inboxPushRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"pushRequest.context");
        BaseClient.get(string, baseRequest, new InboxResponse(context2, baseCallback));
    }

    public final void putInboxPushWithSendingId(@NotNull InboxPushRequest inboxPushRequest, @Nullable BaseCallback baseCallback) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)inboxPushRequest, (String)"pushRequest");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        Context context = inboxPushRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"pushRequest.context");
        String string = stringBuilder.append(this.getApiURL(context)).append(this.ENDPOINT_INBOX_NOTIFICATIONS_WITH_SENDINGID).toString();
        BaseRequest baseRequest = inboxPushRequest.putInboxPushRequestWithSendingId();
        Context context2 = inboxPushRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"pushRequest.context");
        BaseClient.put(string, baseRequest, new InboxResponse(context2, baseCallback));
    }

    public final void getInboxCounter(@NotNull InboxCountersRequest inboxCountersRequest, @Nullable BaseCallback baseCallback) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)inboxCountersRequest, (String)"request");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        Context context = inboxCountersRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context");
        String string = stringBuilder.append(this.getApiURL(context)).append(this.ENDPOINT_INBOX_COUNTER).toString();
        BaseRequest baseRequest = inboxCountersRequest.getInboxCounters();
        Context context2 = inboxCountersRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"request.context");
        BaseClient.get(string, baseRequest, new InboxResponse(context2, baseCallback));
    }

    public final void postInboxAuth(@NotNull InboxAuthenticationRequest inboxAuthenticationRequest, @Nullable BaseCallback baseCallback) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)inboxAuthenticationRequest, (String)"request");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        Context context = inboxAuthenticationRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context");
        String string = stringBuilder.append(this.getApiURL(context)).append(this.ENDPOINT_INBOX_AUTH).toString();
        BaseRequest baseRequest = inboxAuthenticationRequest.postInboxAuth();
        Context context2 = inboxAuthenticationRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"request.context");
        BaseClient.post(string, baseRequest, new InboxAuthenticationResponse(context2, baseCallback));
    }
}

