/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.inbox.api.request;

import android.content.Context;
import com.indigitall.android.commons.api.requests.BaseRequest;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.inbox.models.InboxAuthMode;
import com.indigitall.android.inbox.models.InboxStatus;
import java.net.URLEncoder;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\nH\u0002J\b\u0010\u001c\u001a\u00020\nH\u0002J\u0006\u0010\u001d\u001a\u00020\u0001J\u0006\u0010\u001e\u001a\u00020\u0001J\u0006\u0010\u001f\u001a\u00020\u0001J\u0006\u0010 \u001a\u00020\u0001J\u0019\u0010!\u001a\u00020\"2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010&\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010'\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010(\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010)\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u000fJ\u001e\u0010*\u001a\u00020\"2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0015j\b\u0012\u0004\u0012\u00020\u000f`\u0016J\u000e\u0010+\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\nR\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0015j\n\u0012\u0004\u0012\u00020\u000f\u0018\u0001`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/indigitall/android/inbox/api/request/InboxPushRequest;", "Lcom/indigitall/android/commons/api/requests/BaseRequest;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "allStatus", "", "Lcom/indigitall/android/inbox/models/InboxStatus;", "[Lcom/indigitall/android/inbox/models/InboxStatus;", "dateFrom", "", "dateTo", "externalId", "kotlin.jvm.PlatformType", "page", "", "Ljava/lang/Integer;", "pageSize", "sendingId", "sendingIdTag", "sendingIds", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "status", "createBodyJson", "Lorg/json/JSONObject;", "createBodyStatusJson", "createQueryString", "createQueryStringExternalId", "getInboxPushRequest", "getInboxPushRequestWithSendingId", "putInboxPushRequest", "putInboxPushRequestWithSendingId", "setAllStatus", "", "([Lcom/indigitall/android/inbox/models/InboxStatus;)V", "setDateFrom", "setDateTo", "setExternalId", "setPage", "setPageSize", "setSendingId", "setSendingIds", "setStatus", "inbox_release"})
public final class InboxPushRequest
extends BaseRequest {
    private String externalId;
    @Nullable
    private Integer page;
    @Nullable
    private Integer pageSize;
    @Nullable
    private String dateFrom;
    @Nullable
    private String dateTo;
    @Nullable
    private InboxStatus[] allStatus;
    @Nullable
    private String status;
    @Nullable
    private ArrayList<Integer> sendingIds;
    private int sendingId;
    @NotNull
    private String sendingIdTag;

    public InboxPushRequest(@Nullable Context object) {
        InboxPushRequest inboxPushRequest = this;
        super((Context)object);
        inboxPushRequest.externalId = CorePreferenceUtils.getExternalId(object);
        inboxPushRequest.sendingIdTag = "{sendingId}";
        this.context = object;
        String string = CorePreferenceUtils.getExternalId(object);
        if (string != null) {
            this.externalId = string;
        }
        if (Intrinsics.areEqual((Object)CorePreferenceUtils.getInboxAuthMode(object), (Object)InboxAuthMode.WEBHOOK.getMode()) && (object = CorePreferenceUtils.getAuthToken(object)) != null) {
            this.headers.put("Authorization", "Bearer " + (String)object);
        }
    }

    private final String createQueryString() {
        String string = "";
        if (this.page != null) {
            string = string + "page=" + this.page + '&';
        }
        if (this.pageSize != null) {
            string = string + "pageSize=" + this.pageSize + '&';
        }
        if (this.dateFrom != null) {
            string = string + "dateFrom=" + this.dateFrom + '&';
        }
        if (this.dateTo != null) {
            string = string + "dateTo=" + this.dateTo + '&';
        }
        Object object = this.allStatus;
        if (this.allStatus != null) {
            object = "";
            Intrinsics.checkNotNull((Object)object);
            int n = ((InboxStatus[])object).length;
            for (int i = 0; i < n; ++i) {
                StringBuilder stringBuilder = new StringBuilder().append((String)object);
                Intrinsics.checkNotNull((Object)this.allStatus);
                object = stringBuilder.append((Object)this.allStatus[i]).toString();
                Intrinsics.checkNotNull((Object)this.allStatus);
                if (i == this.allStatus.length - 1) continue;
                object = (String)object + ',';
            }
            String string2 = ((String)object).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
            string = string + "status=" + URLEncoder.encode(string2, "utf-8") + '&';
        }
        return string + this.createQueryStringExternalId();
    }

    private final String createQueryStringExternalId() {
        InboxPushRequest inboxPushRequest = string;
        String string = "externalId=" + ((InboxPushRequest)((Object)string)).externalId + '&';
        String string2 = "android";
        if (CorePreferenceUtils.getHarmonyEnabled(inboxPushRequest.context)) {
            string2 = "harmony";
        }
        return (String)string + "platform=" + string2;
    }

    private final JSONObject createBodyJson() {
        JSONArray jSONArray;
        JSONObject jSONObject;
        block8: {
            JSONArray jSONArray2;
            JSONObject jSONObject2;
            jSONObject = jSONObject2;
            jSONObject();
            jSONArray = jSONArray2;
            jSONArray2 = new JSONArray();
            Object object = "status";
            jSONObject2.put((String)object, (Object)this.status);
            object = this.sendingIds;
            if (object == null) break block8;
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            int n = ((ArrayList)object2).size();
            for (int i = 0; i < n; ++i) {
                JSONArray jSONArray3 = jSONArray;
                ArrayList<Integer> arrayList = this.sendingIds;
                Intrinsics.checkNotNull(arrayList);
                Integer n2 = arrayList.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"sendingIds!![i]");
                jSONArray3.put(((Number)n2).intValue());
            }
        }
        try {
            jSONObject.put("sendingIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    private final JSONObject createBodyStatusJson() {
        JSONObject jSONObject = new JSONObject().put("status", (Object)this.status);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"JSONObject().put(PARAM_INBOX_STATUS, status)");
        return jSONObject;
    }

    @NotNull
    public final BaseRequest getInboxPushRequest() {
        InboxPushRequest inboxPushRequest = this;
        inboxPushRequest.params = inboxPushRequest.createQueryString();
        return inboxPushRequest;
    }

    @NotNull
    public final BaseRequest putInboxPushRequest() {
        InboxPushRequest inboxPushRequest = this;
        inboxPushRequest.params = inboxPushRequest.createQueryStringExternalId();
        inboxPushRequest.body = inboxPushRequest.createBodyJson();
        return inboxPushRequest;
    }

    @NotNull
    public final BaseRequest getInboxPushRequestWithSendingId() {
        InboxPushRequest inboxPushRequest = this;
        inboxPushRequest.path.put(this.sendingIdTag, String.valueOf(this.sendingId));
        inboxPushRequest.params = inboxPushRequest.createQueryStringExternalId();
        return inboxPushRequest;
    }

    @NotNull
    public final BaseRequest putInboxPushRequestWithSendingId() {
        InboxPushRequest inboxPushRequest = this;
        inboxPushRequest.path.put(this.sendingIdTag, String.valueOf(this.sendingId));
        inboxPushRequest.params = inboxPushRequest.createQueryStringExternalId();
        inboxPushRequest.body = inboxPushRequest.createBodyStatusJson();
        return inboxPushRequest;
    }

    public final void setSendingId(int n) {
        this.sendingId = n;
    }

    public final void setExternalId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"externalId");
        this.externalId = string;
    }

    public final void setSendingIds(@NotNull ArrayList<Integer> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"sendingIds");
        this.sendingIds = arrayList;
    }

    public final void setPage(int n) {
        this.page = n;
    }

    public final void setPageSize(int n) {
        this.pageSize = n;
    }

    public final void setDateFrom(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"dateFrom");
        this.dateFrom = string;
    }

    public final void setDateTo(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"dateTo");
        this.dateTo = string;
    }

    public final void setAllStatus(@NotNull InboxStatus[] inboxStatusArray) {
        Intrinsics.checkNotNullParameter((Object)inboxStatusArray, (String)"allStatus");
        this.allStatus = inboxStatusArray;
    }

    public final void setStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"status");
        this.status = string;
    }
}

