/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push;

import android.content.Context;
import com.indigitall.android.commons.CoreConfiguration;
import com.indigitall.android.commons.models.LayoutBasic;
import com.indigitall.android.commons.models.LogLevel;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.Log;
import com.indigitall.android.commons.utils.SecretDataUtils;
import com.indigitall.android.commons.utils.Utils;
import com.indigitall.android.push.utils.PushPreferenceUtils;
import com.indigitall.android.push.utils.ServiceUtils;
import java.lang.reflect.InvocationTargetException;
import org.json.JSONException;
import org.json.JSONObject;

public class Configuration
extends CoreConfiguration {
    private static final String JSON_CONFIGURATION = "configuration";
    private static final String JSON_ENABLED = "enabled";
    private static final String JSON_LOCATION_ENABLED = "locationEnabled";
    private static final String JSON_LOCATION_ACCURACY = "locationAccuracy";
    private static final String JSON_LOCATION_DISTANCE = "locationDistance";
    private static final String JSON_LOCATION_UPDATE_MINUTES = "locationUpdateMinutes";
    private static final String JSON_MAINTENANCE_WINDOW = "maintenanceWindow";
    private static final String JSON_SERVICE_SYNC_TIME = "serviceSyncTime";
    private static final String JSON_START = "start";
    private static final String JSON_END = "end";
    private static final String JSON_NETWORK_UPDATE_MINUTES_EVENT = "networkUpdateMinutes";
    private static final String JSON_NETWORK_EVENTS_ENABLED = "networkEventsEnabled";
    private static final String JSON_INAPP_ENABLED = "inAppEnabled";
    private static final String JSON_INBOX_AUTH_MODE = "inboxAuthMode";
    private static final String JSON_SECURE_SENDING_ENABLED = "secureSendingEnabled";
    private static final String JSON_SECURE_SENDING_APP_PUBLICKEY = "secureSendingAppPublicKey";
    private static final String JSON_LAYOUT_BASIC = "layoutBasic";
    private boolean force;
    private String senderId;
    private boolean networkEventsEnabled;
    private int networkUpdateMinutes;
    private boolean wifiFilterEnabled;
    private boolean inAppEnabled;
    private String inboxAuthMode;
    private String secureSendingEnabled;
    private String secureSendingAppPublicKey;
    private String urlInboxApi;
    private LayoutBasic layoutBasic;
    private boolean alwaysLaunchOnInit;
    private Boolean autoRequestPushPermission;

    private Configuration() {
        Configuration configuration = this;
        configuration.networkEventsEnabled = false;
        configuration.networkUpdateMinutes = 0;
        configuration.wifiFilterEnabled = false;
        configuration.inAppEnabled = false;
        configuration.inboxAuthMode = null;
        configuration.urlInboxApi = "https://inbox-api.indigitall.com/v1";
        configuration.layoutBasic = null;
        configuration.alwaysLaunchOnInit = false;
        configuration.autoRequestPushPermission = Boolean.TRUE;
        configuration.setProductName("android");
        configuration.setProductVersion("5.6.2");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration(JSONObject object) {
        Configuration configuration = this;
        configuration.networkEventsEnabled = false;
        configuration.networkUpdateMinutes = 0;
        configuration.wifiFilterEnabled = false;
        configuration.inAppEnabled = false;
        configuration.inboxAuthMode = null;
        configuration.urlInboxApi = "https://inbox-api.indigitall.com/v1";
        configuration.layoutBasic = null;
        configuration.alwaysLaunchOnInit = false;
        configuration.autoRequestPushPermission = Boolean.TRUE;
        configuration.setEnabled(1);
        if (object == null) return;
        if (!object.has(JSON_CONFIGURATION)) return;
        JSONObject jSONObject = object.getJSONObject(JSON_CONFIGURATION);
        if (jSONObject.has(JSON_ENABLED)) {
            this.setEnabled(jSONObject.getBoolean(JSON_ENABLED) ? 1 : 0);
        }
        if (jSONObject.has(JSON_LOCATION_ENABLED)) {
            this.setLocationEnabled(jSONObject.getBoolean(JSON_LOCATION_ENABLED));
        }
        if (jSONObject.has(JSON_LOCATION_ACCURACY)) {
            this.setLocationAccuracy(jSONObject.getInt(JSON_LOCATION_ACCURACY));
        }
        if (jSONObject.has(JSON_LOCATION_DISTANCE)) {
            this.setLocationDistance(jSONObject.getInt(JSON_LOCATION_DISTANCE));
        }
        if (jSONObject.has(JSON_LOCATION_UPDATE_MINUTES)) {
            this.setLocationUpdateMinutes(jSONObject.getInt(JSON_LOCATION_UPDATE_MINUTES));
        }
        if (jSONObject.has(JSON_SERVICE_SYNC_TIME)) {
            this.setServiceSyncTime(jSONObject.getInt(JSON_SERVICE_SYNC_TIME));
        }
        if (jSONObject.has(JSON_NETWORK_UPDATE_MINUTES_EVENT)) {
            this.networkUpdateMinutes = jSONObject.getInt(JSON_NETWORK_UPDATE_MINUTES_EVENT);
        }
        if (jSONObject.has(JSON_NETWORK_EVENTS_ENABLED)) {
            this.networkEventsEnabled = jSONObject.getBoolean(JSON_NETWORK_EVENTS_ENABLED);
        }
        if (jSONObject.has(JSON_MAINTENANCE_WINDOW)) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(JSON_MAINTENANCE_WINDOW);
            if (jSONObject2.has(JSON_START)) {
                this.setMaintenanceStart(jSONObject2.getString(JSON_START));
            }
            if (jSONObject2.has(JSON_END)) {
                this.setMaintenanceEnd(jSONObject2.getString(JSON_END));
            }
        }
        if (jSONObject.has(JSON_INAPP_ENABLED)) {
            this.inAppEnabled = jSONObject.getBoolean(JSON_INAPP_ENABLED);
        }
        if (jSONObject.has(JSON_INBOX_AUTH_MODE)) {
            this.inboxAuthMode = jSONObject.getString(JSON_INBOX_AUTH_MODE);
        }
        if (jSONObject.has(JSON_SECURE_SENDING_ENABLED)) {
            void var2_7;
            if (jSONObject.getBoolean(JSON_SECURE_SENDING_ENABLED)) {
                String string = "true";
            } else {
                String string = "false";
            }
            this.secureSendingEnabled = var2_7;
        }
        if (jSONObject.has(JSON_SECURE_SENDING_APP_PUBLICKEY)) {
            this.secureSendingAppPublicKey = jSONObject.getString(JSON_SECURE_SENDING_APP_PUBLICKEY);
        }
        if (!jSONObject.has(JSON_LAYOUT_BASIC)) return;
        String string = jSONObject.getString(JSON_LAYOUT_BASIC);
        LayoutBasic layoutBasic = LayoutBasic.custom;
        try {
            if (!string.equals(layoutBasic.name())) return;
            this.layoutBasic = layoutBasic;
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    static /* synthetic */ String access$102(Configuration configuration, String string) {
        configuration.senderId = string;
        return string;
    }

    static /* synthetic */ Boolean access$202(Configuration configuration, Boolean bl) {
        configuration.autoRequestPushPermission = bl;
        return bl;
    }

    static /* synthetic */ boolean access$302(Configuration configuration, boolean bl) {
        configuration.wifiFilterEnabled = bl;
        return bl;
    }

    static /* synthetic */ String access$402(Configuration configuration, String string) {
        configuration.urlInboxApi = string;
        return string;
    }

    static /* synthetic */ LayoutBasic access$502(Configuration configuration, LayoutBasic layoutBasic) {
        configuration.layoutBasic = layoutBasic;
        return layoutBasic;
    }

    static /* synthetic */ boolean access$602(Configuration configuration, boolean bl) {
        configuration.alwaysLaunchOnInit = bl;
        return bl;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public boolean isNetworkEventsEnabled() {
        return this.networkEventsEnabled;
    }

    public boolean isPlatformEnabled() {
        return this.getEnabled() == 1;
    }

    public void updateConfiguration(Context context, boolean bl) {
        this.force = bl;
        this.updateConfiguration(context);
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isLocationEnabled() {
        return this.getLocationEnabled();
    }

    public boolean isInAppEnabled() {
        return this.inAppEnabled;
    }

    public String getInboxauthMode() {
        return this.inboxAuthMode;
    }

    public String getSecureSendingAppPublicKey() {
        return this.secureSendingAppPublicKey;
    }

    public Boolean getAutoRequestPushPermission() {
        return this.autoRequestPushPermission;
    }

    public void setAutoRequestPushPermission(Boolean bl) {
        this.autoRequestPushPermission = bl;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateConfiguration(Context var1_1) {
        block25: {
            block23: {
                block26: {
                    block24: {
                        var2_2 = v0;
                        v0 = new Log("[IND][CONFIG]", var1_1);
                        if (!(this.getDefaultActivity() == null || CorePreferenceUtils.getDefaultActivity(var1_1) != null && CorePreferenceUtils.getDefaultActivity(var1_1).equals(this.getDefaultActivity()))) {
                            CorePreferenceUtils.setDefaultActivity(var1_1, this.getDefaultActivity());
                        }
                        if ((CorePreferenceUtils.getApiEnabled(var1_1) || this.force) && this.getEnabled() != 0) {
                            CorePreferenceUtils.setApiEnabled(var1_1, this.getEnabled());
                        }
                        if (this.getAppKey() != null) {
                            CorePreferenceUtils.setAppKey(var1_1, this.getAppKey());
                        }
                        if ((var3_3 = this.senderId) != null) {
                            PushPreferenceUtils.Companion.setSenderId(var1_1, (String)var3_3);
                        }
                        if (CorePreferenceUtils.getProductName(var1_1) != null && !this.force || this.getProductName() == null) break block25;
                        if (ServiceUtils.isGoogleServicesEnabled(var1_1)) break block26;
                        var3_3 = Utils.INSTANCE.isImplementedClass("com.indigitall.android.hms.utils.HMSUtils");
                        if (var3_3 == null) break block23;
                        v1 = var3_3;
                        v2 = new Class[1];
                        var4_7 = v2;
                        v2[0] = Context.class;
                        var3_3 = (Boolean)v1.getDeclaredMethod("isHarmonyEnabled", var4_7).invoke(var3_3, new Object[]{var1_1});
                        if (var3_3 == null) ** GOTO lbl36
                        if (!var3_3.booleanValue()) ** GOTO lbl36
                        v3 = this;
                        CorePreferenceUtils.setHarmonyEnabled(var1_1, true);
                        try {
                            v3.setProductName("harmony");
                            break block23;
lbl36:
                            // 2 sources

                            CorePreferenceUtils.setHarmonyEnabled(var1_1, false);
                        }
                        catch (IllegalAccessException var3_4) {
                            break block24;
                        }
                        catch (InvocationTargetException var3_5) {
                            break block24;
                        }
                        catch (NoSuchMethodException var3_6) {
                            // empty catch block
                        }
                        break block23;
                    }
                    var3_3.printStackTrace();
                    CorePreferenceUtils.setHarmonyEnabled(var1_1, false);
                    break block23;
                }
                CorePreferenceUtils.setHarmonyEnabled(var1_1, false);
            }
            CorePreferenceUtils.setProductName(var1_1, this.getProductName());
        }
        if ((CorePreferenceUtils.getProductVersion(var1_1) == null || this.force) && this.getProductVersion() != null) {
            CorePreferenceUtils.setProductVersion(var1_1, this.getProductVersion());
        }
        if (CorePreferenceUtils.getServiceSyncTime(var1_1) == 0 || this.force) {
            CorePreferenceUtils.setServiceSyncTime(var1_1, this.getServiceSyncTime());
        }
        if (CorePreferenceUtils.getMaintenanceStart(var1_1) != null || this.force) {
            CorePreferenceUtils.setMaintenanceStart(var1_1, this.getMaintenanceStart());
        }
        if (CorePreferenceUtils.getMaintenanceEnd(var1_1) != null || this.force) {
            CorePreferenceUtils.setMaintenanceEnd(var1_1, this.getMaintenanceEnd());
        }
        if (this.force) {
            CorePreferenceUtils.setLocationEnabled(var1_1, this.getLocationEnabled());
            CorePreferenceUtils.setLocationAccuracy(var1_1, this.getLocationAccuracy());
            CorePreferenceUtils.setLocationDistance(var1_1, this.getLocationDistance());
            CorePreferenceUtils.setLocationUpdateMinutes(var1_1, this.getLocationUpdateMinutes());
            PushPreferenceUtils.Companion.setNetworkUpdateMinutes(var1_1, this.networkUpdateMinutes);
            CorePreferenceUtils.setInboxAuthMode(var1_1, this.inboxAuthMode);
        }
        if (this.wifiFilterEnabled && (var3_3 = PushPreferenceUtils.Companion).getNetworkEventsEnabled(var1_1)) ** GOTO lbl-1000
        var3_3 = PushPreferenceUtils.Companion;
        var3_3.setNetworkEventsEnabled(var1_1, false);
        if (var3_3.getWifiFilterEnabled(var1_1) && this.networkEventsEnabled) lbl-1000:
        // 2 sources

        {
            var3_3.setNetworkEventsEnabled(var1_1, true);
        } else {
            var3_3.setNetworkEventsEnabled(var1_1, false);
        }
        if (!this.force) {
            var3_3 = PushPreferenceUtils.Companion;
            var3_3.setWifiFilterEnabled(var1_1, this.wifiFilterEnabled);
            CorePreferenceUtils.setLogLevel(var1_1, this.getLogLevel());
            CorePreferenceUtils.setApiURL(var1_1, this.getUrlDeviceApi());
            CorePreferenceUtils.setInBoxApiURL(var1_1, this.urlInboxApi);
            var3_3.setAlwaysLaunchOnInit(var1_1, this.alwaysLaunchOnInit);
            CorePreferenceUtils.setAvoidCypher(var1_1, this.getAvoidCypher());
        }
        if ((var3_3 = this.layoutBasic) != null) {
            PushPreferenceUtils.Companion.setLayoutBasic(var1_1, (LayoutBasic)var3_3);
        }
        if ((var3_3 = this.secureSendingEnabled) != null) {
            CorePreferenceUtils.setSecuredDataEnabled(var1_1, var3_3.equals("true"));
            if (this.secureSendingEnabled.equals("true") && this.secureSendingAppPublicKey != null) {
                this = new SecretDataUtils().cleanKey(this.secureSendingAppPublicKey);
                var2_2.d("updateConfiguration: " + (String)this).writeLog();
                CorePreferenceUtils.setSecureSendingAppPublicKey(var1_1, this);
            }
        }
    }

    public static class Builder {
        Configuration configuration;

        public Builder(String string, String string2) {
            Configuration configuration;
            Configuration configuration2;
            Builder builder = this;
            Configuration configuration3 = configuration2 = configuration;
            configuration3();
            this.configuration = configuration3;
            configuration.setAppKey(string);
            Configuration.access$102(builder.configuration, string2);
            builder.configuration.setLogLevel(LogLevel.DEBUG);
        }

        public Builder setProductName(String string) {
            Builder builder = this;
            builder.configuration.setProductName(string);
            return builder;
        }

        public Builder setProductVersion(String string) {
            Builder builder = this;
            builder.configuration.setProductVersion(string);
            return builder;
        }

        public Builder setAutoRequestPushPermission(boolean bl) {
            Builder builder = this;
            Configuration.access$202(builder.configuration, bl);
            return builder;
        }

        public Builder setAutoRequestPermissionLocation(boolean bl) {
            Builder builder = this;
            builder.configuration.setAutoRequestPermissionLocation(bl);
            return builder;
        }

        public Builder setAutoRequestPermissionTelephony(boolean bl) {
            Builder builder = this;
            builder.configuration.setAutoRequestPermissionTelephony(bl);
            return builder;
        }

        public Builder wifiFilterEnabled(boolean bl) {
            Builder builder = this;
            Configuration.access$302(builder.configuration, bl);
            return builder;
        }

        public Builder setDefaultActivity(String string) {
            Builder builder = this;
            builder.configuration.setDefaultActivity(string);
            return builder;
        }

        public Builder setLogDebug(LogLevel logLevel) {
            Builder builder = this;
            builder.configuration.setLogLevel(logLevel);
            return builder;
        }

        public Builder setUrlDeviceApi(String string) {
            Builder builder = this;
            builder.configuration.setUrlDeviceApi(string);
            return builder;
        }

        public Builder setUrlInboxApi(String string) {
            Builder builder = this;
            Configuration.access$402(builder.configuration, string);
            return builder;
        }

        public Builder setLayoutBasic(LayoutBasic layoutBasic) {
            Builder builder = this;
            Configuration.access$502(builder.configuration, layoutBasic);
            return builder;
        }

        public Builder setAlwaysLaunchOnInit(boolean bl) {
            Builder builder = this;
            Configuration.access$602(builder.configuration, bl);
            return builder;
        }

        public Builder setAvoidCypher(boolean bl) {
            Builder builder = this;
            builder.configuration.setAvoidCypher(bl);
            return builder;
        }

        public Configuration build() {
            return this.configuration;
        }
    }
}

