/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationManagerCompat;
import com.indigitall.android.commons.callbacks.BaseCallback;
import com.indigitall.android.commons.models.ErrorModel;
import com.indigitall.android.commons.models.ExecutorType;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.CoreValidations;
import com.indigitall.android.commons.utils.Log;
import com.indigitall.android.commons.utils.Utils;
import com.indigitall.android.push.Configuration;
import com.indigitall.android.push.api.Client;
import com.indigitall.android.push.api.requests.ApplicationRequest;
import com.indigitall.android.push.api.requests.DeviceRequest;
import com.indigitall.android.push.api.requests.EventRequest;
import com.indigitall.android.push.callbacks.DeviceCallback;
import com.indigitall.android.push.callbacks.EventCallback;
import com.indigitall.android.push.callbacks.InitCallBack;
import com.indigitall.android.push.callbacks.PushTokenCallback;
import com.indigitall.android.push.callbacks.TopicsCallback;
import com.indigitall.android.push.models.Device;
import com.indigitall.android.push.models.ExternalApp;
import com.indigitall.android.push.models.Permission;
import com.indigitall.android.push.models.PushErrorCode;
import com.indigitall.android.push.models.PushErrorModel;
import com.indigitall.android.push.models.Topic;
import com.indigitall.android.push.utils.PushErrorUtils;
import com.indigitall.android.push.utils.PushPreferenceUtils;
import com.indigitall.android.push.utils.ServiceUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

public class IndigitallPush {
    private static final String TAG = "[IND]IndigitallPush";

    public static void init(Context context, String string, String string2) {
        IndigitallPush.init(context, string, string2, null);
    }

    public static void init(Context context, String string, String string2, @Nullable InitCallBack initCallBack) {
        IndigitallPush.init(context, new Configuration.Builder(string, string2).build(), initCallBack);
    }

    public static void init(Context context, Configuration configuration) {
        IndigitallPush.init(context, configuration, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init(final Context context, final Configuration configuration, final @Nullable InitCallBack initCallBack) {
        try {
            if (configuration.getAppKey() == null) return;
            if (configuration.getSenderId() == null) return;
            if (configuration.getDefaultActivity() == null && CorePreferenceUtils.getDefaultActivity(context) == null && context instanceof Activity) {
                Context context2 = context;
                IndigitallPush.setDefaultActivity(context2, (Activity)context2);
            } else if (CorePreferenceUtils.getDefaultActivity(context) != null && configuration.getDefaultActivity() == null) {
                configuration.setDefaultActivity(CorePreferenceUtils.getDefaultActivity(context));
            }
            configuration.updateConfiguration(context);
            Client.getApplicationAll(new ApplicationRequest(context), new BaseCallback(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void onSuccess(JSONObject var1_1) {
                    block11: {
                        var2_3 = v0;
                        var2_3((JSONObject)var1_1);
                        v0.updateConfiguration(context, true);
                        var3_4 = v1;
                        v1 = new DeviceRequest(context, (JSONObject)var1_1);
                        if (!v0.isPlatformEnabled()) ** GOTO lbl23
                        if (CorePreferenceUtils.getDeviceId(context) == null) ** GOTO lbl23
                        if (CorePreferenceUtils.getDeviceId(context).equals("null")) ** GOTO lbl23
                        v2 = this;
                        Client.putDevice(var3_4, -1, new DeviceCallback(v2, v2.context, var2_3){
                            final /* synthetic */ Configuration val$remoteConfiguration;
                            final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = var1_1;
                                this.val$remoteConfiguration = configuration;
                                super(context);
                            }

                            @Override
                            public void onSuccess(Device object) {
                                Permission[] permissionArray = configuration.this$0;
                                if (configuration.this$0.initCallBack != null) {
                                    permissionArray = Permission.getPermissions(permissionArray.context);
                                    configuration.this$0.initCallBack.onIndigitallInitialized(permissionArray, (Device)object);
                                }
                                object = configuration.this$0;
                                1 v0 = configuration;
                                Configuration configuration = object.configuration;
                                ServiceUtils.registerServices(object.context, configuration, v0.val$remoteConfiguration);
                            }

                            @Override
                            public void onFail(ErrorModel errorModel) {
                                InitCallBack initCallBack = initCallBack.this$0.initCallBack;
                                if (initCallBack != null) {
                                    initCallBack.onErrorInitialized(errorModel);
                                }
                            }
                        });
                        var1_1 = Utils.INSTANCE;
                        if (!var1_1.isServiceTimestampExceed(context)) break block11;
                        Client.postEventVisit(new EventRequest(context));
                        var1_1.setServiceTimeStamp(context);
                        break block11;
lbl23:
                        // 3 sources

                        if (!var2_3.isPlatformEnabled()) ** GOTO lbl28
                        v3 = this;
                        Client.postDevice(var3_4, new DeviceCallback(v3, v3.context, var2_3){
                            final /* synthetic */ Configuration val$remoteConfiguration;
                            final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = var1_1;
                                this.val$remoteConfiguration = configuration;
                                super(context);
                            }

                            @Override
                            public void onSuccess(Device device) {
                                Permission[] permissionArray;
                                PushPreferenceUtils.Companion companion = PushPreferenceUtils.Companion;
                                Object object = companion.getPushToken(permissionArray.this$0.context);
                                if (object != null) {
                                    int n = NotificationManagerCompat.from((Context)permissionArray.this$0.context).areNotificationsEnabled();
                                    ServiceUtils.registerPushToken(permissionArray.this$0.context, (String)object, n);
                                    device.setPushToken((String)object);
                                    object = permissionArray.this$0.initCallBack;
                                    if (object != null) {
                                        ((InitCallBack)object).onNewUserRegistered(device);
                                    }
                                } else {
                                    object = permissionArray.this$0;
                                    IndigitallPush.getPushToken(object.context, device, object.initCallBack);
                                }
                                1 v0 = permissionArray.this$0;
                                object = v0;
                                object = object.configuration;
                                ServiceUtils.registerServices(v0.context, (Configuration)object, permissionArray.val$remoteConfiguration);
                                Client.postEventVisit(new EventRequest(permissionArray.this$0.context));
                                Utils.INSTANCE.setServiceTimeStamp(permissionArray.this$0.context);
                                object = permissionArray.this$0;
                                if (object.initCallBack != null && companion.getAlwaysLaunchOnInit(object.context)) {
                                    permissionArray = Permission.getPermissions(permissionArray.this$0.context);
                                    permissionArray.this$0.initCallBack.onIndigitallInitialized(permissionArray, device);
                                }
                            }

                            @Override
                            public void onFail(ErrorModel errorModel) {
                                InitCallBack initCallBack = initCallBack.this$0.initCallBack;
                                if (initCallBack != null) {
                                    initCallBack.onErrorInitialized(errorModel);
                                }
                            }
                        });
                        break block11;
lbl28:
                        // 1 sources

                        var1_1 = initCallBack;
                        if (var1_1 == null) break block11;
                        try {
                            var1_1.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_INITIALIZATION_ERROR, "is not platform enabled"));
                        }
                        catch (Exception var1_2) {
                            this = initCallBack;
                            if (this == null) break block11;
                            this.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_INITIALIZATION_ERROR.getErrorId(), "init: " + var1_2.getLocalizedMessage()));
                        }
                    }
                }

                @Override
                public void onFail(ErrorModel errorModel) {
                    JSONObject jSONObject;
                    1 v0 = this_;
                    1 this_ = jSONObject;
                    jSONObject = new JSONObject();
                    v0.onSuccess((JSONObject)this_);
                }
            });
            return;
        }
        catch (Exception exception) {
            if (initCallBack == null) return;
            initCallBack.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_INITIALIZATION_ERROR, "init: " + exception.getLocalizedMessage()));
        }
    }

    private static void getPushToken(final Context context, final Device device, final @Nullable InitCallBack initCallBack) {
        block9: {
            PushTokenCallback pushTokenCallback;
            block11: {
                block12: {
                    if (!CorePreferenceUtils.getHarmonyEnabled(context)) break block11;
                    Class<? extends Object> clazz = Utils.INSTANCE.isImplementedClass("com.indigitall.android.hms.utils.HMSServiceUtils");
                    if (clazz == null) break block12;
                    Class[] classArray = new Class[2];
                    classArray[0] = Context.class;
                    classArray[1] = BaseCallback.class;
                    Method method = clazz.getDeclaredMethod("getHMSPushToken", classArray);
                    Class<? extends Object> clazz2 = clazz;
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = objectArray;
                    objectArray[0] = context;
                    objectArray3[1] = new BaseCallback(){

                        @Override
                        public void onSuccess(JSONObject object) {
                            JSONObject jSONObject = object;
                            object = null;
                            try {
                                object = jSONObject.getString("token");
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                            }
                            if (object != null) {
                                2 v2 = this;
                                ServiceUtils.registerPushToken(v2.context, (String)object, 1);
                                v2.device.setPushToken((String)object);
                            }
                            if ((object = initCallBack) != null) {
                                ((InitCallBack)object).onNewUserRegistered(device);
                            }
                        }

                        @Override
                        public void onFail(ErrorModel errorModel) {
                            InitCallBack initCallBack2 = initCallBack2.initCallBack;
                            if (initCallBack2 != null) {
                                initCallBack2.onErrorInitialized(errorModel);
                            }
                        }

                        @Override
                        public void onError(int n, String string, String string2) {
                            2 v0 = initCallBack2;
                            super.onError(n, string, string2);
                            InitCallBack initCallBack2 = v0.initCallBack;
                            if (initCallBack2 != null) {
                                initCallBack2.onErrorInitialized(n, string, string2);
                            }
                        }
                    };
                    method.invoke(clazz2, objectArray2);
                    break block9;
                }
                if (initCallBack == null) break block9;
                try {
                    initCallBack.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_INITIALIZATION_ERROR, "getPushToken: HMS is not imported"));
                    break block9;
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (initCallBack != null) {
                    initCallBack.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_INITIALIZATION_ERROR, "getPushToken: HMS is not imported"));
                }
                break block9;
            }
            PushTokenCallback pushTokenCallback2 = pushTokenCallback;
            pushTokenCallback = new PushTokenCallback(){

                @Override
                public void onError(@NonNull PushErrorModel pushErrorModel) {
                    InitCallBack initCallBack2 = initCallBack2.initCallBack;
                    if (initCallBack2 != null) {
                        initCallBack2.showError(pushErrorModel);
                    }
                }

                @Override
                public void onSuccess(@Nullable String object) {
                    if (object != null) {
                        3 v0 = this;
                        ServiceUtils.registerPushToken(v0.context, (String)object, 1);
                        v0.device.setPushToken((String)object);
                    }
                    if ((object = initCallBack) != null) {
                        ((InitCallBack)object).onNewUserRegistered(device);
                    }
                }
            };
            ServiceUtils.getPushToken(context, pushTokenCallback2);
        }
    }

    public static void deviceGet(Context context, @Nullable DeviceCallback deviceCallback) {
        Client.getDevice(new DeviceRequest(context), deviceCallback);
    }

    public static void deviceEnable(Context context, @Nullable DeviceCallback deviceCallback) {
        DeviceRequest deviceRequest;
        block4: {
            DeviceRequest deviceRequest2;
            Log log;
            Log log2 = log;
            log = new Log(TAG, context);
            deviceRequest = deviceRequest2;
            deviceRequest2 = new DeviceRequest(context, 1);
            if (PushPreferenceUtils.Companion.getExternalApps(context) != null) {
                if (ExternalApp.getExternalAppsArrayFromStorage(context) == null) break block4;
                try {
                    deviceRequest.getDevice().setExternalApps(ExternalApp.getExternalAppsArrayFromStorage(context));
                }
                catch (Exception exception) {
                    log2.w(exception.getLocalizedMessage()).writeLog();
                    exception.printStackTrace();
                }
            }
        }
        Client.putDevice(deviceRequest, 1, deviceCallback);
    }

    public static void deviceDisable(Context context, @Nullable DeviceCallback deviceCallback) {
        DeviceRequest deviceRequest;
        block5: {
            DeviceRequest deviceRequest2;
            Log log;
            Log log2 = log;
            log = new Log(TAG, context);
            deviceRequest = deviceRequest2;
            deviceRequest2 = new DeviceRequest(context, 0);
            if (PushPreferenceUtils.Companion.getExternalApps(context) != null) {
                if (ExternalApp.getExternalAppsArrayFromStorage(context) == null) break block5;
                try {
                    deviceRequest.getDevice().setExternalApps(ExternalApp.getExternalAppsArrayFromStorage(context));
                }
                catch (Exception exception) {
                    log2.w(exception.getLocalizedMessage()).writeLog();
                    exception.printStackTrace();
                }
                catch (JSONException jSONException) {
                    log2.w(jSONException.getLocalizedMessage()).writeLog();
                    jSONException.printStackTrace();
                }
            }
        }
        Client.putDevice(deviceRequest, 0, deviceCallback);
    }

    public static void topicsList(Context context, @Nullable TopicsCallback topicsCallback) {
        Client.getDeviceTopics(new DeviceRequest(context), topicsCallback);
    }

    public static void topicsSubscribe(Context context, Topic[] topicArray, @Nullable TopicsCallback topicsCallback) {
        block6: {
            String[] stringArray = new String[topicArray.length];
            int n = 0;
            while (true) {
                if (n >= topicArray.length) break;
                stringArray[n] = topicArray[n].getCode();
                ++n;
                continue;
                break;
            }
            try {
                IndigitallPush.topicsSubscribe(context, stringArray, topicsCallback);
            }
            catch (Exception exception) {
                if (topicsCallback == null) break block6;
                topicsCallback.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_TOPICS_ERROR, "topicsSubscribe: " + exception.getLocalizedMessage()));
            }
        }
    }

    public static void topicsSubscribe(Context context, String[] stringArray, @Nullable TopicsCallback topicsCallback) {
        block3: {
            DeviceRequest deviceRequest;
            DeviceRequest deviceRequest2 = deviceRequest;
            try {
                deviceRequest2(context);
                deviceRequest2.setTopics(stringArray);
                Client.postDeviceTopics(deviceRequest, topicsCallback);
            }
            catch (Exception exception) {
                if (topicsCallback == null) break block3;
                topicsCallback.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_TOPICS_ERROR, "topicsSubscribe: " + exception.getLocalizedMessage()));
            }
        }
    }

    public static void topicsUnsubscribe(Context context, Topic[] topicArray, @Nullable TopicsCallback topicsCallback) {
        block6: {
            String[] stringArray = new String[topicArray.length];
            int n = 0;
            while (true) {
                if (n >= topicArray.length) break;
                stringArray[n] = topicArray[n].getCode();
                ++n;
                continue;
                break;
            }
            try {
                IndigitallPush.topicsUnsubscribe(context, stringArray, topicsCallback);
            }
            catch (Exception exception) {
                if (topicsCallback == null) break block6;
                topicsCallback.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_TOPICS_ERROR, "topicsUnsubscribe: " + exception.getLocalizedMessage()));
            }
        }
    }

    public static void topicsUnsubscribe(Context context, String[] stringArray, @Nullable TopicsCallback topicsCallback) {
        block3: {
            DeviceRequest deviceRequest;
            DeviceRequest deviceRequest2 = deviceRequest;
            try {
                deviceRequest2(context);
                deviceRequest2.setTopics(stringArray);
                Client.deleteDeviceTopics(deviceRequest, topicsCallback);
            }
            catch (Exception exception) {
                if (topicsCallback == null) break block3;
                topicsCallback.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_TOPICS_ERROR, "topicsUnsubscribe: " + exception.getLocalizedMessage()));
            }
        }
    }

    public static void setDefaultActivity(Context context, Activity activity) {
        IndigitallPush.setDefaultActivity(context, activity.getClass().getName());
    }

    public static void setDefaultActivity(Context context, String string) {
        CorePreferenceUtils.setDefaultActivity(context, string);
    }

    @Deprecated
    public static void setExternalCode(Context context, String string, DeviceCallback deviceCallback) {
        IndigitallPush.logIn(context, string, deviceCallback);
    }

    public static void logIn(Context context, String string, DeviceCallback deviceCallback) {
        block7: {
            Device device;
            DeviceRequest deviceRequest;
            block6: {
                Device device2;
                DeviceRequest deviceRequest2;
                deviceRequest = deviceRequest2;
                deviceRequest2 = new DeviceRequest(context);
                device = device2;
                device(context);
                device2.setExternalCode(CorePreferenceUtils.getAppKey(context), string);
                if (device2.getExternalCode() == null) break block6;
                CorePreferenceUtils.setExternalId(context, device.getExternalCode());
            }
            try {
                DeviceRequest deviceRequest3 = deviceRequest;
                deviceRequest3.setDevice(device);
                Client.putDevice(deviceRequest3, -1, deviceCallback);
            }
            catch (Exception exception) {
                if (deviceCallback == null) break block7;
                deviceCallback.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_DEVICE_ERROR, "logIn: " + exception.getLocalizedMessage()));
            }
        }
    }

    public static void logOut(Context context, DeviceCallback deviceCallback) {
        block5: {
            Device device;
            Context context2 = context;
            DeviceRequest deviceRequest = new DeviceRequest(context);
            Device device2 = device;
            device2(context);
            device.setExternalCode(CorePreferenceUtils.getAppKey(context), null);
            CorePreferenceUtils.setExternalId(context2, "null");
            try {
                deviceRequest.setDevice(device2);
                Client.putDevice(deviceRequest, -1, deviceCallback);
            }
            catch (Exception exception) {
                if (deviceCallback == null) break block5;
                deviceCallback.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_DEVICE_ERROR, "logOut: " + exception.getLocalizedMessage()));
            }
        }
    }

    public static void sendCustomEvent(Context context, String string, @Nullable EventCallback eventCallback) {
        IndigitallPush.sendCustomEvent(context, string, null, eventCallback);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sendCustomEvent(Context context, String string, JSONObject jSONObject, @Nullable EventCallback eventCallback) {
        EventRequest eventRequest;
        JSONObject jSONObject2;
        try {
            jSONObject2 = jSONObject;
        }
        catch (Exception exception) {
            if (eventCallback == null) return;
            eventCallback.showError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_DEVICE_ERROR, "sendCustomEvent: " + exception.getLocalizedMessage()));
            return;
        }
        EventRequest eventRequest2 = eventRequest;
        {
            eventRequest2(context);
            eventRequest.setEventType(string);
            if (jSONObject2 != null) {
                eventRequest2.setCustomData(jSONObject);
            }
            if (CoreValidations.isExternalIdFormat(context)) {
                Client.postSendJourneyEvent(eventRequest2, eventCallback);
                return;
            }
            Client.postSendCustomEvent(eventRequest2, eventCallback);
            return;
        }
    }

    public static void setExecutorType(Context context, ExecutorType executorType) {
        CorePreferenceUtils.setExecutorType(context, executorType);
    }

    public static void onRequestPermissionsResult(Context context, int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        if (n == 50001 && nArray.length > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                if ("android.permission.ACCESS_FINE_LOCATION".equals(stringArray[n]) && nArray[n] == 0) {
                    ServiceUtils.registerLocationService(context);
                }
                if (!"android.permission.POST_NOTIFICATIONS".equals(stringArray[n])) continue;
                int n2 = 0;
                if (nArray[n] == 0) {
                    n2 = 1;
                }
                PushPreferenceUtils.Companion.setPushEnabled(context, n2);
                Client.putDevice(new DeviceRequest(context, n2), n2, null);
            }
        }
    }
}

