/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.api;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationManagerCompat;
import com.indigitall.android.commons.api.BaseClient;
import com.indigitall.android.commons.callbacks.BaseCallback;
import com.indigitall.android.commons.models.ErrorCode;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.CoreValidations;
import com.indigitall.android.commons.utils.ErrorUtils;
import com.indigitall.android.commons.utils.Utils;
import com.indigitall.android.push.api.requests.ApplicationRequest;
import com.indigitall.android.push.api.requests.DeviceRequest;
import com.indigitall.android.push.api.requests.EventRequest;
import com.indigitall.android.push.api.responses.ApplicationResponse;
import com.indigitall.android.push.api.responses.DeviceResponse;
import com.indigitall.android.push.api.responses.EventResponse;
import com.indigitall.android.push.models.Device;
import com.indigitall.android.push.utils.PushPreferenceUtils;
import com.indigitall.android.push.utils.PushValidations;
import org.json.JSONException;

public class Client
extends BaseClient {
    private static final String TAG = "[IND]api.Client";
    private static final String URL_BASE = "https://device-api.indigitall.com/v1";
    private static final String ENDPOINT_APPLICATION = "/application";
    private static final String ENDPOINT_APPLICATION_ALL = "/application/all";
    private static final String ENDPOINT_DEVICE = "/device";
    private static final String ENDPOINT_DEVICE_TOPICS = "/device/topics";
    private static final String ENDPOINT_PUSH = "/push";
    private static final String ENDPOINT_EVENT = "/event";
    private static final String ENDPOINT_EVENT_PUSH = "/event/push";
    private static final String ENDPOINT_EVENT_CLICK = "/event/click";
    private static final String ENDPOINT_EVENT_VISIT = "/event/visit";
    private static final String ENDPOINT_EVENT_PERMISSION = "/event/permission";
    private static final String ENDPOINT_EVENT_LOCATION = "/event/location";
    private static final String ENDPOINT_EVENT_CUSTOM = "/event/custom";
    private static final String ENDPOINT_EVENT_NETWORK = "/event/network";
    private static final String ENDPOINT_RECEIVED = "/event/received";

    private static String getApiURL(Context object) {
        object = CorePreferenceUtils.getApiURL((Context)object) != null ? CorePreferenceUtils.getApiURL((Context)object) : URL_BASE;
        Object object2 = object;
        if ("/".equals(((String)object2).substring(((String)object2).length() - 1))) {
            Object object3 = object;
            object = ((String)object3).substring(0, ((String)object3).length() - 1);
        }
        return object;
    }

    public static void getApplicationAll(ApplicationRequest applicationRequest, @Nullable BaseCallback baseCallback) {
        if (CoreValidations.isAppKeyFormat(applicationRequest.getContext())) {
            BaseClient.get(Client.getApiURL(applicationRequest.getContext()) + ENDPOINT_APPLICATION_ALL, applicationRequest.getApplicationRequest(), new ApplicationResponse(applicationRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void postDevice(DeviceRequest deviceRequest, @Nullable BaseCallback baseCallback) {
        if (CoreValidations.isAppKeyFormat(deviceRequest.getContext())) {
            BaseClient.post(Client.getApiURL(deviceRequest.getContext()) + ENDPOINT_DEVICE, deviceRequest.postDeviceRequest(), new DeviceResponse(deviceRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void putDevice(DeviceRequest var0, int var1_4, @Nullable BaseCallback var2_6) {
        block25: {
            block26: {
                block24: {
                    block23: {
                        v0 = var1_4;
                        var3_7 = PushPreferenceUtils.Companion;
                        var4_9 = var3_7.getDeviceEnabled(var0.getContext());
                        if (v0 == -1) {
                            if (!NotificationManagerCompat.from((Context)var0.getContext()).areNotificationsEnabled()) {
                                var4_9 = false;
                                var1_4 = 0;
                                break block23;
                            }
                            var4_9 = true;
                            var1_4 = 1;
                        }
                    }
                    v1 = var3_7;
                    v2 = var0;
                    v3 = v2;
                    v2.setStatus(var1_4);
                    var1_5 = Utils.INSTANCE;
                    var5_10 = var1_5.getPutRequestTimeStamp();
                    if (v1.getPutRequestTimestamp(v3.getContext()) == 0L) break block24;
                    var5_10 = var3_7.getPutRequestTimestamp(var0.getContext());
                }
                if (CorePreferenceUtils.getSecuredDataEnabled(var0.getContext())) ** GOTO lbl42
                if (var3_7.getDeviceJson(var0.getContext()) == null) ** GOTO lbl42
                if (var4_9 != var3_7.getDeviceEnabled(var0.getContext())) ** GOTO lbl42
                if (!var3_7.getDeviceJson(var0.getContext()).equals(var0.getDevice().toString())) ** GOTO lbl42
                if (PushValidations.INSTANCE.isPutRequestExceed(var5_10)) ** GOTO lbl42
                if (var2_6 == null) break block25;
                var2_6.onSuccess(Device.Companion.deviceCallback(var0.getContext()));
                break block25;
lbl42:
                // 5 sources

                if (!PushValidations.INSTANCE.isValidFormatRequest(var0.getContext())) break block26;
                v4 = var3_7;
                v5 = var1_5;
                var1_5 = var0.getContext();
                var3_8 = v5.getPutRequestTimeStamp();
                v4.setPutRequestTimestamp((Context)var1_5, var3_8);
                BaseClient.put(Client.getApiURL(var0.getContext()) + "/device", var0.putDeviceRequest(), new DeviceResponse(var0.getContext(), var2_6));
                break block25;
            }
            if (var2_6 == null) break block25;
            try {
                var2_6.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
                break block25;
            }
            catch (NullPointerException var0_1) {
            }
            catch (JSONException var0_2) {
                // empty catch block
            }
            var0_3.printStackTrace();
        }
    }

    public static void getDevice(DeviceRequest deviceRequest, @Nullable BaseCallback baseCallback) {
        if (PushValidations.INSTANCE.isValidFormatRequest(deviceRequest.getContext())) {
            BaseClient.get(Client.getApiURL(deviceRequest.getContext()) + ENDPOINT_DEVICE, deviceRequest.getDeviceRequest(), new DeviceResponse(deviceRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void postDeviceTopics(DeviceRequest deviceRequest, @Nullable BaseCallback baseCallback) {
        if (PushValidations.INSTANCE.isValidFormatRequest(deviceRequest.getContext())) {
            BaseClient.post(Client.getApiURL(deviceRequest.getContext()) + ENDPOINT_DEVICE_TOPICS, deviceRequest.postDeviceTopics(), new DeviceResponse(deviceRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void getDeviceTopics(DeviceRequest deviceRequest, @Nullable BaseCallback baseCallback) {
        if (PushValidations.INSTANCE.isValidFormatRequest(deviceRequest.getContext())) {
            BaseClient.get(Client.getApiURL(deviceRequest.getContext()) + ENDPOINT_DEVICE_TOPICS, deviceRequest.getDeviceTopics(), new DeviceResponse(deviceRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void deleteDeviceTopics(DeviceRequest deviceRequest, @Nullable BaseCallback baseCallback) {
        if (PushValidations.INSTANCE.isValidFormatRequest(deviceRequest.getContext())) {
            BaseClient.delete(Client.getApiURL(deviceRequest.getContext()) + ENDPOINT_DEVICE_TOPICS, deviceRequest.deleteDeviceTopics(), new DeviceResponse(deviceRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void postEventPush(EventRequest eventRequest) {
        EventRequest eventRequest2 = eventRequest;
        String string = Client.getApiURL(eventRequest2.getContext());
        string = eventRequest2.getJourneyStateId() != 0 ? string.replace("v1", "v2") + ENDPOINT_PUSH + ENDPOINT_EVENT_CLICK : string + ENDPOINT_EVENT_PUSH;
        if (PushValidations.INSTANCE.isValidFormatRequest(eventRequest.getContext())) {
            BaseClient.post(string, eventRequest.postEventPushRequest(), null);
        }
    }

    public static void postEventVisit(EventRequest eventRequest) {
        if (PushValidations.INSTANCE.isValidFormatRequest(eventRequest.getContext())) {
            BaseClient.post(Client.getApiURL(eventRequest.getContext()) + ENDPOINT_EVENT_VISIT, eventRequest.postEventVisitRequest(), null);
        }
    }

    public static void postEventPermission(EventRequest eventRequest) {
        if (PushValidations.INSTANCE.isValidFormatRequest(eventRequest.getContext())) {
            BaseClient.post(Client.getApiURL(eventRequest.getContext()) + ENDPOINT_EVENT_PERMISSION, eventRequest.postEventPermissionRequest(), null);
        }
    }

    public static void postEventLocation(EventRequest eventRequest) {
        if (PushValidations.INSTANCE.isValidFormatRequest(eventRequest.getContext())) {
            BaseClient.post(Client.getApiURL(eventRequest.getContext()) + ENDPOINT_EVENT_LOCATION, eventRequest.postEventLocationRequest(), null);
        }
    }

    public static void postSendCustomEvent(EventRequest eventRequest, @Nullable BaseCallback baseCallback) {
        if (PushValidations.INSTANCE.isValidFormatRequest(eventRequest.getContext())) {
            BaseClient.post(Client.getApiURL(eventRequest.getContext()) + ENDPOINT_EVENT_CUSTOM, eventRequest.sendEventCustomRequest(), new EventResponse(eventRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void postSendJourneyEvent(EventRequest eventRequest, @Nullable BaseCallback baseCallback) {
        if (PushValidations.INSTANCE.isValidFormatRequest(eventRequest.getContext())) {
            BaseClient.post(Client.getApiURL(eventRequest.getContext()).replace("v1", "v2") + ENDPOINT_PUSH + ENDPOINT_EVENT_CUSTOM, eventRequest.sendEventCustomRequest(), new EventResponse(eventRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void postSendNetworkEvent(EventRequest eventRequest, @Nullable BaseCallback baseCallback) {
        if (PushValidations.INSTANCE.isValidFormatRequest(eventRequest.getContext())) {
            BaseClient.post(Client.getApiURL(eventRequest.getContext()) + ENDPOINT_EVENT_NETWORK, eventRequest.sendEventNetworkRequest(), new EventResponse(eventRequest.getContext(), baseCallback));
        } else if (baseCallback != null) {
            baseCallback.onFail(ErrorUtils.INSTANCE.showError(ErrorCode.APPKEY_BAD_REQUEST, null));
        }
    }

    public static void postPushReceivedEvent(EventRequest eventRequest) {
        if (PushValidations.INSTANCE.isValidFormatRequest(eventRequest.getContext())) {
            BaseClient.post(Client.getApiURL(eventRequest.getContext()).replace("v1", "v2") + ENDPOINT_PUSH + ENDPOINT_RECEIVED, eventRequest.sendEventPushReceivedRequest(), new EventResponse(eventRequest.getContext(), null));
        }
    }
}

