/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.api.requests;

import android.content.Context;
import com.indigitall.android.commons.api.requests.BaseRequest;
import com.indigitall.android.commons.models.KeyExchange;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.Log;
import com.indigitall.android.commons.utils.SecretDataUtils;
import com.indigitall.android.push.models.Device;
import com.indigitall.android.push.utils.FirebaseUtils;
import com.indigitall.android.push.utils.PushPreferenceUtils;
import java.security.KeyPair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceRequest
extends BaseRequest {
    private static final String TAG = "[IND]DeviceRequest";
    Device device;
    private String[] topics;
    private int status = -1;

    public DeviceRequest(Context context) {
        super(context);
        Device device;
        Device device2 = device;
        device = new Device(context);
        v1.device = device2;
    }

    public DeviceRequest(Context context, JSONObject jSONObject) {
        super(context);
        Device device;
        Device device2 = device;
        device = new Device(context, jSONObject);
        v1.device = device2;
    }

    public DeviceRequest(Context context, int n) {
        this(context);
        this.status = n;
    }

    private String createQueryString() {
        return "deviceId=" + this.device.getDeviceId();
    }

    private JSONObject createPUTDeviceJson(int n) {
        JSONObject jSONObject;
        DeviceRequest deviceRequest = deviceRequest4;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        Device.Companion companion = Device.Companion;
        DeviceRequest deviceRequest2 = deviceRequest4;
        DeviceRequest deviceRequest3 = deviceRequest2;
        DeviceRequest deviceRequest4 = deviceRequest2.context;
        companion.updatePreferencesDevice((Context)deviceRequest4, deviceRequest3.device, n);
        try {
            jSONObject2 = deviceRequest.device.toJson();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject createDeviceJson() {
        JSONObject jSONObject;
        DeviceRequest deviceRequest = deviceRequest2;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        jSONObject2 = deviceRequest.device.toJson();
        int n = deviceRequest.status;
        if (n == -1) return jSONObject2;
        DeviceRequest deviceRequest2 = deviceRequest2.body;
        String string = "enabled";
        boolean bl = n == 1;
        try {
            deviceRequest2.put(string, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject2;
    }

    private KeyExchange createQuerySecuredData() {
        String string = CorePreferenceUtils.getSecureSendingAppPublicKey(((BaseRequest)((Object)keyPair)).context);
        KeyPair keyPair = new SecretDataUtils().getKeyPair(((BaseRequest)((Object)keyPair)).context);
        if (string != null && keyPair != null) {
            return new SecretDataUtils().getDeviceSecuredKeys(keyPair, string);
        }
        return null;
    }

    private JSONObject createTopicsJson() {
        JSONArray jSONArray;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        int n = 0;
        while (true) {
            int n2 = n;
            String[] stringArray = this.topics;
            if (n2 >= this.topics.length) break;
            jSONArray2.put((Object)stringArray[n]);
            ++n;
        }
        try {
            jSONObject2.put("topics", (Object)jSONArray2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject2;
    }

    public DeviceRequest postDeviceRequest() {
        DeviceRequest deviceRequest = this;
        deviceRequest.device.setPushToken(null);
        deviceRequest.body = deviceRequest.createDeviceJson();
        return deviceRequest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseRequest putDeviceRequest() {
        Log log;
        Object object = log;
        log = new Log(TAG, this.context);
        this.params = this.createQueryString();
        String string = FirebaseUtils.INSTANCE.getFirebaseSharedPreferencesToken(this.context);
        if (string != null && !string.equals("") && !string.equals(this.device.getPushToken())) {
            ((Log)object).w("token updated with FirebaseToken").writeLog();
            this.device.setPushToken(string);
            PushPreferenceUtils.Companion.setPushToken(this.context, string);
        }
        DeviceRequest deviceRequest = this;
        object = deviceRequest.createPUTDeviceJson(deviceRequest.status);
        deviceRequest.body = object;
        int n = deviceRequest.status;
        if (n != -1) {
            String string2 = "enabled";
            boolean bl = n == 1;
            try {
                object.put(string2, bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (!CorePreferenceUtils.getSecuredDataEnabled(this.context) || (object = this.createQuerySecuredData()) == null) return this;
        DeviceRequest deviceRequest2 = this;
        DeviceRequest deviceRequest3 = deviceRequest2;
        DeviceRequest deviceRequest4 = deviceRequest2;
        JSONObject jSONObject = deviceRequest2.body;
        String string3 = "securedKey";
        jSONObject.put(string3, (Object)((KeyExchange)object).getSecuredKey());
        JSONObject jSONObject2 = deviceRequest4.body;
        Object object2 = object;
        object = "securedData";
        jSONObject2.put((String)object, (Object)((KeyExchange)object2).getSecuredData());
        if (deviceRequest3.body.has("platform")) return this;
        JSONObject jSONObject3 = this.body;
        try {
            jSONObject3.put("platform", (Object)this.device.getPlatform());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this;
    }

    public BaseRequest getDeviceRequest() {
        DeviceRequest deviceRequest = this;
        deviceRequest.params = deviceRequest.createQueryString();
        deviceRequest.body = deviceRequest.createDeviceJson();
        return deviceRequest;
    }

    public BaseRequest postDeviceTopics() {
        DeviceRequest deviceRequest = this;
        deviceRequest.params = deviceRequest.createQueryString();
        deviceRequest.body = deviceRequest.createTopicsJson();
        return deviceRequest;
    }

    public BaseRequest getDeviceTopics() {
        DeviceRequest deviceRequest = this;
        deviceRequest.params = deviceRequest.createQueryString();
        return deviceRequest;
    }

    public BaseRequest deleteDeviceTopics() {
        DeviceRequest deviceRequest = this;
        deviceRequest.params = deviceRequest.createQueryString();
        deviceRequest.body = deviceRequest.createTopicsJson();
        return deviceRequest;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void setTopics(String[] stringArray) {
        this.topics = stringArray;
    }

    public void setStatus(int n) {
        this.status = n;
    }
}

