/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.models;

import android.content.Context;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import com.indigitall.android.push.models.PermissionStatus;
import com.indigitall.android.push.models.PermissionType;

public class Permission {
    private static final String TAG = "[IND]Permissions";
    private PermissionType type;
    private PermissionStatus status;

    private Permission(PermissionType permissionType, PermissionStatus permissionStatus) {
        this.type = permissionType;
        this.status = permissionStatus;
    }

    private static boolean checkPushPermission(Context context) {
        return NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
    }

    private static boolean checkLocationPermission(Context context) {
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    private static PermissionStatus requestLocationPermission(Context context) {
        return Permission.checkLocationPermission(context) ? PermissionStatus.granted : PermissionStatus.denied;
    }

    private static PermissionStatus requestPushPermission(Context context) {
        return Permission.checkPushPermission(context) ? PermissionStatus.granted : PermissionStatus.denied;
    }

    public static Permission[] getPermissions(Context object) {
        Permission permission2;
        Permission permission3;
        Permission[] permissionArray = new Permission[PermissionType.values().length];
        Permission permission4 = permission3;
        PermissionType permissionType = PermissionType.push;
        permission3 = new Permission(permissionType, Permission.requestPushPermission(object));
        permissionArray[0] = permission4;
        permission4 = permission2;
        Context context = object;
        object = PermissionType.location;
        permission2 = new Permission((PermissionType)((Object)object), Permission.requestLocationPermission(context));
        permissionArray[1] = permission4;
        return permissionArray;
    }

    public String toString() {
        String string = "";
        if (this.type != null) {
            string = string + this.type.name() + " permission: ";
        }
        if (this.status != null) {
            string = string + this.status.name();
        }
        return string;
    }
}

