/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.indigitall.android.commons.models.ErrorCode;
import com.indigitall.android.commons.utils.Log;
import com.indigitall.android.push.models.Push;
import com.indigitall.android.push.models.PushNotification;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class GeofenceTransitionsReceiver
extends BroadcastReceiver {
    private static String TAG = "GeofenceTransitionsReceiver";
    public static final String ACTION_GEOFENCE = TAG + ".Action.GEOFENCE";

    private static String getGeofenceTransitionDetails(int n, List<Geofence> arrayList) {
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<String>();
        Object object = arrayList3.iterator();
        while (object.hasNext()) {
            arrayList.add(((Geofence)object.next()).getRequestId());
        }
        object = null;
        if (n == 1) {
            object = "Est\u00e1s cerca de";
        } else if (n == 2) {
            object = "Has salido de";
        } else if (n == 4) {
            object = "Llevas 10 minutos dentro de";
        }
        return (String)object + TextUtils.join((CharSequence)" y de", arrayList);
    }

    private static String geofenceErrorMessages(int n) {
        switch (n) {
            default: {
                return "Unknown error";
            }
            case 1002: {
                return "Too many pending intents";
            }
            case 1001: {
                return "Too many Geofences";
            }
            case 1000: 
        }
        return "Geofences not available";
    }

    private void sendNotification(String string, Context context) {
        Push push;
        int n = (int)(Math.random() * 100.0) + 1;
        Push push2 = push;
        push = new Push(new JSONObject("{\n    \"appKey\": \"1234\",\n    \"id\": " + n + ",\n    \"title\": \"Indigitall te vigila\",\n    \"body\": \"" + string + ".\",\n    \"action\": {\n        \"destroy\": \"true\",\n        \"type\": \"url\",\n        \"url\": \"https://indigitall.com\"\n    }\n}"));
        try {
            new PushNotification(push2).showNotification(context);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void onReceive(Context context, Intent object) {
        if (ACTION_GEOFENCE.equals(object.getAction())) {
            Log log;
            Intent intent = object;
            object = log;
            log = new Log(TAG, context);
            GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
            if (geofencingEvent.hasError()) {
                ((Log)object).e(ErrorCode.GENERAL_ERROR.getErrorId() + ": Geofence Onreceive" + GeofenceTransitionsReceiver.geofenceErrorMessages(geofencingEvent.getErrorCode())).writeLog();
                return;
            }
            int n = geofencingEvent.getGeofenceTransition();
            if (n != 1 && n != 2 && n != 4) {
                ((Log)object).w("Geofence Error: " + String.valueOf(n)).writeLog();
            } else {
                GeofenceTransitionsReceiver geofenceTransitionsReceiver = object2;
                Object object2 = GeofenceTransitionsReceiver.getGeofenceTransitionDetails(n, geofencingEvent.getTriggeringGeofences());
                geofenceTransitionsReceiver.sendNotification((String)object2, context);
                ((Log)object).d("Geofence SendNotification " + (String)object2).writeLog();
            }
        }
    }
}

