/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.services;

import android.app.IntentService;
import android.app.Notification;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.indigitall.android.commons.utils.Log;
import java.util.ArrayList;
import java.util.List;

public class GeofenceTransitionsIntentService
extends IntentService {
    private static final String TAG = "GeofenceTransitionsIntentService";

    public GeofenceTransitionsIntentService() {
        super(TAG);
    }

    private static String getGeofenceTransitionDetails(int n, List<Geofence> arrayList) {
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<String>();
        Object object = arrayList3.iterator();
        while (object.hasNext()) {
            arrayList.add(((Geofence)object.next()).getRequestId());
        }
        object = null;
        if (n == 1) {
            object = "Est\u00e1s cerca de";
        } else if (n == 2) {
            object = "Has salido de";
        } else if (n == 4) {
            object = "Llevas 10 minutos dentro de";
        }
        return (String)object + TextUtils.join((CharSequence)" y de", arrayList);
    }

    private static String geofenceErrorMessages(int n) {
        switch (n) {
            default: {
                return "Unknown error";
            }
            case 1002: {
                return "Too many pending intents";
            }
            case 1001: {
                return "Too many Geofences";
            }
            case 1000: 
        }
        return "Geofences not available";
    }

    private void sendNotification(String string) {
    }

    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 26) {
            Notification notification;
            GeofenceTransitionsIntentService geofenceTransitionsIntentService = geofenceTransitionsIntentService2;
            GeofenceTransitionsIntentService geofenceTransitionsIntentService2 = notification;
            notification = new Notification();
            geofenceTransitionsIntentService.startForeground(2, (Notification)geofenceTransitionsIntentService2);
        }
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        new Log(TAG, object.getApplicationContext());
        intent = GeofencingEvent.fromIntent((Intent)intent);
        if (intent.hasError()) {
            android.util.Log.w((String)"GeofenceServ hasError", (String)GeofenceTransitionsIntentService.geofenceErrorMessages(intent.getErrorCode()));
            return;
        }
        int n = intent.getGeofenceTransition();
        if (n != 1 && n != 2 && n != 4) {
            android.util.Log.w((String)"Error transicion", (String)String.valueOf(n));
        } else {
            GeofenceTransitionsIntentService geofenceTransitionsIntentService = object;
            Object object = GeofenceTransitionsIntentService.getGeofenceTransitionDetails(n, intent.getTriggeringGeofences());
            geofenceTransitionsIntentService.sendNotification((String)object);
            android.util.Log.w((String)"SendNotification ", (String)object);
        }
    }
}

