/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.utils;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class GifDecoder {
    private static final String TAG = "GifDecoder";
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected int lctSize;
    protected ByteBuffer rawData;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] mainPixels;
    protected int[] mainScratch;
    protected int[] copyScratch;
    protected ArrayList<GifFrame> frames;
    protected GifFrame currentFrame;
    protected Bitmap previousImage;
    protected Bitmap currentImage;
    protected Bitmap renderImage;
    protected int framePointer;
    protected int frameCount;

    public void advance() {
        this.framePointer = (this.framePointer + 1) % this.frameCount;
    }

    public int getDelay(int n) {
        int n2 = -1;
        if (n >= 0 && n < this.frameCount) {
            n2 = this.frames.get((int)n).delay;
        }
        return n2;
    }

    public int getNextDelay() {
        int n;
        if (this.frameCount > 0 && (n = this.framePointer) >= 0) {
            return this.getDelay(n);
        }
        return -1;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public Bitmap getNextFrame() {
        int n;
        if (this.frameCount > 0 && (n = this.framePointer) >= 0 && this.currentImage != null) {
            int n2;
            GifFrame gifFrame = this.frames.get(n);
            int[] nArray = gifFrame.lct;
            if (gifFrame.lct == null) {
                this.act = this.gct;
            } else {
                this.act = nArray;
                if (this.bgIndex == gifFrame.transIndex) {
                    this.bgColor = 0;
                }
            }
            int n3 = 0;
            if (gifFrame.transparency) {
                n3 = gifFrame.transIndex;
                n2 = this.act[n3];
                this.act[n3] = 0;
            } else {
                n2 = n3;
            }
            if (this.act == null) {
                Log.w((String)TAG, (String)"No Valid Color Table");
                this.status = 1;
                return null;
            }
            GifDecoder gifDecoder = this;
            gifDecoder.setPixels(gifDecoder.framePointer);
            if (gifFrame.transparency) {
                this.act[gifFrame.transIndex] = n2;
            }
            return this.currentImage;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public int read(InputStream var1_1, int var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int read(byte[] byArray) {
        this.init();
        if (byArray != null) {
            GifDecoder gifDecoder = this;
            this.rawData = ByteBuffer.wrap(byArray);
            this.rawData.rewind();
            gifDecoder.rawData.order(ByteOrder.LITTLE_ENDIAN);
            gifDecoder.readHeader();
            if (!gifDecoder.err()) {
                GifDecoder gifDecoder2 = this;
                gifDecoder2.readContents();
                if (gifDecoder2.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        return this.status;
    }

    protected void setPixels(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object = this.frames.get(n);
        GifFrame gifFrame = null;
        int n6 = n - 1;
        if (n6 >= 0) {
            gifFrame = this.frames.get(n6);
        }
        int[] nArray = this.mainScratch;
        if (gifFrame != null && (n5 = gifFrame.dispose) > 0) {
            Bitmap bitmap;
            if (n5 == 1 && (bitmap = this.currentImage) != null) {
                GifDecoder gifDecoder = this;
                n5 = gifDecoder.width;
                n4 = gifDecoder.height;
                bitmap.getPixels(nArray, 0, n5, 0, 0, n5, n4);
            }
            if (gifFrame.dispose == 2) {
                n5 = 0;
                if (!((GifFrame)object).transparency) {
                    n5 = this.bgColor;
                }
                for (n4 = 0; n4 < gifFrame.ih; ++n4) {
                    n2 = n3 + gifFrame.iw;
                    for (n3 = (gifFrame.iy + n4) * this.width + gifFrame.ix; n3 < n2; ++n3) {
                        nArray[n3] = n5;
                    }
                }
            }
            if (gifFrame.dispose == 3 && (gifFrame = this.previousImage) != null) {
                GifDecoder gifDecoder = this;
                int n7 = gifDecoder.width;
                n5 = gifDecoder.height;
                gifFrame.getPixels(nArray, 0, n7, 0, 0, n7, n5);
            }
        }
        GifDecoder gifDecoder = this;
        gifDecoder.decodeBitmapData((GifFrame)object, gifDecoder.mainPixels);
        int n8 = 1;
        n5 = 8;
        n4 = 0;
        for (n3 = 0; n3 < (n2 = ((GifFrame)object).ih); ++n3) {
            if (((GifFrame)object).interlace) {
                if (n4 >= n2) {
                    if (++n8 != 2) {
                        if (n8 != 3) {
                            if (n8 == 4) {
                                n4 = 1;
                                n5 = 2;
                            }
                        } else {
                            n4 = 2;
                            n5 = 4;
                        }
                    } else {
                        n4 = 4;
                    }
                }
                n2 = n4 + n5;
            } else {
                n2 = n4;
                n4 = n3;
            }
            if ((n4 += ((GifFrame)object).iy) < this.height) {
                int n9 = n4;
                n4 = this.width;
                int n10 = n9 * n4;
                n4 = n10 + ((GifFrame)object).ix;
                int n11 = n10 + n4;
                int n12 = ((GifFrame)object).iw;
                int n13 = n4 + n12;
                if (n11 >= n13) {
                    n11 = n13;
                }
                n12 = n3 * n12;
                while (n4 < n11) {
                    GifDecoder gifDecoder2 = this;
                    n13 = gifDecoder2.mainPixels[n12++] & 0xFF;
                    if ((n13 = gifDecoder2.act[n13]) != 0) {
                        nArray[n4] = n13;
                    }
                    ++n4;
                }
            }
            n4 = n2;
        }
        GifDecoder gifDecoder3 = this;
        GifDecoder gifDecoder4 = this;
        object = gifDecoder4.copyScratch;
        n8 = gifDecoder4.width;
        n5 = gifDecoder4.height;
        gifDecoder3.currentImage.getPixels((int[])object, 0, n8, 0, 0, n8, n5);
        GifDecoder gifDecoder5 = this;
        object = gifDecoder5.copyScratch;
        n8 = gifDecoder5.width;
        n5 = gifDecoder5.height;
        gifDecoder3.previousImage.setPixels((int[])object, 0, n8, 0, 0, n8, n5);
        GifDecoder gifDecoder6 = this;
        int n14 = gifDecoder6.width;
        int n15 = gifDecoder6.height;
        gifDecoder3.currentImage.setPixels(nArray, 0, n14, 0, 0, n14, n15);
    }

    protected void decodeBitmapData(GifFrame gifFrame, byte[] byArray) {
        int n;
        System.currentTimeMillis();
        if (gifFrame != null) {
            this.rawData.position(gifFrame.bufferFrameStart);
        }
        int n2 = -1;
        int n3 = gifFrame == null ? this.width * this.height : gifFrame.iw * gifFrame.ih;
        if (byArray == null || byArray.length < n3) {
            byArray = new byte[n3];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n4 = this.read();
        int n5 = 1 << n4;
        int n6 = n5 + 1;
        int n7 = n5 + 2;
        int n8 = (1 << ++n4) - 1;
        int n9 = 0;
        while (n9 < n5) {
            GifDecoder gifDecoder = this;
            gifDecoder.prefix[n9] = 0;
            int n10 = n9++;
            gifDecoder.suffix[n10] = (byte)n10;
        }
        n9 = 0;
        int n11 = n = 0;
        int n12 = n9;
        int n13 = n9;
        int n14 = n9;
        int n15 = n9;
        int n16 = n7;
        int n17 = n8;
        int n18 = n9;
        int n19 = n4;
        n = n9;
        int n20 = n2;
        int n21 = n11;
        while (n21 < n3) {
            int n22;
            if (n9 == 0) {
                byte by;
                if (n < n19) {
                    if (n15 == 0) {
                        n15 = this.readBlock();
                        if (n15 <= 0) break;
                        n14 = 0;
                    }
                    n18 += (this.block[n14] & 0xFF) << n;
                    n += 8;
                    ++n14;
                    --n15;
                    continue;
                }
                n22 = n18 & n17;
                n18 >>= n19;
                n -= n19;
                if (n22 > n16 || n22 == n6) break;
                if (n22 == n5) {
                    n16 = n7;
                    n17 = n8;
                    n19 = n4;
                    n20 = n2;
                    continue;
                }
                if (n20 == n2) {
                    this.pixelStack[n9++] = this.suffix[n22];
                    n13 = n22;
                    n20 = n22;
                    continue;
                }
                if (n22 == n16) {
                    this.pixelStack[n9++] = (byte)n13;
                    n13 = n20;
                } else {
                    n13 = n22;
                }
                while (n13 > n5) {
                    GifDecoder gifDecoder = this;
                    gifDecoder.pixelStack[n9++] = this.suffix[n13];
                    n13 = gifDecoder.prefix[n13];
                }
                byte[] byArray2 = this.suffix;
                n13 = this.suffix[n13] & 0xFF;
                if (n16 >= 4096) break;
                GifDecoder gifDecoder = this;
                gifDecoder.pixelStack[n9++] = by = (byte)n13;
                gifDecoder.prefix[n16] = (short)n20;
                byArray2[n16] = by;
                if ((++n16 & n17) == 0 && n16 < 4096) {
                    ++n19;
                    n17 += n16;
                }
            } else {
                n22 = n20;
            }
            byArray[n12++] = this.pixelStack[--n9];
            ++n21;
            n20 = n22;
        }
        while (n12 < n3) {
            byArray[n12] = 0;
            ++n12;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        ArrayList arrayList;
        GifDecoder gifDecoder = arrayList2;
        gifDecoder.status = 0;
        gifDecoder.frameCount = 0;
        gifDecoder.framePointer = -1;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        gifDecoder.frames = arrayList2;
        gifDecoder.gct = null;
    }

    protected int read() {
        int n = 0;
        try {
            n = this.rawData.get() & 0xFF;
        }
        catch (Exception exception) {
            this.status = 1;
        }
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int readBlock() {
        this.blockSize = this.read();
        int n = 0;
        if (this.blockSize <= 0) return n;
        while (true) {
            int n2;
            try {
                n2 = this.blockSize;
                if (n >= n2) return n;
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Error Reading Block", (Throwable)exception);
                this.status = 1;
                return n;
            }
            {
                this.rawData.get(this.block, n, n2 -= n);
            }
            n += n2;
        }
    }

    protected int[] readColorTable(int n) {
        int[] nArray = null;
        byte[] byArray = new byte[n * 3];
        this.rawData.get(byArray);
        nArray = new int[256];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = n3++;
            byte by = byArray[n4];
            int n5 = n3++;
            int n6 = byArray[n5] & 0xFF;
            int n7 = n3++;
            int n8 = byArray[n7] & 0xFF;
            try {
                nArray[n2++] = (by & 0xFF) << 16 | 0xFF000000 | n6 << 8 | n8;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                Log.w((String)TAG, (String)"Format Error Reading Color Table", (Throwable)bufferUnderflowException);
                this.status = 1;
                break;
            }
        }
        return nArray;
    }

    protected void readContents() {
        boolean bl = false;
        while (!bl && !this.err()) {
            int n = this.read();
            if (n != 33) {
                if (n != 44) {
                    if (n != 59) {
                        this.status = 1;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                this.readBitmap();
                continue;
            }
            n = this.read();
            if (n != 1) {
                if (n != 249) {
                    if (n != 254 && n == 255) {
                        this.readBlock();
                        String string = "";
                        for (int i = 0; i < 11; ++i) {
                            string = string + (char)this.block[i];
                        }
                        if (string.equals("NETSCAPE2.0")) {
                            this.readNetscapeExt();
                            continue;
                        }
                    }
                } else {
                    GifFrame gifFrame;
                    GifFrame gifFrame2 = gifFrame;
                    gifFrame = new GifFrame();
                    this.currentFrame = gifFrame2;
                    this.readGraphicControlExt();
                    continue;
                }
            }
            this.skip();
        }
    }

    protected void readHeader() {
        Object object = "";
        for (int i = 0; i < 6; ++i) {
            object = (String)object + (char)this.read();
        }
        if (!((String)object).startsWith("GIF")) {
            this.status = 1;
            return;
        }
        GifDecoder gifDecoder = this;
        gifDecoder.readLSD();
        if (gifDecoder.gctFlag && !this.err()) {
            GifDecoder gifDecoder2 = this;
            int[] nArray = gifDecoder2.readColorTable(gifDecoder2.gctSize);
            object = nArray;
            this.gct = (int[])object;
            gifDecoder2.bgColor = nArray[this.bgIndex];
        }
    }

    protected void readGraphicControlExt() {
        GifDecoder gifDecoder = this;
        gifDecoder.read();
        int n = gifDecoder.read();
        GifFrame gifFrame = this.currentFrame;
        gifFrame.dispose = (n & 0x1C) >> 2;
        if (gifFrame.dispose == 0) {
            gifFrame.dispose = 1;
        }
        n = (n & 1) != 0 ? 1 : 0;
        gifFrame.transparency = n;
        gifFrame.delay = this.readShort() * 10;
        this.currentFrame.transIndex = this.read();
        this.read();
    }

    protected void readBitmap() {
        int n;
        this.currentFrame.ix = this.readShort();
        this.currentFrame.iy = this.readShort();
        this.currentFrame.iw = this.readShort();
        this.currentFrame.ih = this.readShort();
        int n2 = this.read();
        boolean bl = (n2 & 0x80) != 0;
        this.lctFlag = bl;
        double d = (n2 & 7) + 1;
        this.lctSize = n = (int)Math.pow(2.0, d);
        GifFrame gifFrame = this.currentFrame;
        boolean bl2 = (n2 & 0x40) != 0;
        gifFrame.interlace = bl2;
        gifFrame.lct = (int[])(this.lctFlag ? this.readColorTable(n) : null);
        GifDecoder gifDecoder = this;
        gifDecoder.currentFrame.bufferFrameStart = this.rawData.position();
        gifDecoder.decodeBitmapData(null, gifDecoder.mainPixels);
        gifDecoder.skip();
        if (gifDecoder.err()) {
            return;
        }
        GifDecoder gifDecoder2 = this;
        ++gifDecoder2.frameCount;
        gifDecoder2.frames.add(this.currentFrame);
    }

    protected void readLSD() {
        GifDecoder gifDecoder = this;
        gifDecoder.width = gifDecoder.readShort();
        gifDecoder.height = gifDecoder.readShort();
        int n = gifDecoder.read();
        int n2 = (n & 0x80) != 0 ? 1 : 0;
        GifDecoder gifDecoder2 = this;
        this.gctFlag = n2;
        gifDecoder2.gctSize = 2 << (n & 7);
        gifDecoder2.bgIndex = gifDecoder2.read();
        gifDecoder2.pixelAspect = gifDecoder2.read();
        int n3 = gifDecoder2.width;
        n = n3;
        GifDecoder gifDecoder3 = this;
        int n4 = n;
        n = this.height;
        n2 = n4 * n;
        gifDecoder3.mainPixels = new byte[n2];
        gifDecoder3.mainScratch = new int[n2];
        gifDecoder3.copyScratch = new int[n2];
        gifDecoder2.previousImage = Bitmap.createBitmap((int)n3, (int)n, (Bitmap.Config)Bitmap.Config.RGB_565);
        gifDecoder2.currentImage = Bitmap.createBitmap((int)gifDecoder2.width, (int)this.height, (Bitmap.Config)Bitmap.Config.RGB_565);
    }

    protected void readNetscapeExt() {
        do {
            GifDecoder gifDecoder = this;
            gifDecoder.readBlock();
            byte[] byArray = gifDecoder.block;
            if (gifDecoder.block[0] != 1) continue;
            int n = byArray[1] & 0xFF;
            this.loopCount = (byArray[2] & 0xFF) << 8 | n;
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.rawData.getShort();
    }

    protected void skip() {
        GifDecoder gifDecoder;
        do {
            gifDecoder = this;
            gifDecoder.readBlock();
        } while (gifDecoder.blockSize > 0 && !this.err());
    }

    private static class GifFrame {
        public int ix;
        public int iy;
        public int iw;
        public int ih;
        public boolean interlace;
        public boolean transparency;
        public int dispose;
        public int transIndex;
        public int delay;
        public int bufferFrameStart;
        public int[] lct;

        private GifFrame() {
        }
    }
}

