/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.utils;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.location.Location;
import android.media.RingtoneManager;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.indigitall.android.R;
import java.util.Calendar;

public class LocationUtils {
    private static final String DEFAULT_CHANNEL_ID = "location";

    public static void showNotification(Context context, Location location) {
        NotificationManager notificationManager;
        if (location != null && (notificationManager = (NotificationManager)context.getSystemService("notification")) != null) {
            NotificationCompat.Builder builder;
            if (Build.VERSION.SDK_INT < 26) {
                NotificationCompat.Builder builder2;
                NotificationCompat.Builder builder3 = builder2;
                new NotificationCompat.Builder(context, "").setSound(RingtoneManager.getDefaultUri((int)2));
                builder3.setVibrate(new long[0]);
                builder3.setLights(-16711936, 300, 100);
                builder = builder3;
            } else {
                NotificationCompat.Builder builder4;
                NotificationChannel notificationChannel = LocationUtils.createChannel();
                notificationManager.createNotificationChannel(notificationChannel);
                builder = builder4;
                new NotificationCompat.Builder(context, notificationChannel.getId()).setBadgeIconType(1);
            }
            NotificationCompat.Builder builder5 = builder;
            builder5.setColor(ContextCompat.getColor((Context)context, (int)R.color.colorPrimary));
            builder5.setSmallIcon(R.mipmap.ic_launcher_foreground);
            builder5.setContentTitle((CharSequence)("Date: " + Calendar.getInstance().getTime()));
            builder5.setContentText((CharSequence)("Latitude: " + location.getLatitude() + " Longitude: " + location.getLongitude()));
            builder5.setAutoCancel(false);
            builder5.setOngoing(true);
            notificationManager.notify(0, builder5.build());
        }
    }

    @TargetApi(value=26)
    private static NotificationChannel createChannel() {
        NotificationChannel notificationChannel = new NotificationChannel(DEFAULT_CHANNEL_ID, (CharSequence)DEFAULT_CHANNEL_ID, 4);
        notificationChannel.setDescription(DEFAULT_CHANNEL_ID);
        notificationChannel.enableLights(true);
        notificationChannel.setLightColor(-1);
        notificationChannel.enableVibration(false);
        notificationChannel.setShowBadge(false);
        notificationChannel.setVibrationPattern(new long[0]);
        return notificationChannel;
    }
}

