/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.utils;

import android.content.Context;
import androidx.core.app.NotificationManagerCompat;
import com.google.firebase.messaging.RemoteMessage;
import com.indigitall.android.commons.models.CorePush;
import com.indigitall.android.commons.models.ErrorCode;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.ErrorUtils;
import com.indigitall.android.commons.utils.Log;
import com.indigitall.android.push.api.Client;
import com.indigitall.android.push.api.requests.EventRequest;
import com.indigitall.android.push.models.Push;
import com.indigitall.android.push.models.PushNotification;
import com.indigitall.android.push.utils.ServiceUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/indigitall/android/push/utils/PushServiceUtils;", "", "()V", "TAG", "", "isPushIndigitall", "", "context", "Landroid/content/Context;", "remoteMessage", "", "isPushSecure", "Lcom/google/firebase/messaging/RemoteMessage;", "push", "Lcom/indigitall/android/push/models/Push;", "sendPushEventReceived", "", "push_release"})
public final class PushServiceUtils {
    @NotNull
    public static final PushServiceUtils INSTANCE = new PushServiceUtils();
    @NotNull
    private static final String TAG = "[IND]PushServiceUtils";

    private PushServiceUtils() {
    }

    public final boolean isPushIndigitall(@NotNull Context context, @NotNull Map<String, String> object) {
        block6: {
            Push push;
            JSONObject jSONObject;
            Log log;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(object, (String)"remoteMessage");
            Log log2 = log;
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject(object);
            try {
                new Log(TAG, context).i("Data: " + jSONObject2.toString(4)).writeLog();
            }
            catch (JSONException jSONException) {
                log2.e(ErrorUtils.INSTANCE.showError(ErrorCode.GENERAL_ERROR, "isPushIndigitall: " + jSONException.getLocalizedMessage())).writeLog();
                return false;
            }
            object = push;
            push = new Push(context, jSONObject2);
            log2.d("appKey: " + ((CorePush)object).getAppKey()).writeLog();
            if (((CorePush)object).getAppKey() == null) break block6;
            if (!Intrinsics.areEqual((Object)((CorePush)object).getAppKey(), (Object)CorePreferenceUtils.getAppKey(context))) break block6;
            new PushNotification((Push)object).showNotification(context);
            return true;
        }
        return false;
    }

    public final void sendPushEventReceived(@NotNull Context context, @NotNull Push push) {
        Push push2 = push;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)push2, (String)"push");
        ServiceUtils.sendPushToBroadcast(context, push2);
        if (push.getSendEventAck() && NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
            EventRequest eventRequest;
            ServiceUtils.sendPushAckToBroadcast(context, push);
            EventRequest eventRequest2 = eventRequest;
            eventRequest = new EventRequest(context);
            Integer n = push.getApplicationId();
            if (n != null) {
                eventRequest2.setApplicationId(n);
            }
            if (CorePreferenceUtils.getSecuredDataEnabled(context)) {
                eventRequest2.setPushSecure(true);
            }
            Object object = eventRequest2;
            ((EventRequest)object).setPushId(String.valueOf(push.getPushId()));
            Client.postPushReceivedEvent((EventRequest)object);
        }
    }

    public final boolean isPushSecure(@NotNull Context context, @NotNull RemoteMessage remoteMessage) {
        Push push;
        JSONObject jSONObject;
        PushServiceUtils pushServiceUtils = object;
        RemoteMessage remoteMessage2 = remoteMessage;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)remoteMessage2, (String)"remoteMessage");
        Object object = remoteMessage2.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"remoteMessage.data");
        remoteMessage = jSONObject;
        jSONObject = new JSONObject((Map)object);
        object = push;
        push = new Push(context, (JSONObject)remoteMessage);
        return pushServiceUtils.isPushSecure(context, (Push)object);
    }

    public final boolean isPushSecure(@NotNull Context context, @NotNull Push push) {
        Push push2 = push;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)push2, (String)"push");
        return push2.getSendEventAck() && CorePreferenceUtils.getSecuredDataEnabled(context);
    }
}

