/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.utils;

import android.content.Context;
import com.indigitall.android.commons.utils.CoreValidations;
import com.indigitall.android.commons.utils.Log;
import com.indigitall.android.push.utils.PushPreferenceUtils;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0015\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/indigitall/android/push/utils/PushValidations;", "", "()V", "isDeviceIdFormat", "", "deviceId", "", "isPutRequestExceed", "timestamp", "", "(Ljava/lang/Long;)Z", "isValidFormatRequest", "context", "Landroid/content/Context;", "push_release"})
public final class PushValidations {
    @NotNull
    public static final PushValidations INSTANCE = new PushValidations();

    private PushValidations() {
    }

    @JvmStatic
    public static final boolean isDeviceIdFormat(@Nullable String string) {
        return !(string == null || StringsKt.isBlank((CharSequence)string)) && !Intrinsics.areEqual((Object)string, (Object)"null") && string.length() >= 8;
    }

    public final boolean isValidFormatRequest(@NotNull Context object) {
        Log log;
        Context context = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Log log2 = log;
        log = new Log("[IND]Validations");
        object = PushPreferenceUtils.Companion.getDeviceId((Context)object);
        boolean bl = true;
        if (!CoreValidations.isAppKeyFormat(context)) {
            bl = false;
            log2.w("appKey is null or empty").writeLog();
        }
        if (!PushValidations.isDeviceIdFormat((String)object)) {
            bl = false;
            log2.w("deviceId is null or empty").writeLog();
        }
        return bl;
    }

    public final boolean isPutRequestExceed(@Nullable Long l) {
        return l != null && l <= Calendar.getInstance().getTimeInMillis();
    }
}

