/*
 * Decompiled with CFR 0.152.
 */
package com.indigitall.android.push.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.WifiManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import com.indigitall.android.commons.CoreConfiguration;
import com.indigitall.android.commons.models.ErrorModel;
import com.indigitall.android.commons.utils.CorePreferenceUtils;
import com.indigitall.android.commons.utils.IntentUtils;
import com.indigitall.android.commons.utils.Log;
import com.indigitall.android.commons.utils.Utils;
import com.indigitall.android.push.Configuration;
import com.indigitall.android.push.api.Client;
import com.indigitall.android.push.api.requests.DeviceRequest;
import com.indigitall.android.push.callbacks.DeviceCallback;
import com.indigitall.android.push.callbacks.PushTokenCallback;
import com.indigitall.android.push.models.Device;
import com.indigitall.android.push.models.Push;
import com.indigitall.android.push.models.PushErrorCode;
import com.indigitall.android.push.receivers.LocationReceiver;
import com.indigitall.android.push.receivers.WifiWakeLockReceiver;
import com.indigitall.android.push.services.NightService;
import com.indigitall.android.push.services.StatisticService;
import com.indigitall.android.push.utils.PushErrorUtils;
import com.indigitall.android.push.utils.PushPreferenceUtils;
import com.indigitall.android.push.utils.PushValidations;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;

public class ServiceUtils {
    private static final String TAG = "[IND]service";
    private static ArrayList<Geofence> mGeofenceList = new ArrayList();
    private static Calendar cal_nightService = null;

    public static void registerServices(Context context, Configuration object, Configuration configuration) {
        PushPreferenceUtils.Companion companion;
        ArrayList arrayList;
        Intent intent;
        new Log(TAG, context);
        Object object2 = intent;
        intent = new Intent(context, NightService.class);
        int n = IntentUtils.getPendingIntentFlags(0x20000000);
        PendingIntent.getService((Context)context, (int)50011, (Intent)object2, (int)n);
        object2 = arrayList;
        arrayList = new ArrayList();
        if (object != null && ((Configuration)object).getAutoRequestPushPermission().booleanValue() && ((companion = PushPreferenceUtils.Companion).getPushEnabled(context) == -1 || companion.getPushEnabled(context) == 0 && NotificationManagerCompat.from((Context)context).areNotificationsEnabled())) {
            if (Build.VERSION.SDK_INT >= 33 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.POST_NOTIFICATIONS") != 0) {
                ((ArrayList)object2).add("android.permission.POST_NOTIFICATIONS");
            }
        } else {
            PushPreferenceUtils.Companion companion2 = PushPreferenceUtils.Companion;
            if (companion2.getPushEnabled(context) == 1 && !NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
                companion2.setPushEnabled(context, 0);
            }
        }
        if (configuration.isLocationEnabled()) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
                ServiceUtils.registerLocationService(context);
            } else if (context instanceof Activity && object != null) {
                if (((CoreConfiguration)object).getAutoRequestPermissionLocation()) {
                    ((ArrayList)object2).add("android.permission.ACCESS_FINE_LOCATION");
                }
                if (((CoreConfiguration)object).getAutoRequestPermissionTelephony()) {
                    ((ArrayList)object2).add("android.permission.CALL_PHONE");
                }
            }
        }
        if (((ArrayList)object2).size() > 0) {
            Object object3 = object2;
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])((ArrayList)object3).toArray(new String[((ArrayList)object3).size()]), (int)50001);
        }
        if (configuration.isNetworkEventsEnabled()) {
            object = PushPreferenceUtils.Companion;
            if (((PushPreferenceUtils.Companion)object).getNetworkUpdateMinutes(context) > 0 && (WifiManager)context.getApplicationContext().getSystemService("wifi") != null && ((PushPreferenceUtils.Companion)object).getWifiFilterEnabled(context) && ((PushPreferenceUtils.Companion)object).getNetworkEventsEnabled(context)) {
                ServiceUtils.registerWifiAlarmService(context);
            }
        } else {
            PushPreferenceUtils.Companion.setNetworkEventsEnabled(context, false);
        }
    }

    public static void checkPushPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 33) {
            ServiceUtils.checkSelfPermission(context, "android.permission.POST_NOTIFICATIONS", 50001);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void checkSelfPermission(Context var0, String var1_1, int var2_2) {
        block6: {
            var3_3 = v0;
            v0 = new Log("[IND]service", (Context)var0);
            if (ContextCompat.checkSelfPermission((Context)var0, (String)var1_1) == 0) ** GOTO lbl16
            v1 = var0;
            var0 = v2;
            var0();
            v2.add(var1_1);
            v3 = var0;
            ActivityCompat.requestPermissions((Activity)((Activity)v1), (String[])v3.toArray(new String[v3.size()]), (int)var2_2);
            break block6;
lbl16:
            // 1 sources

            v4 = var3_3;
            try {
                v4.d(var1_1 + " is granted").writeLog();
            }
            catch (Exception v5) {
                var3_3.e(v5.getLocalizedMessage()).writeLog();
            }
        }
    }

    private static void registerWifiAlarmService(Context context) {
        Intent intent;
        Log log;
        Log log2 = log;
        log = new Log(TAG, context);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent intent2 = intent;
        new Intent(context, WifiWakeLockReceiver.class).setAction(WifiWakeLockReceiver.ACTION_NETWORK_ALARM);
        int n = IntentUtils.getPendingIntentFlags(0x8000000);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)n);
        log2.d("Service Utils->registerWifiAlarmService").writeLog();
        try {
            alarmManager.set(0, System.currentTimeMillis(), pendingIntent);
        }
        catch (NullPointerException nullPointerException) {
            log2.e(nullPointerException.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"MissingPermission"})
    public static void registerLocationService(Context context) {
        long l;
        long l2;
        Log log;
        block11: {
            Intent intent;
            block13: {
                void var0_4;
                block10: {
                    Log log2;
                    Context context2 = context;
                    log = log2;
                    log2 = new Log(TAG, context);
                    l2 = 60000L;
                    l = (long)CorePreferenceUtils.getLocationUpdateMinutes(context2) * l2;
                    if (ServiceUtils.isGoogleServicesEnabled(context2) || !CorePreferenceUtils.getHarmonyEnabled(context)) break block13;
                    Class<? extends Object> clazz = Utils.INSTANCE.isImplementedClass("com.indigitall.android.hms.utils.HMSServiceUtils");
                    if (clazz == null) break block10;
                    Class[] classArray = new Class[2];
                    classArray[0] = Context.class;
                    classArray[1] = Boolean.TYPE;
                    Method method = clazz.getDeclaredMethod("registerLocationHarmonyService", classArray);
                    Class<? extends Object> clazz2 = clazz;
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = objectArray;
                    objectArray[0] = context;
                    objectArray3[1] = Boolean.FALSE;
                    method.invoke(clazz2, objectArray2);
                    break block11;
                }
                try {
                    log.e("HMS is not implemented correctly: hmsServiceUtils is not found").writeLog();
                    break block11;
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                var0_4.printStackTrace();
                break block11;
            }
            FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
            LocationRequest locationRequest = ServiceUtils.getLocationRequest(l);
            Intent intent2 = intent;
            new Intent(context, LocationReceiver.class).setAction("LocationReceiver.Action.LOCATION_UPDATE");
            int n = 0x8000000;
            if (Build.VERSION.SDK_INT >= 31) {
                n = 0xA000000;
            }
            fusedLocationProviderClient.requestLocationUpdates(locationRequest, PendingIntent.getBroadcast((Context)context, (int)50012, (Intent)intent2, (int)n));
        }
        log.d("LocationService registered to " + l / l2 + " minutes").writeLog();
    }

    private static LocationRequest getLocationRequest(long l) {
        LocationRequest.Builder builder;
        LocationRequest.Builder builder2 = builder;
        builder2(l);
        builder2.setMinUpdateDistanceMeters((float)l);
        builder.setMaxUpdateDelayMillis(l);
        builder.setPriority(100);
        return builder.build();
    }

    public static void unregisterLocationService(Context context) {
        Intent intent;
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
        Context context2 = context;
        context = intent;
        intent = new Intent("LocationService.Action.LOCATION_UPDATE");
        int n = IntentUtils.getPendingIntentFlags(0x8000000);
        fusedLocationProviderClient.removeLocationUpdates(PendingIntent.getService((Context)context2, (int)50012, (Intent)context, (int)n));
    }

    public static void registerNightService(Context context, Configuration object) {
        PendingIntent pendingIntent;
        Intent intent;
        Log log;
        Configuration configuration = object;
        object = log;
        log = new Log(TAG, context);
        int n = configuration.getServiceSyncTime();
        Object object2 = configuration.getMaintenanceStart();
        Object object3 = configuration.getMaintenanceEnd();
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Object object4 = intent;
        intent = new Intent(context, NightService.class);
        int n2 = Build.VERSION.SDK_INT;
        if (n2 < 26) {
            int n3 = IntentUtils.getPendingIntentFlags(0x8000000);
            pendingIntent = PendingIntent.getService((Context)context, (int)50011, (Intent)object4, (int)n3);
        } else {
            int n4 = IntentUtils.getPendingIntentFlags(0x8000000);
            pendingIntent = PendingIntent.getForegroundService((Context)context, (int)50011, (Intent)object4, (int)n4);
        }
        object2 = ((String)object2).split(":");
        object3 = ((String)object3).split(":");
        Object object5 = object4 = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        ((Calendar)object5).setTimeInMillis(System.currentTimeMillis());
        ((Calendar)object5).add(5, n);
        ((Calendar)object4).set(11, Integer.valueOf(object2[0]));
        ((Calendar)object4).set(12, Integer.valueOf(object2[1]));
        Object object6 = object2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        ((Calendar)object6).setTimeInMillis(System.currentTimeMillis());
        ((Calendar)object6).add(5, n);
        ((Calendar)object2).set(11, Integer.valueOf(object3[0]));
        ((Calendar)object2).set(12, Integer.valueOf(object3[1]));
        long l = ((Calendar)object4).getTimeInMillis();
        long l2 = ((Calendar)object2).getTimeInMillis();
        l = new Random(System.currentTimeMillis()).nextLong() % (l2 - l) + l + 1L;
        object3 = Calendar.getInstance();
        ((Calendar)object3).setTimeInMillis(l);
        cal_nightService = object3;
        if (alarmManager != null) {
            if (n2 < 19) {
                l = ((Calendar)object3).getTimeInMillis();
                alarmManager.set(0, l, pendingIntent);
            } else {
                l = ((Calendar)object3).getTimeInMillis();
                alarmManager.setExact(0, l, pendingIntent);
            }
            ((Log)object).d("NightService registered to " + new SimpleDateFormat("EE MMM dd HH:mm:ss zzz yyyy", Locale.US).format(((Calendar)object3).getTime())).writeLog();
        }
    }

    public static void sendPushToBroadcast(Context context, Push push) {
        Intent intent = new Intent();
        intent.setAction(context.getPackageName() + ".action.PUSH_RECEIVED");
        intent.putExtra("com.indigitall.android.EXTRA_PUSH", push.toString());
        context.sendBroadcast(intent);
    }

    public static void sendPushAckToBroadcast(Context context, Push push) {
        Intent intent = new Intent();
        intent.setAction(context.getPackageName() + ".PUSH_ACK_RECEIVED");
        intent.putExtra("com.indigitall.android.EXTRA_PUSH", push.toString());
        context.sendBroadcast(intent);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void registerPushToken(Context object, String string, int n) {
        DeviceRequest deviceRequest;
        Log log;
        Log log2 = log;
        log = new Log(TAG, (Context)object);
        if (string == null) return;
        try {
            if (CorePreferenceUtils.getDeviceId((Context)object) == null) return;
            if (CorePreferenceUtils.getDeviceId((Context)object).equals("null")) return;
            if (CorePreferenceUtils.getDeviceId((Context)object).equals("")) return;
            PushPreferenceUtils.Companion.setPushToken((Context)object, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        DeviceRequest deviceRequest2 = deviceRequest;
        {
            if (new DeviceRequest((Context)object).getDevice() != null && PushValidations.isDeviceIdFormat(deviceRequest2.getDevice().getDeviceId())) {
                Object object2 = object;
                Client.putDevice(deviceRequest2, n, new DeviceCallback((Context)object2, (Context)object2, string, log2){
                    final /* synthetic */ Context val$context;
                    final /* synthetic */ String val$pushToken;
                    final /* synthetic */ Log val$log;
                    {
                        this.val$context = context2;
                        this.val$pushToken = string;
                        this.val$log = log;
                        super(context);
                    }

                    @Override
                    public void onSuccess(Device device) {
                        Intent intent;
                        Device device2 = device = intent;
                        device2();
                        device2.setAction(this.val$context.getPackageName() + ".action.REGISTER_PUSH_TOKEN");
                        intent.putExtra("android.intent.extra.TEXT", this.val$pushToken);
                        this.val$context.sendBroadcast((Intent)device);
                    }

                    @Override
                    public void onFail(ErrorModel errorModel) {
                        this.val$log.e(errorModel).writeLog();
                    }
                });
                return;
            }
            object = new StringBuilder().append("deviceId has not correct format: ");
            string = deviceRequest2.getDevice() != null ? deviceRequest2.getDevice().getDeviceId() : "";
            log2.w(((StringBuilder)object).append(string).toString()).writeLog();
            return;
        }
    }

    public static boolean isGoogleServicesEnabled(Context context) {
        try {
            return GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static void getPushToken(Context context, final PushTokenCallback pushTokenCallback) {
        Log log;
        final Log log2 = log;
        log = new Log(TAG, context);
        PushPreferenceUtils.Companion.getSenderId(context);
        try {
            FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                public void onComplete(@NonNull Task<String> task) {
                    if (!task.isSuccessful()) {
                        String string = "";
                        if (task.getException() != null) {
                            string = task.getException().getLocalizedMessage();
                        }
                        3 v0 = this;
                        v0.log2.w("Fetching FCM registration token failed" + string).writeLog();
                        v0.pushTokenCallback.onError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_FCM_REGISTRATION, string));
                    } else if (task.getResult() != null) {
                        pushTokenCallback.onSuccess((String)task.getResult());
                    }
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception exception) {
                    Object object = PushErrorCode.PUSH_FCM_GET_INSTANCE;
                    object.pushTokenCallback.onError(PushErrorUtils.INSTANCE.showError((PushErrorCode)((Object)object), exception.getLocalizedMessage()));
                }
            });
        }
        catch (Exception exception) {
            pushTokenCallback.onError(PushErrorUtils.INSTANCE.showError(PushErrorCode.PUSH_TOKEN_ERROR, "getPushToken: " + exception.getLocalizedMessage()));
        }
    }

    public static void registerAlarmService(Context context, String string, long l) {
        Intent intent;
        Log log;
        Log log2 = log;
        log = new Log(TAG, context);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent intent2 = intent;
        intent2(context, WifiWakeLockReceiver.class);
        intent.setAction(string);
        int n = IntentUtils.getPendingIntentFlags(0x8000000);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)n);
        log2.d("Service Utils->registerAlarmService");
        try {
            alarmManager.setRepeating(0, System.currentTimeMillis(), l, pendingIntent);
        }
        catch (NullPointerException nullPointerException) {
            log2.e(nullPointerException.toString());
        }
    }

    public static void registerStatistics(Context context, Intent intent) {
        Intent intent2;
        Intent intent3 = intent2;
        intent3(context, StatisticService.class);
        intent3.putExtra("StatisticService.EXTRA_APP_KEY", intent.getStringExtra("StatisticService.EXTRA_APP_KEY"));
        intent3.putExtra("StatisticService.EXTRA_PUSH_ID", intent.getIntExtra("StatisticService.EXTRA_PUSH_ID", 0));
        intent3.putExtra("StatisticService.EXTRA_SENDING_ID", intent.getStringExtra("StatisticService.EXTRA_SENDING_ID"));
        intent3.putExtra("StatisticService.EXTRA_CAMPAIGN_ID", intent.getStringExtra("StatisticService.EXTRA_CAMPAIGN_ID"));
        intent3.putExtra("StatisticService.EXTRA_JOURNEY_STATE_ID", intent.getIntExtra("StatisticService.EXTRA_JOURNEY_STATE_ID", 0));
        intent3.putExtra("StatisticService.EXTRA_CJ_CURRENT_STATE_ID", intent.getIntExtra("StatisticService.EXTRA_CJ_CURRENT_STATE_ID", 0));
        intent3.putExtra("StatisticService.EXTRA_CLICKED_BUTTON", intent.getIntExtra("StatisticService.EXTRA_CLICKED_BUTTON", 0));
        intent2.putExtra("StatisticService.EXTRA_ACTION_TOPICS", intent.getStringExtra("StatisticService.EXTRA_ACTION_TOPICS"));
        context.startService(intent3);
    }
}

