/*
 * Licensed to the Indoqa Software Design und Beratung GmbH (Indoqa) under
 * one or more contributor license agreements. See the NOTICE file distributed
 * with this work for additional information regarding copyright ownership.
 * Indoqa licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.indoqa.zookeeper.config.model;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ServiceInstance {

    private String name;

    private Map<String, Instant> sessions = new HashMap<>();

    public String getName() {
        return this.name;
    }

    public Map<String, Instant> getSessions() {
        return this.sessions;
    }

    public Optional<Instant> getStartDate(String session) {
        return Optional.ofNullable(this.sessions.get(session));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSession(String session, Instant startDate) {
        this.sessions.put(session, startDate);
    }

    public void setSessions(Map<String, Instant> sessions) {
        this.sessions = sessions;
    }
}
