/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config;

import com.indoqa.zookeeper.Execution;
import com.indoqa.zookeeper.StateExecutor;
import com.indoqa.zookeeper.ZooKeeperState;
import com.indoqa.zookeeper.config.model.AbstractServiceDescription;
import com.indoqa.zookeeper.config.states.DeleteServiceDescriptionsState;
import com.indoqa.zookeeper.config.states.ReadServiceDescriptionsState;
import com.indoqa.zookeeper.config.states.WriteServiceDescriptionsState;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZooKeeperConfigurator<T extends AbstractServiceDescription> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractZooKeeperConfigurator.class);
    private final String connectString;
    private final Class<T> serviceDescriptionType;

    protected AbstractZooKeeperConfigurator(String connectString, Class<T> serviceDescriptionType) {
        this.connectString = connectString;
        this.serviceDescriptionType = serviceDescriptionType;
    }

    protected void deleteServiceDescriptions() {
        LOGGER.info("Deleting service descriptions ...");
        try (StateExecutor stateExecutor = new StateExecutor(this.connectString);){
            Execution execution = stateExecutor.executeState((ZooKeeperState)new DeleteServiceDescriptionsState());
            stateExecutor.waitForTermination(execution);
        }
    }

    protected Collection<T> readServiceDescriptions() {
        LOGGER.info("Reading service descriptions ...");
        try (StateExecutor stateExecutor = new StateExecutor(this.connectString);){
            Execution execution = stateExecutor.executeState(new ReadServiceDescriptionsState<T>(this.serviceDescriptionType));
            stateExecutor.waitForTermination(execution);
            Collection collection = ReadServiceDescriptionsState.getServiceDescriptions(execution);
            return collection;
        }
    }

    protected void writeServiceDescriptions(Collection<? extends T> serviceDescriptions) {
        LOGGER.info("Writing service descriptions ...");
        try (StateExecutor stateExecutor = new StateExecutor(this.connectString);){
            Execution execution = stateExecutor.executeState(new WriteServiceDescriptionsState<T>(serviceDescriptions));
            stateExecutor.waitForTermination(execution);
        }
    }
}

