/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config;

import com.indoqa.zookeeper.Execution;
import com.indoqa.zookeeper.StateExecutor;
import com.indoqa.zookeeper.ZooKeeperState;
import com.indoqa.zookeeper.config.states.ReadConfigurationState;
import java.util.Map;
import org.springframework.core.env.MapPropertySource;

public class ZooKeeperPropertySource
extends MapPropertySource {
    public ZooKeeperPropertySource(StateExecutor stateExecutor, String basePath) {
        super(ZooKeeperPropertySource.getName(basePath), ZooKeeperPropertySource.loadProperties(stateExecutor, basePath));
    }

    public ZooKeeperPropertySource(String connectString, int sessionTimeout, String basePath) {
        super(ZooKeeperPropertySource.getName(basePath), ZooKeeperPropertySource.loadProperties(connectString, sessionTimeout, basePath));
    }

    private static String getName(String basePath) {
        return "ZooKeeper properties @ " + basePath;
    }

    private static Map<String, Object> loadProperties(StateExecutor stateExecutor, String basePath) {
        Execution execution = stateExecutor.executeState((ZooKeeperState)new ReadConfigurationState(basePath));
        stateExecutor.waitForTermination(execution);
        return (Map)execution.getEnvironmentValue("properties");
    }

    private static Map<String, Object> loadProperties(String connectString, int sessionTimeout, String basePath) {
        try (StateExecutor stateExecutor = new StateExecutor(connectString, sessionTimeout);){
            Map<String, Object> map = ZooKeeperPropertySource.loadProperties(stateExecutor, basePath);
            return map;
        }
    }
}

