/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config;

import com.indoqa.zookeeper.StateExecutor;
import com.indoqa.zookeeper.ZooKeeperState;
import com.indoqa.zookeeper.config.ZooKeeperPropertySource;
import com.indoqa.zookeeper.config.states.RegisterInstanceZooKeeperState;
import com.indoqa.zookeeper.config.utils.ZooKeeperRegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public final class ZooKeeperRegistrationUtils {
    private static final String PROP_ZK_CONNECT_STRING = "zookeeper.connect-string";
    private static final String PROP_ZK_SESSION_TIMEOUT = "zookeeper.session-timeout";
    private static final String DEFAULT_ZK_SESSION_TIMEOUT = "5000";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperRegistrationUtils.class);

    private ZooKeeperRegistrationUtils() {
    }

    public static void registerZooKeeperServices(ConfigurableApplicationContext applicationContext, String ... servicesNames) {
        ZooKeeperRegistrationUtils.checkServiceNames(servicesNames);
        String connectString = applicationContext.getEnvironment().getProperty(PROP_ZK_CONNECT_STRING);
        if (StringUtils.isEmpty((Object)connectString)) {
            LOGGER.warn("The property '{}' is not set or empty. The application will NOT register with ZooKeeper.", (Object)PROP_ZK_CONNECT_STRING);
            return;
        }
        int sessionTimeout = ZooKeeperRegistrationUtils.getSessionTimeout(applicationContext);
        StateExecutor stateExecutor = new StateExecutor(connectString, sessionTimeout);
        ZooKeeperRegistrationUtils.registerStateExecutor(applicationContext, stateExecutor);
        MutablePropertySources propertySources = applicationContext.getEnvironment().getPropertySources();
        for (String eachServiceName : servicesNames) {
            ZooKeeperRegistrationUtils.registerService(stateExecutor, eachServiceName);
            ZooKeeperRegistrationUtils.addPropertySource(stateExecutor, propertySources, eachServiceName);
        }
    }

    private static void addPropertySource(StateExecutor stateExecutor, MutablePropertySources propertySources, String serviceName) {
        propertySources.addLast((PropertySource)new ZooKeeperPropertySource(stateExecutor, "/" + serviceName + "/properties"));
    }

    private static void checkServiceNames(String[] servicesNames) {
        if (servicesNames == null || servicesNames.length == 0) {
            throw new ZooKeeperRegistrationException("There was no service name passed that should be used to register the application.");
        }
    }

    private static int getSessionTimeout(ConfigurableApplicationContext applicationContext) {
        try {
            String value = applicationContext.getEnvironment().getProperty(PROP_ZK_SESSION_TIMEOUT);
            if (StringUtils.isEmpty((Object)value)) {
                value = DEFAULT_ZK_SESSION_TIMEOUT;
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ZooKeeperRegistrationException("Error while parsing the value of property zookeeper.session-timeout", e);
        }
    }

    private static void registerService(StateExecutor stateExecutor, String serviceName) {
        stateExecutor.executeState((ZooKeeperState)new RegisterInstanceZooKeeperState(serviceName));
    }

    private static void registerStateExecutor(ConfigurableApplicationContext applicationContext, StateExecutor stateExecutor) {
        applicationContext.getBeanFactory().registerSingleton(stateExecutor.getClass().getName(), (Object)stateExecutor);
    }
}

