/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config.model;

import com.indoqa.zookeeper.config.model.ServiceInstance;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractServiceDescription {
    private String id;
    private String name;
    private String description;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, ServiceInstance> instances = new HashMap<String, ServiceInstance>();

    public void addInstance(ServiceInstance instance) {
        this.instances.put(instance.getName(), instance);
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getId() {
        return this.id;
    }

    public final Map<String, ServiceInstance> getInstances() {
        return this.instances;
    }

    public final String getName() {
        return this.name;
    }

    public final Map<String, String> getProperties() {
        return this.properties;
    }

    public final Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.properties.get(propertyName));
    }

    public void onRead() {
        if (this.instances == null) {
            return;
        }
        for (Map.Entry<String, ServiceInstance> eachEntry : this.instances.entrySet()) {
            eachEntry.getValue().setName(eachEntry.getKey());
        }
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setInstances(Map<String, ServiceInstance> instances) {
        this.instances = instances;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public final void setProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }
}

