/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config.states;

import com.indoqa.zookeeper.AbstractZooKeeperState;
import com.indoqa.zookeeper.config.model.AbstractServiceDescription;
import com.indoqa.zookeeper.config.utils.ReflectionHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.KeeperException;

public abstract class AbstractReadServiceDescriptonZooKeeperState<T extends AbstractServiceDescription>
extends AbstractZooKeeperState {
    protected AbstractReadServiceDescriptonZooKeeperState(String name) {
        super(name);
    }

    protected T readServiceDescription(String serviceId, Class<T> resultType) throws KeeperException {
        this.logger.info("Reading service description '{}' ...", (Object)serviceId);
        String path = AbstractReadServiceDescriptonZooKeeperState.combinePath((String[])new String[]{"/", serviceId});
        if (!this.exists(path)) {
            return null;
        }
        AbstractServiceDescription result = (AbstractServiceDescription)this.read(path, resultType);
        if (result.getId() == null) {
            return null;
        }
        result.onRead();
        return (T)result;
    }

    private Object read(String path, Type type) throws KeeperException {
        if (!this.exists(path)) {
            return null;
        }
        if (ReflectionHelper.isSimpleType(type)) {
            return this.readSimpleValue(path, type);
        }
        if (ReflectionHelper.isMap(type)) {
            return this.readMap(path, type);
        }
        if (ReflectionHelper.isCollection(type)) {
            return this.readCollection(path, type);
        }
        if (ReflectionHelper.isArray(type)) {
            return this.readArray(path, type);
        }
        return this.readObject(path, type);
    }

    private Object readArray(String path, Type type) throws KeeperException {
        Class<?> valueType = ((Class)type).getComponentType();
        List children = this.getChildren(path);
        Object result = Array.newInstance(valueType, children.size());
        int index = 0;
        for (String eachChild : children) {
            Object childValue = this.read(AbstractReadServiceDescriptonZooKeeperState.combinePath((String[])new String[]{path, eachChild}), valueType);
            Array.set(result, index, childValue);
            ++index;
        }
        return result;
    }

    private Object readCollection(String path, Type type) throws KeeperException {
        Collection result = (Collection)ReflectionHelper.createInstance(type);
        Type valueType = ((ParameterizedType)type).getActualTypeArguments()[0];
        List children = this.getChildren(path);
        for (String eachChild : children) {
            Object childValue = this.read(AbstractReadServiceDescriptonZooKeeperState.combinePath((String[])new String[]{path, eachChild}), valueType);
            result.add(childValue);
        }
        return result;
    }

    private Object readMap(String path, Type type) throws KeeperException {
        Map result = (Map)ReflectionHelper.createInstance(type);
        Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
        List children = this.getChildren(path);
        for (String eachChild : children) {
            Object childValue = this.read(AbstractReadServiceDescriptonZooKeeperState.combinePath((String[])new String[]{path, eachChild}), valueType);
            result.put(eachChild, childValue);
        }
        return result;
    }

    private Object readObject(String path, Type type) throws KeeperException {
        this.logger.debug("ReadObject {} {}", (Object)path, (Object)type.getTypeName());
        Object result = ReflectionHelper.createInstance(type);
        for (Class<?> currentClass = result.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field eachDeclaredField : currentClass.getDeclaredFields()) {
                String valuePath = AbstractReadServiceDescriptonZooKeeperState.combinePath((String[])new String[]{path, eachDeclaredField.getName()});
                Object value = this.read(valuePath, eachDeclaredField.getGenericType());
                ReflectionHelper.setFieldValue(eachDeclaredField, result, value);
            }
        }
        return result;
    }

    private Object readSimpleValue(String path, Type type) throws KeeperException {
        String serializedvalue = this.readValue(path);
        return ReflectionHelper.getDeserializedValue(serializedvalue, type);
    }

    private String readValue(String path) throws KeeperException {
        try {
            byte[] data = this.getData(path, null);
            if (data == null || data.length == 0) {
                return "";
            }
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (KeeperException.NoNodeException e) {
            this.logger.error("Could not find node '{}'.", (Object)path, (Object)e);
            return null;
        }
    }
}

