/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config.states;

import com.indoqa.zookeeper.AbstractZooKeeperState;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ReadConfigurationState
extends AbstractZooKeeperState {
    private static final String PLACEHOLDER_START = "${zk:";
    private static final String PLACEHOLDER_END = "}";
    private final String basePath;
    private final Map<String, String> encounteredPlaceholders = new HashMap<String, String>();

    public ReadConfigurationState(String basePath) {
        super("Read properties from " + basePath);
        this.basePath = basePath;
    }

    private static String asString(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Charset 'UTF-8' is not available!", e);
        }
    }

    private static boolean hasData(byte[] data) {
        return data != null && data.length > 0;
    }

    protected void onStart() throws KeeperException {
        super.onStart();
        this.terminate();
        Map<String, Object> properties = this.readProperties();
        this.setEnvironmentValue("properties", properties);
    }

    private String fillPlaceholders(String propertyValue) throws KeeperException {
        int startIndex = propertyValue.indexOf(PLACEHOLDER_START);
        if (startIndex == -1) {
            return propertyValue;
        }
        int endIndex = propertyValue.indexOf(PLACEHOLDER_END, startIndex);
        String path = propertyValue.substring(startIndex + PLACEHOLDER_START.length(), endIndex);
        String value = this.encounteredPlaceholders.get(path);
        if (value == null) {
            value = this.getPropertyValue(path);
            this.encounteredPlaceholders.put(path, value);
        }
        if (value == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(propertyValue);
        stringBuilder.replace(startIndex, endIndex + PLACEHOLDER_END.length(), value);
        return this.fillPlaceholders(stringBuilder.toString());
    }

    private String getPropertyValue(String path) throws KeeperException {
        try {
            Stat stat = new Stat();
            byte[] data = this.getData(path, stat);
            if (ReadConfigurationState.hasData(data)) {
                return ReadConfigurationState.asString(data);
            }
            if (stat.getNumChildren() == 0) {
                return "";
            }
        }
        catch (KeeperException.NoNodeException e) {
            this.logger.error("Could not read property value from node '{}', because the path does not exist.", (Object)path, (Object)e);
        }
        return null;
    }

    private String getRelativePath(String path) {
        if (path.startsWith(this.basePath)) {
            return path.substring(this.basePath.length() + 1);
        }
        return path;
    }

    private Map<String, Object> readProperties() throws KeeperException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.exists(this.basePath)) {
            this.logger.error("Base path '{}' does not exist.", (Object)this.basePath);
            return result;
        }
        this.logger.info("Reading properties at '{}'.", (Object)this.basePath);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(this.basePath);
        while (!paths.isEmpty()) {
            String path = (String)paths.remove(0);
            List children = this.getChildren(path);
            for (String eachChild : children) {
                String childPath = ReadConfigurationState.combinePath((String[])new String[]{path, eachChild});
                paths.add(childPath);
                this.readProperty(childPath, result);
            }
        }
        this.logger.info("Found {} property value(s).", (Object)result.size());
        return result;
    }

    private void readProperty(String propertyPath, Map<String, Object> properties) throws KeeperException {
        String propertyName = this.getRelativePath(propertyPath);
        String propertyValue = this.getPropertyValue(propertyPath);
        propertyValue = this.fillPlaceholders(propertyValue);
        properties.put(propertyName, propertyValue);
    }
}

