/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config.states;

import com.indoqa.zookeeper.Execution;
import com.indoqa.zookeeper.config.model.AbstractServiceDescription;
import com.indoqa.zookeeper.config.states.AbstractReadServiceDescriptonZooKeeperState;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.zookeeper.KeeperException;

public class ReadServiceDescriptionsState<T extends AbstractServiceDescription>
extends AbstractReadServiceDescriptonZooKeeperState<T> {
    private static final String SERVICE_DESCRIPTIONS_KEY = "service-descriptions";
    private final Class<T> resultType;

    public ReadServiceDescriptionsState(Class<T> type) {
        super("Read Service Descriptions");
        this.resultType = type;
    }

    public static <T extends AbstractServiceDescription> Collection<T> getServiceDescriptions(Execution execution) {
        return execution.getEnvironmentValues(SERVICE_DESCRIPTIONS_KEY);
    }

    protected void onStart() throws KeeperException {
        this.terminate();
        ArrayList<T> serviceDescriptions = new ArrayList<T>();
        this.setEnvironmentValues(SERVICE_DESCRIPTIONS_KEY, serviceDescriptions);
        for (String eachServiceId : this.getChildren("/")) {
            T serviceDescription = this.readServiceDescription(eachServiceId, this.resultType);
            if (serviceDescription == null) continue;
            serviceDescriptions.add(serviceDescription);
        }
    }
}

