/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config.states;

import com.indoqa.zookeeper.AbstractZooKeeperState;
import com.indoqa.zookeeper.config.utils.ReflectionHelper;
import com.indoqa.zookeeper.config.utils.ZooKeeperRegistrationException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.UUID;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class RegisterInstanceZooKeeperState
extends AbstractZooKeeperState {
    private final String serviceId;

    public RegisterInstanceZooKeeperState(String serviceId) {
        super("Register Instance for '" + serviceId + "'.");
        this.serviceId = serviceId;
    }

    protected void onStart() throws KeeperException {
        super.onStart();
        String hostName = this.getHostName();
        String sessionName = "0x" + Long.toHexString(this.zooKeeper.getSessionId());
        this.logger.info("Registering instance '{}' @ session '{}' ...", (Object)hostName, (Object)sessionName);
        String instancesPath = RegisterInstanceZooKeeperState.combinePath((String[])new String[]{this.serviceId, "instances"});
        if (!this.exists(instancesPath)) {
            throw new ZooKeeperRegistrationException("The path '" + instancesPath + "' does not exist. Check if ZooKeeper contains the service description '" + this.serviceId + "'.");
        }
        String instancePath = RegisterInstanceZooKeeperState.combinePath((String[])new String[]{instancesPath, hostName, "sessions"});
        this.ensureNodeExists(instancePath);
        try {
            String sessionNode = RegisterInstanceZooKeeperState.combinePath((String[])new String[]{instancePath, sessionName});
            byte[] value = ReflectionHelper.getSerializedValue(Instant.now()).getBytes(StandardCharsets.UTF_8);
            this.createNode(sessionNode, value, CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException e) {
            this.logger.debug("Session node already exists.", (Throwable)e);
        }
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.logger.error("Could not determine host name.", (Throwable)e);
            return "UNKNOWN-" + UUID.randomUUID().toString();
        }
    }
}

