/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config.states;

import com.indoqa.zookeeper.AbstractZooKeeperState;
import com.indoqa.zookeeper.config.model.AbstractServiceDescription;
import com.indoqa.zookeeper.config.utils.ReflectionHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.apache.zookeeper.KeeperException;

public class WriteServiceDescriptionsState<T extends AbstractServiceDescription>
extends AbstractZooKeeperState {
    private Collection<? extends T> serviceDescriptions;

    public WriteServiceDescriptionsState(Collection<? extends T> serviceDescriptions) {
        super("Create Service Descriptions");
        this.serviceDescriptions = serviceDescriptions;
    }

    protected void onStart() throws KeeperException {
        this.terminate();
        this.ensureNodeExists("/");
        for (AbstractServiceDescription eachServiceDescription : this.serviceDescriptions) {
            this.create(eachServiceDescription);
        }
    }

    private void create(AbstractServiceDescription serviceDescription) throws KeeperException {
        this.logger.info("Creating service description '{}' ...", (Object)serviceDescription.getId());
        String servicePath = WriteServiceDescriptionsState.combinePath((String[])new String[]{"/", serviceDescription.getId()});
        this.write(servicePath, serviceDescription, serviceDescription.getClass());
    }

    private void write(String path, Object object, Type type) throws KeeperException {
        this.ensureNodeExists(path);
        if (object == null) {
            this.writeNull(path);
            return;
        }
        if (ReflectionHelper.isSimpleType(type)) {
            this.writeSimpleValue(path, object);
            return;
        }
        if (Map.class.isInstance(object)) {
            this.writeMapValue(path, (Map)object, type);
            return;
        }
        if (Collection.class.isInstance(object)) {
            this.writeCollectionValue(path, (Collection)object, type);
            return;
        }
        if (ReflectionHelper.isArray(type)) {
            this.writeArray(path, object, type);
            return;
        }
        this.writeObject(path, object);
    }

    private void writeArray(String path, Object value, Type type) throws KeeperException {
        Class<?> valueType = ((Class)type).getComponentType();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            Object eachValue = Array.get(value, i);
            String valuePath = WriteServiceDescriptionsState.combinePath((String[])new String[]{path, String.valueOf(i)});
            this.write(valuePath, eachValue, valueType);
        }
    }

    private void writeCollectionValue(String path, Collection<?> value, Type type) throws KeeperException {
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type valueType = parameterizedType.getActualTypeArguments()[0];
        int index = 0;
        for (Object eachValue : value) {
            String valuePath = WriteServiceDescriptionsState.combinePath((String[])new String[]{path, String.valueOf(index)});
            this.write(valuePath, eachValue, valueType);
            ++index;
        }
    }

    private void writeMapValue(String path, Map<String, ?> value, Type type) throws KeeperException {
        if (!ReflectionHelper.isCompatibleMap(type)) {
            throw new IllegalArgumentException("Incompatible map type " + type);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type valueType = parameterizedType.getActualTypeArguments()[1];
        for (Map.Entry<String, ?> eachEntry : value.entrySet()) {
            String valuePath = WriteServiceDescriptionsState.combinePath((String[])new String[]{path, eachEntry.getKey()});
            this.write(valuePath, eachEntry.getValue(), valueType);
        }
    }

    private void writeNull(String targetPath) throws KeeperException {
        this.writeValue(targetPath, "");
    }

    private void writeObject(String path, Object object) throws KeeperException {
        for (Class<?> currentClass = object.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field eachDeclaredField : currentClass.getDeclaredFields()) {
                String valuePath = WriteServiceDescriptionsState.combinePath((String[])new String[]{path, eachDeclaredField.getName()});
                Object value = ReflectionHelper.getFieldValue(eachDeclaredField, object);
                this.write(valuePath, value, eachDeclaredField.getGenericType());
            }
        }
    }

    private void writeSimpleValue(String targetPath, Object value) throws KeeperException {
        String serializedValue = ReflectionHelper.getSerializedValue(value);
        this.writeValue(targetPath, serializedValue);
    }

    private void writeValue(String path, String value) throws KeeperException {
        this.setData(path, value.getBytes(StandardCharsets.UTF_8), -1);
    }
}

