/*
 * Decompiled with CFR 0.152.
 */
package com.indoqa.zookeeper.config.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ReflectionHelper {
    private static final Set<String> SIMPLE_TYPE_NAMES = new HashSet<String>();
    private static final Map<String, Supplier<Object>> CREATORS;
    private static final Map<String, Function<String, ? extends Object>> DESERIALIZERS;

    private ReflectionHelper() {
    }

    public static Object createInstance(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ReflectionHelper.createInstance(parameterizedType.getRawType());
        }
        if (type instanceof Class) {
            Class classType = (Class)type;
            Supplier<Object> supplier = CREATORS.get(classType.getName());
            if (supplier != null) {
                return supplier.get();
            }
            try {
                return classType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate type " + type, e);
            }
        }
        throw new IllegalArgumentException("Cannot instantiate type " + type);
    }

    public static Object getDeserializedValue(String value, Type type) {
        Class classType;
        Function<String, ? extends Object> converter;
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.getDeserializedValue(value, ((ParameterizedType)type).getRawType());
        }
        if (type instanceof Class && (converter = DESERIALIZERS.get((classType = (Class)type).getName())) != null) {
            return converter.apply(value);
        }
        throw new IllegalArgumentException("Cannot convert value '" + value + "' to type " + type);
    }

    public static Type getFieldType(Object object, String fieldName) {
        try {
            return object.getClass().getDeclaredField(fieldName).getGenericType();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find field '" + fieldName + "' on " + object, e);
        }
    }

    public static Object getFieldValue(Field field, Object target) {
        try {
            field.setAccessible(true);
            Object object = field.get(target);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve value of field " + field, e);
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static String getSerializedValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return ReflectionHelper.getSerializedValue(((Date)value).toInstant());
        }
        return String.valueOf(value);
    }

    public static boolean isArray(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ReflectionHelper.isArray(parameterizedType.getRawType());
        }
        return type instanceof Class && ((Class)type).isArray();
    }

    public static boolean isCollection(Type type) {
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isCollection(((ParameterizedType)type).getRawType());
        }
        if (type instanceof Class) {
            return Collection.class.isAssignableFrom((Class)type);
        }
        return false;
    }

    public static boolean isCompatibleCollection(Type type) {
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length != 1) {
            throw new IllegalArgumentException("Expected 1 generic parameter, but found " + actualTypeArguments.length);
        }
        return ReflectionHelper.isSimpleType(actualTypeArguments[0].getTypeName());
    }

    public static boolean isCompatibleMap(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Type of map should be a ParameterizedType.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length != 2) {
            throw new IllegalArgumentException("Expected 2 generic parameters, but found " + actualTypeArguments.length);
        }
        return actualTypeArguments[0].getTypeName().equals(String.class.getName());
    }

    public static boolean isList(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ReflectionHelper.isList(parameterizedType.getRawType());
        }
        return type instanceof Class && List.class.isAssignableFrom((Class)type);
    }

    public static boolean isMap(Type type) {
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof Class) {
            return Map.class.isAssignableFrom((Class)type);
        }
        return false;
    }

    public static boolean isSimpleType(String typeName) {
        return SIMPLE_TYPE_NAMES.contains(typeName);
    }

    public static boolean isSimpleType(Type type) {
        return ReflectionHelper.isSimpleType(type.getTypeName());
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set value of field " + field + " to " + value, e);
        }
        finally {
            field.setAccessible(false);
        }
    }

    static {
        SIMPLE_TYPE_NAMES.add(String.class.getName());
        SIMPLE_TYPE_NAMES.add(Boolean.TYPE.getName());
        SIMPLE_TYPE_NAMES.add(Character.TYPE.getName());
        SIMPLE_TYPE_NAMES.add(Short.TYPE.getName());
        SIMPLE_TYPE_NAMES.add(Integer.TYPE.getName());
        SIMPLE_TYPE_NAMES.add(Long.TYPE.getName());
        SIMPLE_TYPE_NAMES.add(Float.TYPE.getName());
        SIMPLE_TYPE_NAMES.add(Double.TYPE.getName());
        SIMPLE_TYPE_NAMES.add(Boolean.class.getName());
        SIMPLE_TYPE_NAMES.add(Character.class.getName());
        SIMPLE_TYPE_NAMES.add(Short.class.getName());
        SIMPLE_TYPE_NAMES.add(Integer.class.getName());
        SIMPLE_TYPE_NAMES.add(Long.class.getName());
        SIMPLE_TYPE_NAMES.add(Float.class.getName());
        SIMPLE_TYPE_NAMES.add(Double.class.getName());
        SIMPLE_TYPE_NAMES.add(Date.class.getName());
        SIMPLE_TYPE_NAMES.add(Instant.class.getName());
        CREATORS = new HashMap<String, Supplier<Object>>();
        CREATORS.put(List.class.getName(), ArrayList::new);
        CREATORS.put(Set.class.getName(), HashSet::new);
        CREATORS.put(Collection.class.getName(), ArrayList::new);
        CREATORS.put(Map.class.getName(), HashMap::new);
        DESERIALIZERS = new HashMap<String, Function<String, ? extends Object>>();
        DESERIALIZERS.put(Boolean.TYPE.getName(), Boolean::valueOf);
        DESERIALIZERS.put(Character.TYPE.getName(), value -> Character.valueOf(value.charAt(0)));
        DESERIALIZERS.put(Short.TYPE.getName(), Short::valueOf);
        DESERIALIZERS.put(Integer.TYPE.getName(), Integer::valueOf);
        DESERIALIZERS.put(Long.TYPE.getName(), Long::valueOf);
        DESERIALIZERS.put(Float.TYPE.getName(), Float::valueOf);
        DESERIALIZERS.put(Double.TYPE.getName(), Double::valueOf);
        DESERIALIZERS.put(Boolean.class.getName(), Boolean::valueOf);
        DESERIALIZERS.put(Character.class.getName(), value -> Character.valueOf(value.charAt(0)));
        DESERIALIZERS.put(Short.class.getName(), Short::valueOf);
        DESERIALIZERS.put(Integer.class.getName(), Integer::valueOf);
        DESERIALIZERS.put(Long.class.getName(), Long::valueOf);
        DESERIALIZERS.put(Float.class.getName(), Float::valueOf);
        DESERIALIZERS.put(Double.class.getName(), Double::valueOf);
        DESERIALIZERS.put(Date.class.getName(), value -> Date.from(Instant.parse(value)));
        DESERIALIZERS.put(Instant.class.getName(), value -> Instant.parse(value));
        DESERIALIZERS.put(String.class.getName(), Function.identity());
    }
}

