/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.spark.quickbooks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkSchema
implements Serializable {
    private StructType structType = new StructType();
    private final Map<String, String> methodNames = new HashMap<String, String>();
    private final Map<String, SparkSchema> schemas = new HashMap<String, SparkSchema>();
    private boolean flattened = false;
    private int arraySize = 0;

    public SparkSchema flatten(boolean expandArrays) {
        StructType flat = this.flatten("", this.schemas, expandArrays);
        this.structType = this.structType.merge(flat);
        return this;
    }

    public StructType flatten(String parent, Map<String, SparkSchema> schemas, boolean expand) {
        ArrayList<StructField> structFields = new ArrayList<StructField>();
        HashMap<String, SparkSchema> newSchemas = new HashMap<String, SparkSchema>();
        for (Map.Entry<String, SparkSchema> entry : schemas.entrySet()) {
            String key = entry.getKey();
            SparkSchema schema = entry.getValue();
            String prefixedKey = parent + key;
            if (!this.structType.nonEmpty()) continue;
            schema.flattened = true;
            int schemaArraySize = schema.getArraySize();
            if (schemaArraySize == 0) {
                this.flattenStruct(schemas, structFields, newSchemas, key, schema, prefixedKey, expand);
                continue;
            }
            if (!expand) continue;
            for (int i = 0; i < schemaArraySize; ++i) {
                String newKeyName = prefixedKey + "_" + i;
                this.flattenStruct(schemas, structFields, newSchemas, key, schema, newKeyName, expand);
            }
        }
        schemas.putAll(newSchemas);
        return DataTypes.createStructType(structFields);
    }

    private void flattenStruct(Map<String, SparkSchema> schemas, List<StructField> structFields, Map<String, SparkSchema> newSchemas, String key, SparkSchema schema, String newKeyName, boolean expand) {
        Map<String, SparkSchema> originalSchemas = schema.schemas;
        String parent = newKeyName + "_";
        StructType newStructType = schema.flatten(parent, new HashMap<String, SparkSchema>(originalSchemas), expand);
        if (newStructType.nonEmpty()) {
            for (StructField field : newStructType.fields()) {
                structFields.add(field);
                newSchemas.put(field.name(), schemas.get(key));
            }
        } else {
            int fieldIndex = this.structType.fieldIndex(key);
            StructField type = this.structType.apply(fieldIndex);
            StructField structField = new StructField(newKeyName, type.dataType(), type.nullable(), type.metadata());
            structFields.add(structField);
        }
    }

    public void setMethodName(String fieldName, String methodName) {
        this.methodNames.put(fieldName, methodName);
    }

    public String getMethodName(String fieldName) {
        return this.methodNames.get(fieldName);
    }

    public void setStructType(StructType structType) {
        this.structType = structType;
    }

    public StructType getStructType() {
        return this.structType;
    }

    public void addSchema(String fieldName, SparkSchema schema) {
        this.schemas.merge(fieldName, schema, SparkSchema::merge);
    }

    public SparkSchema getSchema(String fieldName) {
        return this.schemas.get(fieldName);
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public void setArraySize(int arraySize) {
        this.arraySize = arraySize;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    private static SparkSchema merge(SparkSchema a, SparkSchema b) {
        SparkSchema newSchema = new SparkSchema();
        newSchema.structType = a.structType.merge(b.structType);
        newSchema.methodNames.putAll(a.methodNames);
        newSchema.methodNames.putAll(b.methodNames);
        newSchema.schemas.putAll(a.schemas);
        newSchema.setArraySize(Math.max(a.arraySize, b.arraySize));
        assert (a.flattened == b.flattened) : "Trying to merge flattened struct with nested struct";
        newSchema.flattened = a.flattened;
        for (Map.Entry<String, SparkSchema> entry : b.schemas.entrySet()) {
            newSchema.schemas.merge(entry.getKey(), entry.getValue(), SparkSchema::merge);
        }
        return newSchema;
    }
}

