/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.spark.quickbooks;

import inetsoft.spark.quickbooks.SparkSchema;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSchemaGenerator
implements Serializable {
    private static final Map<Class, List<PropertyDescriptor>> descriptorCache = new HashMap<Class, List<PropertyDescriptor>>();
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public SparkSchema generateSchema(Object ... entities) {
        SparkSchema sparkSchema = new SparkSchema();
        for (Object entity : entities) {
            StructType structType = sparkSchema.getStructType();
            List<PropertyDescriptor> properties = this.getPropertyDescriptors(entity.getClass());
            for (PropertyDescriptor property : properties) {
                StructField field;
                String propertyName = property.getName();
                Class<?> propertyType = property.getPropertyType();
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                try {
                    field = this.createStructField(propertyName, readMethod.invoke(entity, new Object[0]), propertyType, sparkSchema);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.error("Unable to access object properties", (Throwable)e);
                    return null;
                }
                StructType s = new StructType();
                s = s.add(field);
                structType = structType.merge(s);
                sparkSchema.setStructType(structType);
                sparkSchema.setMethodName(propertyName, readMethod.getName());
            }
        }
        return sparkSchema;
    }

    private StructField createStructField(String propertyName, Object propertyValue, Class<?> propertyType, SparkSchema schema) {
        StructField field;
        DataType type = SparkSchemaGenerator.getDataTypeFromClass(propertyType);
        if (!type.sameType(DataTypes.BinaryType)) {
            field = new StructField(propertyName, type, true, Metadata.empty());
            schema.addSchema(propertyName, new SparkSchema());
        } else if (propertyValue != null) {
            if (Collection.class.isAssignableFrom(propertyType)) {
                field = this.createArrayField(propertyName, (Collection)propertyValue, schema);
            } else if (propertyType.isArray()) {
                field = this.createArrayField(propertyName, Collections.singletonList(propertyValue), schema);
            } else {
                SparkSchema nestedSchema = this.generateSchema(propertyValue);
                StructType structType = nestedSchema.getStructType();
                schema.addSchema(propertyName, nestedSchema);
                field = new StructField(propertyName, (DataType)structType, true, Metadata.empty());
            }
        } else {
            field = new StructField(propertyName, (DataType)new StructType(), true, Metadata.empty());
        }
        return field;
    }

    private StructField createArrayField(String propertyName, Collection children, SparkSchema schema) {
        SparkSchema sparkSchema = this.generateSchema(children.toArray());
        sparkSchema.setArraySize(children.size());
        schema.addSchema(propertyName, sparkSchema);
        StructType complexStructType = sparkSchema.getStructType();
        return new StructField(propertyName, (DataType)DataTypes.createArrayType((DataType)complexStructType, (boolean)true), true, Metadata.empty());
    }

    private List<PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        if (descriptorCache.containsKey(clazz)) {
            return descriptorCache.get(clazz);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null) {
                List<PropertyDescriptor> list = Arrays.stream(propertyDescriptors).filter(Objects::nonNull).collect(Collectors.toList());
                descriptorCache.put(clazz, list);
                return list;
            }
        }
        catch (IntrospectionException e) {
            LOG.error("Failed to generate schema", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static DataType getDataTypeFromClass(Class clazz) {
        String typeName;
        switch (typeName = clazz.getSimpleName()) {
            case "byte": 
            case "Byte": {
                return DataTypes.ByteType;
            }
            case "short": 
            case "Short": {
                return DataTypes.ShortType;
            }
            case "int": 
            case "Integer": {
                return DataTypes.IntegerType;
            }
            case "long": 
            case "Long": {
                return DataTypes.LongType;
            }
            case "float": 
            case "Float": {
                return DataTypes.FloatType;
            }
            case "double": 
            case "Double": {
                return DataTypes.DoubleType;
            }
            case "BigDecimal": {
                return DataTypes.createDecimalType();
            }
            case "String": {
                return DataTypes.StringType;
            }
            case "boolean": 
            case "Boolean": {
                return DataTypes.BooleanType;
            }
            case "Date": {
                return DataTypes.LongType;
            }
            case "Timestamp": {
                return DataTypes.LongType;
            }
            case "Object": {
                return DataTypes.BinaryType;
            }
        }
        if (clazz.isEnum()) {
            return DataTypes.StringType;
        }
        return DataTypes.BinaryType;
    }
}

