/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.spark.quickbooks.source;

import inetsoft.spark.quickbooks.QuickbooksUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickbooksClassloader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private QuickbooksClassloader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public static QuickbooksClassloader create(ClassLoader parent) throws IOException, URISyntaxException {
        File[] files;
        URL location = QuickbooksClassloader.class.getProtectionDomain().getCodeSource().getLocation();
        File quickbooksJar = new File(location.toURI());
        File libDir = new File(QuickbooksUtil.getQbLibDir());
        if (libDir.mkdir() || libDir.lastModified() < quickbooksJar.lastModified()) {
            QuickbooksClassloader.deleteOldJars();
            JarFile jarFile = new JarFile(quickbooksJar);
            ArrayList<JarEntry> entries = Collections.list(jarFile.entries());
            for (JarEntry jarEntry : entries) {
                QuickbooksClassloader.extractToLibFolder(libDir, jarFile, jarEntry);
            }
            jarFile.close();
        }
        if ((files = libDir.listFiles((dir, name) -> name.endsWith(".jar"))) == null) {
            throw new FileNotFoundException("Could not read the QuickBooks lib folder");
        }
        return new QuickbooksClassloader((URL[])Arrays.stream(files).filter(Objects::nonNull).map(File::toURI).map(QuickbooksClassloader::toUrl).toArray(URL[]::new), parent);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        URL[] urls = this.getURLs();
        if (!name.startsWith("org.slf4j") && !name.startsWith("com.sun.xml")) {
            for (URL url : urls) {
                Class clazz = this.findClassInJAR(url, name, "", false);
                if (clazz == null) continue;
                return clazz;
            }
        }
        return super.loadClass(name, resolve);
    }

    private static URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Class findClassInJAR(URL searchURL, String name, String prefix, boolean resolve) throws ClassNotFoundException {
        String path;
        URL url;
        if (searchURL != null && name.startsWith(prefix) && (url = this.findResource(path = name.replace('.', '/').concat(".class"))) != null && "jar".equals(url.getProtocol())) {
            path = url.getFile();
            int index = path.indexOf(33);
            if (index >= 0) {
                path = path.substring(0, index);
            }
            try {
                url = new URL(path);
                if (url.equals(searchURL)) {
                    Class<?> clazz = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (MalformedURLException e) {
                LOG.warn("Failed to check JAR file URL", (Throwable)e);
            }
        }
        return null;
    }

    private static void extractToLibFolder(File libDir, JarFile jarFile, JarEntry jarEntry) throws IOException {
        if (!jarEntry.isDirectory() && jarEntry.getName().startsWith("quickbooks-lib/")) {
            File file = new File(libDir.getParent(), jarEntry.getName());
            InputStream jarInputStream = jarFile.getInputStream(jarEntry);
            try (BufferedInputStream in = new BufferedInputStream(jarInputStream);
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                int read;
                while ((read = in.read()) != -1) {
                    out.write(read);
                }
            }
        }
    }

    private static void deleteOldJars() throws IOException {
        Files.walk(Paths.get(QuickbooksUtil.getQbLibDir(), new String[0]), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".jar")).forEach(QuickbooksClassloader::deleteJarFile);
    }

    private static void deleteJarFile(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            LOG.error("Failed to delete JAR", (Throwable)e);
        }
    }
}

