/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.spark.quickbooks.source;

import inetsoft.spark.quickbooks.SparkSchema;
import inetsoft.spark.quickbooks.source.QuickbooksStreamReader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickbooksPartitionReader
implements PartitionReader<InternalRow> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Object currObj;
    private final Iterator<Object> entitiesIter;
    private final SparkSchema schema;

    public QuickbooksPartitionReader(QuickbooksStreamReader reader, SparkSchema schema) {
        this.entitiesIter = reader.getEntities().iterator();
        this.schema = schema;
    }

    public boolean next() {
        this.currObj = this.entitiesIter.hasNext() ? this.entitiesIter.next() : null;
        return this.currObj != null;
    }

    public void close() {
    }

    public InternalRow get() {
        return this.createRow(this.currObj, this.schema);
    }

    private InternalRow createRow(Object data, SparkSchema dataSchema) {
        StructField[] fields;
        if (data == null || dataSchema == null) {
            return null;
        }
        ArrayList<Object> cells = new ArrayList<Object>();
        StructType structType = dataSchema.getStructType();
        for (StructField structField : fields = structType.fields()) {
            Object result = this.getObjectByField(data, structField, dataSchema);
            cells.add(result);
        }
        return new GenericInternalRow(cells.toArray());
    }

    private Object getObjectByField(Object parentObject, StructField field, SparkSchema parentSchema) {
        String name = field.name();
        String[] tokens = name.split("_");
        String fieldName = tokens[0];
        SparkSchema schema = parentSchema.getSchema(fieldName);
        String methodName = parentSchema.getMethodName(fieldName);
        Object result = this.callMethodOnObject(parentObject, methodName);
        if (schema != null && schema.isFlattened()) {
            SparkSchema currentParent = parentSchema;
            for (int i = 1; i < tokens.length; ++i) {
                String parent = tokens[i - 1];
                String token = tokens[i];
                if (result != null) {
                    StructType parentStructType = currentParent.getStructType();
                    StructField parentField = parentStructType.apply(parent);
                    if (parentField.dataType() instanceof ArrayType && result instanceof Collection) {
                        int size = ((Collection)result).size();
                        if (size <= 0) {
                            return null;
                        }
                        int index = Integer.parseInt(token);
                        token = tokens[++i];
                        if (index >= size) {
                            return null;
                        }
                        Object[] objects = ((Collection)result).toArray();
                        result = objects[index];
                    }
                } else {
                    return null;
                }
                currentParent = currentParent.getSchema(parent);
                String meth = currentParent.getMethodName(token);
                result = this.callMethodOnObject(result, meth);
            }
        }
        if (result == null) {
            return null;
        }
        if (field.dataType() instanceof ArrayType) {
            ArrayList childCells = new ArrayList();
            Iterator<Object> iterator = ((Collection)result).iterator();
            iterator.forEachRemaining(obj -> childCells.add(this.createRow(obj, schema)));
            result = ArrayData.toArrayData((Object)childCells.toArray());
        } else if (field.dataType() instanceof StructType) {
            result = this.createRow(result, schema);
        } else if (result instanceof Date) {
            result = ((Date)result).getTime();
        } else if (result instanceof Enum) {
            result = UTF8String.fromString((String)result.toString());
        } else if (result instanceof String) {
            result = UTF8String.fromString((String)((String)result));
        } else if (result instanceof BigDecimal) {
            result = Decimal.apply((BigDecimal)((BigDecimal)result));
        }
        return result;
    }

    private Object callMethodOnObject(Object bean, String methodName) {
        if (methodName == null) {
            return null;
        }
        try {
            Method method = bean.getClass().getMethod(methodName, new Class[0]);
            return method.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Failed to get data from object, using null", (Throwable)e);
            return null;
        }
    }
}

