/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.spark.quickbooks.source;

import inetsoft.spark.quickbooks.QuickbooksAPI;
import inetsoft.spark.quickbooks.QuickbooksDataSourceOptions;
import inetsoft.spark.quickbooks.SparkSchema;
import inetsoft.spark.quickbooks.SparkSchemaGenerator;
import inetsoft.spark.quickbooks.source.QuickbooksClassloader;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickbooksStreamReader
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final QuickbooksDataSourceOptions options;

    public QuickbooksStreamReader(QuickbooksDataSourceOptions options) {
        this.options = options;
    }

    public List<Object> getEntities() {
        return this.getEntities(false);
    }

    public SparkSchema getSchema() {
        List<Object> entities = this.getEntities(true);
        SparkSchema sparkSchema = new SparkSchemaGenerator().generateSchema(entities.toArray());
        return this.options.isExpandStructs() ? sparkSchema.flatten(this.options.isExpandArrays()) : sparkSchema;
    }

    private List<Object> getEntities(boolean schemaOnly) {
        this.options.setSchemaOnly(schemaOnly);
        try {
            QuickbooksClassloader classLoader = QuickbooksClassloader.create(this.getClass().getClassLoader());
            Class<?> aClass = classLoader.loadClass("inetsoft.spark.quickbooks.QuickbooksRuntime");
            QuickbooksAPI api = (QuickbooksAPI)aClass.newInstance();
            QuickbooksAPI.QuickbooksQueryResult result = api.loadData(this.options);
            return Collections.unmodifiableList(result.getEntities());
        }
        catch (Exception e) {
            LOG.error("Failed to execute quickbooks query", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

